/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol.jmx;

import javax.net.ssl.SSLContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.hawkular.agent.monitor.inventory.ConnectionData;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.jolokia.client.BasicAuthenticator;
import org.jolokia.client.J4pClient;

public class JmxClientFactory {
    private final MonitoredEndpoint endpoint;

    public JmxClientFactory(MonitoredEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public J4pClient createClient() {
        ConnectionData cnData = this.endpoint.getConnectionData();
        SSLContext sslContext = this.endpoint.getSSLContext();
        BasicAuthenticator authenticator = sslContext != null && cnData.getUri().getScheme().equalsIgnoreCase("https") ? new SecureBasicAuthenticator(sslContext) : new BasicAuthenticator();
        J4pClient client = J4pClient.url((String)cnData.getUri().toString()).user(cnData.getUsername()).password(cnData.getPassword()).authenticator(authenticator.preemptive()).connectionTimeout(60000).build();
        return client;
    }

    private static class SecureBasicAuthenticator
    extends BasicAuthenticator {
        private final SSLContext sslContext;

        public SecureBasicAuthenticator(SSLContext sslContext) {
            this.sslContext = sslContext;
        }

        public void authenticate(HttpClientBuilder pBuilder, String pUser, String pPassword) {
            pBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(this.sslContext));
            super.authenticate(pBuilder, pUser, pPassword);
        }
    }
}

