/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.scheduler;

import java.util.List;
import org.hawkular.agent.monitor.api.InventoryEvent;
import org.hawkular.agent.monitor.api.InventoryListener;
import org.hawkular.agent.monitor.api.SamplingService;
import org.hawkular.agent.monitor.diagnostics.Diagnostics;
import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.inventory.MetricType;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.scheduler.MeasurementScheduler;
import org.hawkular.agent.monitor.scheduler.SchedulerConfiguration;
import org.hawkular.agent.monitor.service.ServiceStatus;
import org.hawkular.agent.monitor.storage.AvailBufferedStorageDispatcher;
import org.hawkular.agent.monitor.storage.AvailDataPoint;
import org.hawkular.agent.monitor.storage.MetricBufferedStorageDispatcher;
import org.hawkular.agent.monitor.storage.MetricDataPoint;
import org.hawkular.agent.monitor.storage.StorageAdapter;

public class SchedulerService
implements InventoryListener {
    private static final MsgLogger log = AgentLoggers.getLogger(SchedulerService.class);
    private final Diagnostics diagnostics;
    private final MeasurementScheduler<Object, MetricType<Object>, MetricDataPoint> metricScheduler;
    private final MeasurementScheduler<Object, AvailType<Object>, AvailDataPoint> availScheduler;
    private final MetricBufferedStorageDispatcher metricStorage;
    private final AvailBufferedStorageDispatcher availStorage;
    protected volatile ServiceStatus status = ServiceStatus.INITIAL;

    public SchedulerService(SchedulerConfiguration configuration, Diagnostics diagnostics, StorageAdapter storageAdapter) {
        this.diagnostics = diagnostics;
        this.metricStorage = new MetricBufferedStorageDispatcher(configuration, storageAdapter, diagnostics);
        this.metricScheduler = MeasurementScheduler.forMetrics("Hawkular-WildFly-Agent-Scheduler-Metrics", this.metricStorage);
        this.availStorage = new AvailBufferedStorageDispatcher(configuration, storageAdapter, diagnostics);
        this.availScheduler = MeasurementScheduler.forAvails("Hawkular-WildFly-Agent-Scheduler-Avail", this.availStorage);
    }

    public void start() {
        this.status.assertInitialOrStopped(this.getClass(), "start()");
        this.status = ServiceStatus.STARTING;
        log.infoStartingScheduler();
        this.metricStorage.start();
        this.metricScheduler.start();
        this.availStorage.start();
        this.availScheduler.start();
        this.status = ServiceStatus.RUNNING;
    }

    public void stop() {
        this.status.assertRunning(this.getClass(), "stop()");
        this.status = ServiceStatus.STOPPING;
        log.infoStoppingScheduler();
        this.metricStorage.shutdown();
        this.availStorage.shutdown();
        this.metricScheduler.stop();
        this.availScheduler.stop();
        this.status = ServiceStatus.STOPPED;
    }

    @Override
    public <L> void resourcesAdded(InventoryEvent<L> event) {
        List<Resource<L>> resources = event.getPayload();
        SamplingService<L> service = event.getSamplingService();
        log.debugf("Scheduling jobs for [%d] new resources for endpoint [%s]", resources.size(), service.getEndpoint());
        this.metricScheduler.schedule(service, resources);
        this.availScheduler.schedule(service, resources);
    }

    @Override
    public <L> void resourceRemoved(InventoryEvent<L> event) {
        List<Resource<L>> resources = event.getPayload();
        SamplingService<L> service = event.getSamplingService();
        log.debugf("Unscheduling jobs for [%d] obsolete resources for endpoint [%s]", resources.size(), service.getEndpoint());
        this.metricScheduler.unschedule(service, resources);
        this.availScheduler.unschedule(service, resources);
    }
}

