/*
 * Decompiled with CFR 0.152.
 */
package rx;

import java.util.concurrent.TimeUnit;
import rx.Subscription;
import rx.functions.Action0;
import rx.subscriptions.MultipleAssignmentSubscription;

public abstract class Scheduler {
    public abstract Worker createWorker();

    public long now() {
        return System.currentTimeMillis();
    }

    public static abstract class Worker
    implements Subscription {
        public abstract Subscription schedule(Action0 var1);

        public abstract Subscription schedule(Action0 var1, long var2, TimeUnit var4);

        public Subscription schedulePeriodically(final Action0 action, long initialDelay, long period, TimeUnit unit) {
            final long periodInNanos = unit.toNanos(period);
            final long startInNanos = TimeUnit.MILLISECONDS.toNanos(this.now()) + unit.toNanos(initialDelay);
            final MultipleAssignmentSubscription mas = new MultipleAssignmentSubscription();
            Action0 recursiveAction = new Action0(){
                long count = 0L;

                @Override
                public void call() {
                    if (!mas.isUnsubscribed()) {
                        action.call();
                        long nextTick = startInNanos + ++this.count * periodInNanos;
                        mas.set(Worker.this.schedule(this, nextTick - TimeUnit.MILLISECONDS.toNanos(Worker.this.now()), TimeUnit.NANOSECONDS));
                    }
                }
            };
            MultipleAssignmentSubscription s = new MultipleAssignmentSubscription();
            mas.set(s);
            s.set(this.schedule(recursiveAction, initialDelay, unit));
            return mas;
        }

        public long now() {
            return System.currentTimeMillis();
        }
    }
}

