/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.internal.operators.BackpressureUtils;

public final class OnSubscribeFromIterable<T>
implements Observable.OnSubscribe<T> {
    final Iterable<? extends T> is;

    public OnSubscribeFromIterable(Iterable<? extends T> iterable) {
        if (iterable == null) {
            throw new NullPointerException("iterable must not be null");
        }
        this.is = iterable;
    }

    @Override
    public void call(Subscriber<? super T> o) {
        Iterator<? extends T> it = this.is.iterator();
        o.setProducer(new IterableProducer(o, it));
    }

    private static final class IterableProducer<T>
    implements Producer {
        private final Subscriber<? super T> o;
        private final Iterator<? extends T> it;
        private volatile long requested = 0L;
        private static final AtomicLongFieldUpdater<IterableProducer> REQUESTED_UPDATER = AtomicLongFieldUpdater.newUpdater(IterableProducer.class, "requested");

        private IterableProducer(Subscriber<? super T> o, Iterator<? extends T> it) {
            this.o = o;
            this.it = it;
        }

        @Override
        public void request(long n) {
            long _c;
            if (REQUESTED_UPDATER.get(this) == Long.MAX_VALUE) {
                return;
            }
            if (n == Long.MAX_VALUE) {
                REQUESTED_UPDATER.set(this, n);
                while (this.it.hasNext()) {
                    if (this.o.isUnsubscribed()) {
                        return;
                    }
                    this.o.onNext(this.it.next());
                }
                if (!this.o.isUnsubscribed()) {
                    this.o.onCompleted();
                }
            } else if (n > 0L && (_c = BackpressureUtils.getAndAddRequest(REQUESTED_UPDATER, this, n)) == 0L) {
                long r;
                do {
                    long numToEmit = r = this.requested;
                    while (this.it.hasNext() && --numToEmit >= 0L) {
                        if (this.o.isUnsubscribed()) {
                            return;
                        }
                        this.o.onNext(this.it.next());
                    }
                    if (this.it.hasNext()) continue;
                    if (!this.o.isUnsubscribed()) {
                        this.o.onCompleted();
                    }
                    return;
                } while (REQUESTED_UPDATER.addAndGet(this, -r) != 0L);
                return;
            }
        }
    }
}

