/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.internal.operators.OperatorMulticast;
import rx.observables.ConnectableObservable;
import rx.observers.SafeSubscriber;
import rx.subjects.Subject;

public final class OnSubscribeMulticastSelector<TInput, TIntermediate, TResult>
implements Observable.OnSubscribe<TResult> {
    final Observable<? extends TInput> source;
    final Func0<? extends Subject<? super TInput, ? extends TIntermediate>> subjectFactory;
    final Func1<? super Observable<TIntermediate>, ? extends Observable<TResult>> resultSelector;

    public OnSubscribeMulticastSelector(Observable<? extends TInput> source, Func0<? extends Subject<? super TInput, ? extends TIntermediate>> subjectFactory, Func1<? super Observable<TIntermediate>, ? extends Observable<TResult>> resultSelector) {
        this.source = source;
        this.subjectFactory = subjectFactory;
        this.resultSelector = resultSelector;
    }

    @Override
    public void call(Subscriber<? super TResult> child) {
        Observable<TResult> observable;
        OperatorMulticast connectable;
        try {
            connectable = new OperatorMulticast(this.source, this.subjectFactory);
            observable = this.resultSelector.call(connectable);
        }
        catch (Throwable t) {
            child.onError(t);
            return;
        }
        final SafeSubscriber<? super TResult> s = new SafeSubscriber<TResult>(child);
        observable.unsafeSubscribe(s);
        ((ConnectableObservable)connectable).connect(new Action1<Subscription>(){

            @Override
            public void call(Subscription t1) {
                s.add(t1);
            }
        });
    }
}

