/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayDeque;
import rx.Observable;
import rx.Subscriber;
import rx.internal.operators.NotificationLite;
import rx.internal.operators.TakeLastQueueProducer;

public final class OperatorTakeLast<T>
implements Observable.Operator<T, T> {
    private final int count;

    public OperatorTakeLast(int count) {
        if (count < 0) {
            throw new IndexOutOfBoundsException("count could not be negative");
        }
        this.count = count;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> subscriber) {
        final ArrayDeque<Object> deque = new ArrayDeque<Object>();
        final NotificationLite notification = NotificationLite.instance();
        final TakeLastQueueProducer<? super T> producer = new TakeLastQueueProducer<T>(notification, deque, subscriber);
        subscriber.setProducer(producer);
        return new Subscriber<T>(subscriber){

            @Override
            public void onStart() {
                this.request(Long.MAX_VALUE);
            }

            @Override
            public void onCompleted() {
                deque.offer(notification.completed());
                producer.startEmitting();
            }

            @Override
            public void onError(Throwable e) {
                deque.clear();
                subscriber.onError(e);
            }

            @Override
            public void onNext(T value) {
                if (OperatorTakeLast.this.count == 0) {
                    return;
                }
                if (deque.size() == OperatorTakeLast.this.count) {
                    deque.removeFirst();
                }
                deque.offerLast(notification.next(value));
            }
        };
    }
}

