/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.dynamicprotocol;

import java.util.HashSet;
import java.util.Set;
import org.hawkular.agent.monitor.dynamicprotocol.MetricMetadata;
import org.hawkular.agent.monitor.inventory.Name;

public class MetricSetMetadata {
    private final Name name;
    private final boolean enabled;
    private final Set<MetricMetadata> metrics;

    public static Builder builder() {
        return new Builder();
    }

    private MetricSetMetadata(Name name, boolean enabled, Set<MetricMetadata> metrics) {
        this.name = name;
        this.enabled = enabled;
        this.metrics = metrics;
    }

    public Name getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Set<MetricMetadata> getMetrics() {
        return this.metrics;
    }

    public static class Builder {
        private Name name;
        private boolean enabled;
        private Set<MetricMetadata> metrics = new HashSet<MetricMetadata>();

        public Builder name(Name name) {
            this.name = name;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder metric(MetricMetadata metric) {
            this.metrics.add(metric);
            return this;
        }

        public MetricSetMetadata build() {
            return new MetricSetMetadata(this.name, this.enabled, this.metrics);
        }
    }
}

