/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.extension;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.hawkular.metrics.client.common.MetricType;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class MetricTypeValidator
extends ModelTypeValidator
implements AllowedValuesValidator {
    public static final MetricTypeValidator ANY_REQUIRED = new MetricTypeValidator(false, true);
    public static final MetricTypeValidator ANY_OPTIONAL = new MetricTypeValidator(true, true);
    private final EnumSet<MetricType> allowedValues;

    public MetricTypeValidator(boolean nullable, MetricType ... allowed) {
        this(nullable, true, allowed);
    }

    public MetricTypeValidator(boolean nullable, boolean allowExpressions) {
        super(ModelType.STRING, nullable, allowExpressions);
        this.allowedValues = EnumSet.allOf(MetricType.class);
    }

    public MetricTypeValidator(boolean nullable, boolean allowExpressions, MetricType ... allowed) {
        super(ModelType.STRING, nullable, allowExpressions);
        this.allowedValues = EnumSet.noneOf(MetricType.class);
        for (MetricType mt : allowed) {
            this.allowedValues.add(mt);
        }
    }

    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        String mtString;
        MetricType mt;
        super.validateParameter(parameterName, value);
        if (value.isDefined() && ((mt = MetricType.valueOf((String)(mtString = value.asString()).toUpperCase(Locale.ENGLISH))) == null || !this.allowedValues.contains(mt))) {
            throw new OperationFailedException("Bad value [" + mtString + "] for param [" + parameterName + "]");
        }
    }

    public List<ModelNode> getAllowedValues() {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        for (MetricType mt : this.allowedValues) {
            result.add(new ModelNode().set(mt.name()));
        }
        return result;
    }
}

