/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Hashes;
import org.hawkular.inventory.api.model.StructuredData;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.base.spi.CommitFailureException;
import org.hawkular.inventory.base.spi.ElementNotFoundException;
import org.hawkular.inventory.base.spi.InventoryBackend;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.RelativePath;

public class DelegatingInventoryBackend<E>
implements InventoryBackend<E> {
    protected final InventoryBackend<E> backend;

    public DelegatingInventoryBackend(InventoryBackend<E> backend) {
        this.backend = backend;
    }

    @Override
    public boolean isUniqueIndexSupported() {
        return this.backend.isUniqueIndexSupported();
    }

    @Override
    public boolean isPreferringBigTransactions() {
        return this.backend.isPreferringBigTransactions();
    }

    @Override
    public void commit() throws CommitFailureException {
        this.backend.commit();
    }

    @Override
    public <T> T convert(E entityRepresentation, Class<T> entityType) {
        return this.backend.convert(entityRepresentation, entityType);
    }

    @Override
    public void delete(E entity) {
        this.backend.delete(entity);
    }

    @Override
    public void deleteStructuredData(E dataRepresentation) {
        this.backend.deleteStructuredData(dataRepresentation);
    }

    @Override
    public E descendToData(E dataEntityRepresentation, RelativePath dataPath) {
        return this.backend.descendToData(dataEntityRepresentation, dataPath);
    }

    @Override
    public CanonicalPath extractCanonicalPath(E entityRepresentation) {
        return this.backend.extractCanonicalPath(entityRepresentation);
    }

    @Override
    public String extractIdentityHash(E entityRepresentation) {
        return this.backend.extractIdentityHash(entityRepresentation);
    }

    @Override
    public String extractContentHash(E entityRepresentation) {
        return this.backend.extractContentHash(entityRepresentation);
    }

    @Override
    public String extractSyncHash(E entityRepresentation) {
        return this.backend.extractSyncHash(entityRepresentation);
    }

    @Override
    public String extractId(E entityRepresentation) {
        return this.backend.extractId(entityRepresentation);
    }

    @Override
    public String extractRelationshipName(E relationship) {
        return this.backend.extractRelationshipName(relationship);
    }

    @Override
    public Class<?> extractType(E entityRepresentation) {
        return this.backend.extractType(entityRepresentation);
    }

    @Override
    public E find(CanonicalPath element) throws ElementNotFoundException {
        return this.backend.find(element);
    }

    @Override
    public E querySingle(Query query) {
        return this.backend.querySingle(query);
    }

    @Override
    public E traverseToSingle(E startingPoint, Query query) {
        return this.backend.traverseToSingle(startingPoint, query);
    }

    @Override
    public InputStream getGraphSON(String tenantId) {
        return this.backend.getGraphSON(tenantId);
    }

    @Override
    public E getRelationship(E source, E target, String relationshipName) throws ElementNotFoundException {
        return this.backend.getRelationship(source, target, relationshipName);
    }

    @Override
    public Set<E> getRelationships(E entity, Relationships.Direction direction, String ... names) {
        return this.backend.getRelationships(entity, direction, names);
    }

    @Override
    public E getRelationshipSource(E relationship) {
        return this.backend.getRelationshipSource(relationship);
    }

    @Override
    public E getRelationshipTarget(E relationship) {
        return this.backend.getRelationshipTarget(relationship);
    }

    @Override
    public <T extends Entity<?, ?>> Iterator<T> getTransitiveClosureOver(CanonicalPath startingPoint, Relationships.Direction direction, Class<T> clazz, String ... relationshipNames) {
        return this.backend.getTransitiveClosureOver(startingPoint, direction, clazz, relationshipNames);
    }

    @Override
    public Iterator<E> getTransitiveClosureOver(E startingPoint, Relationships.Direction direction, String ... relationshipNames) {
        return this.backend.getTransitiveClosureOver(startingPoint, direction, relationshipNames);
    }

    @Override
    public boolean hasRelationship(E entity, Relationships.Direction direction, String relationshipName) {
        return this.backend.hasRelationship((Relationships.Direction)((Object)entity), direction, relationshipName);
    }

    @Override
    public boolean hasRelationship(E source, E target, String relationshipName) {
        return this.backend.hasRelationship(source, target, relationshipName);
    }

    @Override
    public E persist(CanonicalPath path, Blueprint blueprint) {
        return this.backend.persist(path, blueprint);
    }

    @Override
    public E persist(StructuredData structuredData) {
        return this.backend.persist(structuredData);
    }

    @Override
    public Page<E> query(Query query, Pager pager) {
        return this.backend.query(query, pager);
    }

    @Override
    public <T> Page<T> query(Query query, Pager pager, Function<E, T> conversion, Function<T, Boolean> filter) {
        return this.backend.query(query, pager, conversion, filter);
    }

    @Override
    public E relate(E sourceEntity, E targetEntity, String name, Map<String, Object> properties) {
        return this.backend.relate(sourceEntity, targetEntity, name, properties);
    }

    @Override
    public void rollback() {
        this.backend.rollback();
    }

    @Override
    public boolean isBackendInternal(E element) {
        return this.backend.isBackendInternal(element);
    }

    @Override
    public InventoryBackend<E> startTransaction() {
        return this.backend.startTransaction();
    }

    @Override
    public Page<E> traverse(E startingPoint, Query query, Pager pager) {
        return this.backend.traverse(startingPoint, query, pager);
    }

    @Override
    public void update(E entity, AbstractElement.Update update) {
        this.backend.update(entity, update);
    }

    @Override
    public void updateHashes(E entity, Hashes hashes) {
        this.backend.updateHashes(entity, hashes);
    }

    @Override
    public void close() throws Exception {
        this.backend.close();
    }

    @Override
    public boolean requiresRollbackAfterFailure(Throwable t) {
        return this.backend.requiresRollbackAfterFailure(t);
    }
}

