/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.cmd;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.hawkular.agent.monitor.cmd.AbstractDMRResourcePathCommand;
import org.hawkular.agent.monitor.cmd.CommandContext;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.hawkular.agent.monitor.protocol.dmr.DMRSession;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.cmdgw.api.AddJdbcDriverRequest;
import org.hawkular.cmdgw.api.AddJdbcDriverResponse;
import org.hawkular.cmdgw.api.ResponseStatus;
import org.hawkular.dmr.api.OperationBuilder;
import org.hawkular.dmr.api.SubsystemDatasourceConstants;
import org.hawkular.dmrclient.modules.AddModuleRequest;
import org.hawkular.dmrclient.modules.Modules;
import org.jboss.as.controller.client.ModelControllerClient;

public class AddJdbcDriverCommand
extends AbstractDMRResourcePathCommand<AddJdbcDriverRequest, AddJdbcDriverResponse>
implements SubsystemDatasourceConstants,
SubsystemDatasourceConstants.JdbcDriverNodeConstants {
    public static final Set<String> DEFAULT_DRIVER_MODULE_DEPENDENCIES = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("javax.api", "javax.transaction.api")));
    public static final Class<AddJdbcDriverRequest> REQUEST_CLASS = AddJdbcDriverRequest.class;

    public AddJdbcDriverCommand() {
        super("Add", "JDBC Driver");
    }

    @Override
    protected AddJdbcDriverResponse createResponse() {
        return new AddJdbcDriverResponse();
    }

    @Override
    protected BinaryData execute(ModelControllerClient controllerClient, EndpointService<DMRNodeLocation, DMRSession> endpointService, String modelNodePath, BasicMessageWithExtraData<AddJdbcDriverRequest> envelope, AddJdbcDriverResponse response, CommandContext context, DMRSession dmrContext) throws Exception {
        AddJdbcDriverRequest request = (AddJdbcDriverRequest)envelope.getBasicMessage();
        response.setDriverName(request.getDriverName());
        AddModuleRequest.ModuleResource jarResource = new AddModuleRequest.ModuleResource((InputStream)envelope.getBinaryData(), request.getDriverJarName());
        AddModuleRequest addModuleRequest = new AddModuleRequest(request.getModuleName(), (String)null, (String)null, Collections.singleton(jarResource), DEFAULT_DRIVER_MODULE_DEPENDENCIES, null);
        new Modules(Modules.findModulesDir()).add(addModuleRequest);
        OperationBuilder.OperationResult opResult = ((OperationBuilder.AddOperationBuilder)OperationBuilder.add().address().subsystemDatasources().segment("jdbc-driver", request.getDriverName()).parentBuilder()).attribute("driver-name", request.getDriverName()).attribute("driver-module-name", request.getModuleName()).attribute("driver-class-name", request.getDriverClass()).attribute("driver-major-version", request.getDriverMajorVersion()).attribute("driver-minor-version", request.getDriverMinorVersion()).attribute("driver-xa-datasource-class-name", request.getDriverXaDatasourceClassName()).attribute("jdbc-compliant", request.getJdbcCompliant()).execute(controllerClient).assertSuccess();
        this.setServerRefreshIndicator(opResult, response);
        endpointService.discoverAll();
        return null;
    }

    @Override
    protected void success(BasicMessageWithExtraData<AddJdbcDriverRequest> envelope, AddJdbcDriverResponse response) {
        response.setStatus(ResponseStatus.OK);
        response.setMessage(String.format("Added JDBC Driver: %s", ((AddJdbcDriverRequest)envelope.getBasicMessage()).getDriverName()));
    }

    @Override
    protected void validate(String modelNodePath, BasicMessageWithExtraData<AddJdbcDriverRequest> envelope) {
    }

    @Override
    protected void validate(BasicMessageWithExtraData<AddJdbcDriverRequest> envelope, MonitoredEndpoint<? extends AgentCoreEngineConfiguration.AbstractEndpointConfiguration> endpoint) {
        this.assertLocalDMRServer(endpoint);
    }
}

