/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.cmdgw.api;

import java.io.IOException;
import java.io.InputStream;
import org.hawkular.bus.common.AbstractMessage;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.BinaryData;

public class ApiDeserializer {
    private static final String API_PKG = ApiDeserializer.class.getPackage().getName();

    public static String toHawkularFormat(BasicMessage msg) {
        return String.format("%s=%s", msg.getClass().getSimpleName(), msg.toJSON());
    }

    public static BinaryData toHawkularFormat(BasicMessage msg, InputStream extraData) {
        String msgJson = ApiDeserializer.toHawkularFormat(msg);
        return new BinaryData(msgJson.getBytes(), extraData);
    }

    private static String[] fromHawkularFormat(String msg) {
        String[] nameAndJsonArray = msg.split("=", 2);
        if (nameAndJsonArray.length != 2) {
            throw new IllegalArgumentException("Cannot deserialize: [" + msg + "]");
        }
        return nameAndJsonArray;
    }

    public <T extends BasicMessage> BasicMessageWithExtraData<T> deserialize(String nameAndJson) {
        String[] nameAndJsonArray = ApiDeserializer.fromHawkularFormat(nameAndJson);
        String name = nameAndJsonArray[0];
        String json = nameAndJsonArray[1];
        if (name.indexOf(".") == -1) {
            name = String.format("%s.%s", API_PKG, name);
        }
        try {
            Class<?> pojo = Class.forName(name);
            return new BasicMessageWithExtraData(AbstractMessage.fromJSON((String)json, pojo), null);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot deserialize: [" + nameAndJson + "]", e);
        }
    }

    public <T extends BasicMessage> BasicMessageWithExtraData<T> deserialize(InputStream input) {
        StringBuilder nameBuilder = new StringBuilder();
        boolean foundSeparator = false;
        while (!foundSeparator) {
            int currentChar;
            try {
                currentChar = input.read();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Cannot deserialize stream due to read error", ioe);
            }
            if (currentChar == -1) {
                throw new RuntimeException("Cannot deserialize stream - doesn't look valid");
            }
            if (currentChar == 61) {
                foundSeparator = true;
                continue;
            }
            nameBuilder.append((char)currentChar);
        }
        String name = nameBuilder.toString();
        if (name.indexOf(".") == -1) {
            name = String.format("%s.%s", API_PKG, name);
        }
        try {
            Class<?> pojo = Class.forName(name);
            BasicMessageWithExtraData results = AbstractMessage.fromJSON((InputStream)input, pojo);
            return results;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot deserialize stream with object [" + name + "]", e);
        }
    }
}

