/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import io.swagger.annotations.ApiModel;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.EmptyRelativePath;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Helper;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.paths.ElementTypeVisitor;
import org.hawkular.inventory.paths.Path;
import org.hawkular.inventory.paths.RelativePath;
import org.hawkular.inventory.paths.SegmentType;

public interface InventoryStructure<Root extends Entity.Blueprint> {
    public static <B extends Entity.Blueprint> Builder<B> of(B root) {
        return InventoryStructure.of(root, null);
    }

    public static <B extends Entity.Blueprint> Builder<B> of(B root, Object attachment) {
        return Offline.of(root, attachment);
    }

    public Root getRoot();

    public <E extends Entity, B extends Entity.Blueprint> Stream<B> getChildren(RelativePath var1, Class<E> var2);

    default public <E extends Entity, B extends Entity.Blueprint> Stream<FullNode> getChildNodes(RelativePath parent, Class<E> childType) {
        SegmentType childSegmentType = Inventory.types().byElement(childType).getSegmentType();
        return this.getChildren(parent, childType).map(b -> {
            RelativePath childPath = parent.modified().extend(childSegmentType, b.getId()).get();
            return this.getNode(childPath);
        }).filter(Objects::nonNull);
    }

    public Entity.Blueprint get(RelativePath var1);

    default public FullNode getNode(RelativePath path) {
        Entity.Blueprint bl = this.get(path);
        return bl == null ? null : new FullNode(bl, null);
    }

    default public Stream<Entity.Blueprint> getAllChildren(RelativePath parent) {
        return this.getAllChildNodes(parent).map(FullNode::getEntity);
    }

    default public Stream<FullNode> getAllChildNodes(RelativePath parent) {
        Stream<FullNode> ret = Stream.empty();
        RelativePath.Extender check = RelativePath.empty().extend(Blueprint.getSegmentTypeOf(this.getRoot()), ((Entity.Blueprint)this.getRoot()).getId()).extend((Collection)parent.getPath());
        for (EntityType et : EntityType.values()) {
            List res;
            SegmentType st = et.segmentType;
            if (!check.canExtendTo(st).booleanValue()) continue;
            Class<? extends Entity> entityType = Entity.entityTypeFromSegmentType(st);
            try (Stream<FullNode> next = this.getChildNodes(parent, entityType);){
                res = next.collect(Collectors.toList());
            }
            ret = Stream.concat(ret, res.stream());
        }
        return ret;
    }

    @Deprecated
    default public Stream<FullNode> getAllChildrenWithAttachments(RelativePath parent) {
        return this.getAllChildNodes(parent);
    }

    public static final class ChildBuilder<ParentBuilder extends AbstractBuilder<?>>
    extends AbstractBuilder<ChildBuilder<ParentBuilder>> {
        final ParentBuilder parentBuilder;

        private ChildBuilder(ParentBuilder parentBuilder, RelativePath parent, Map<RelativePath, FullNode> blueprints, Map<RelativePath, Map<EntityType, Set<FullNode>>> children) {
            super(parent, blueprints, children);
            this.parentBuilder = parentBuilder;
        }

        public ParentBuilder end() {
            return this.parentBuilder;
        }

        public ParentBuilder remove() {
            this.removeAllChildren();
            Set<FullNode> siblings = this.getSiblings();
            FullNode myBlueprint = (FullNode)this.blueprints.remove(this.myPath);
            siblings.remove(myBlueprint);
            return this.parentBuilder;
        }

        @Override
        void doReplace(Entity.Blueprint blueprint, Object attachment) {
            Set<FullNode> siblings = this.getSiblings();
            FullNode myBlueprint = (FullNode)this.blueprints.remove(this.myPath);
            siblings.remove(myBlueprint);
            FullNode myNode = new FullNode(blueprint, attachment);
            siblings.add(myNode);
            this.children.remove(this.myPath);
            this.myPath = ((AbstractBuilder)this.parentBuilder).myPath.modified().extend(Blueprint.getSegmentTypeOf(blueprint), blueprint.getId()).get();
            this.blueprints.put(this.myPath, myNode);
        }

        private Set<FullNode> getSiblings() {
            FullNode myBlueprint = (FullNode)this.blueprints.get(this.myPath);
            Map siblingsByType = (Map)this.children.get(((AbstractBuilder)this.parentBuilder).myPath);
            EntityType myType = EntityType.of(Blueprint.getEntityTypeOf(myBlueprint.getEntity()));
            return (Set)siblingsByType.get((Object)myType);
        }

        /* synthetic */ ChildBuilder(AbstractBuilder x0, RelativePath x1, Map x2, Map x3, 1 x4) {
            this(x0, x1, (Map<RelativePath, FullNode>)x2, x3);
        }
    }

    public static final class Builder<Root extends Entity.Blueprint>
    extends AbstractBuilder<Builder<Root>> {
        private final Root root;

        private Builder(Root root, Object attachment, RelativePath myPath, Map<RelativePath, FullNode> blueprints, Map<RelativePath, Map<EntityType, Set<FullNode>>> children) {
            super(myPath, blueprints, children);
            this.root = root;
            this.blueprints.put(EmptyRelativePath.I, new FullNode((Entity.Blueprint)root, attachment));
        }

        public Builder(Root root) {
            this(root, null);
        }

        public Builder(Root root, Object attachment) {
            this(root, attachment, EmptyRelativePath.I, new HashMap<RelativePath, FullNode>(), new HashMap<RelativePath, Map<EntityType, Set<FullNode>>>());
        }

        public Offline<Root> build() {
            return new Offline((Entity.Blueprint)this.root, this.blueprints, this.children, null);
        }

        @Override
        void doReplace(Entity.Blueprint blueprint, Object attachment) {
            this.blueprints.put(this.myPath, new FullNode(blueprint, attachment));
            this.children.remove(this.myPath);
        }

        /* synthetic */ Builder(Entity.Blueprint x0, Object x1, RelativePath x2, Map x3, Map x4, 1 x5) {
            this(x0, x1, x2, x3, x4);
        }
    }

    public static abstract class AbstractBuilder<This extends AbstractBuilder<?>> {
        RelativePath myPath;
        final Map<RelativePath, Map<EntityType, Set<FullNode>>> children;
        final Map<RelativePath, FullNode> blueprints;

        private AbstractBuilder(RelativePath myPath, Map<RelativePath, FullNode> blueprints, Map<RelativePath, Map<EntityType, Set<FullNode>>> children) {
            this.myPath = myPath;
            this.children = children;
            this.blueprints = blueprints;
        }

        public ChildBuilder<This> startChild(Entity.Blueprint child) {
            return this.startChild(child, null);
        }

        public ChildBuilder<This> startChild(Entity.Blueprint child, Object childAttachment) {
            RelativePath.Extender extender = this.myPath.modified();
            Class childType = Blueprint.getEntityTypeOf(child);
            SegmentType childSeg = Blueprint.getSegmentTypeOf(child);
            if (!extender.canExtendTo(childSeg).booleanValue()) {
                throw new IllegalArgumentException("Cannot extend path " + this.myPath + " with child of type " + childType);
            }
            RelativePath childPath = extender.extend(childSeg, child.getId()).get();
            Set<FullNode> bls = this.getChildrenOfType(EntityType.of(childType));
            FullNode node = new FullNode(child, childAttachment);
            bls.add(node);
            this.blueprints.put(childPath, node);
            return new ChildBuilder((AbstractBuilder)this.castThis(), childPath, this.blueprints, this.children, null);
        }

        public RelativePath getPath() {
            return this.myPath;
        }

        public Entity.Blueprint getBlueprint() {
            return this.blueprints.get(this.myPath).getEntity();
        }

        public FullNode getNode() {
            return this.blueprints.get(this.myPath);
        }

        public ChildBuilder<This> getChild(Path.Segment childPath) {
            Map<EntityType, Set<FullNode>> myChildren = this.children.get(this.myPath);
            if (myChildren == null) {
                return null;
            }
            EntityType childType = EntityType.of(childPath.getElementType());
            Set<FullNode> childrenOfType = myChildren.get((Object)childType);
            return childrenOfType.stream().filter(child -> child.getEntity().getId().equals(childPath.getElementId())).findAny().map(child -> {
                RelativePath rp = this.myPath.modified().extend(childPath).get();
                return new ChildBuilder((AbstractBuilder)this.castThis(), rp, this.blueprints, this.children, null);
            }).orElse(null);
        }

        public This removeChild(Path.Segment childPath) {
            ChildBuilder<This> childBuilder = this.getChild(childPath);
            if (childBuilder != null) {
                childBuilder.remove();
            }
            return this.castThis();
        }

        public Set<Path.Segment> getChildrenPaths() {
            Map<EntityType, Set<FullNode>> myChildren = this.children.get(this.myPath);
            if (myChildren == null) {
                return Collections.emptySet();
            }
            return myChildren.values().stream().flatMap(Collection::stream).map(b -> new Path.Segment(Blueprint.getSegmentTypeOf(b.getEntity()), b.getEntity().getId())).collect(Collectors.toSet());
        }

        public This removeAllChildren() {
            this.getChildrenPaths().forEach(this::removeChild);
            this.children.remove(this.myPath);
            return this.castThis();
        }

        public This replace(Entity.Blueprint blueprint) {
            return this.replace(blueprint, null);
        }

        public This replace(Entity.Blueprint blueprint, Object attachment) {
            this.removeAllChildren();
            FullNode myBl = this.blueprints.get(this.myPath);
            if (!myBl.getEntity().getClass().equals(blueprint.getClass())) {
                throw new IllegalArgumentException("Blueprint " + blueprint + " not of the same type as " + myBl.getEntity());
            }
            this.doReplace(blueprint, attachment);
            return this.castThis();
        }

        abstract void doReplace(Entity.Blueprint var1, Object var2);

        Set<FullNode> getChildrenOfType(EntityType childType) {
            Map cs = this.children.computeIfAbsent(this.myPath, k -> new EnumMap(EntityType.class));
            return cs.computeIfAbsent(childType, k -> new TreeSet<FullNode>(Helper.ENTITY_ORDER));
        }

        public This addChild(Entity.Blueprint child) {
            return this.addChild(child, null);
        }

        public This addChild(Entity.Blueprint child, Object attachment) {
            this.startChild(child, attachment).end();
            return this.castThis();
        }

        This castThis() {
            return (This)this;
        }
    }

    @ApiModel(value="InventoryStructure")
    public static class Offline<Root extends Entity.Blueprint>
    implements InventoryStructure<Root>,
    Serializable {
        private final Root root;
        private final Map<RelativePath, Map<EntityType, Set<FullNode>>> children;
        private final Map<RelativePath, FullNode> entities;

        private Offline(Root root, Map<RelativePath, FullNode> entities, Map<RelativePath, Map<EntityType, Set<FullNode>>> children) {
            this.root = root;
            this.children = children;
            this.entities = entities;
            if (!entities.containsKey(EmptyRelativePath.I)) {
                entities.put(EmptyRelativePath.I, new FullNode((Entity.Blueprint)root, null));
            }
        }

        public static <R extends Entity.Blueprint> Offline<R> copy(InventoryStructure<R> other) {
            return Offline.copy(other, false);
        }

        public static <R extends Entity.Blueprint> Offline<R> copy(final InventoryStructure<R> other, final boolean withAttachments) {
            List<Entity.Blueprint> acs;
            final HashMap entities = new HashMap();
            ElementTypeVisitor.Simple<Void, RelativePath.Extender> visitor = new ElementTypeVisitor.Simple<Void, RelativePath.Extender>(){

                protected Void defaultAction(SegmentType elementType, RelativePath.Extender parentPath) {
                    Class<?> childType = Entity.typeFromSegmentType(elementType);
                    this.impl(childType, parentPath);
                    return null;
                }

                private <E extends Entity> void impl(Class<E> childType, RelativePath.Extender parent) {
                    SegmentType childSeg = Entity.segmentTypeFromType(childType);
                    if (parent.canExtendTo(childSeg).booleanValue()) {
                        List<FullNode> otherChildren;
                        RelativePath parentPath = parent.get();
                        FullNode parentNode = (FullNode)entities.get(parentPath);
                        if (parentNode == null) {
                            if (parentPath.isDefined()) {
                                throw new IllegalStateException("Could not find the tracked children of a parent " + parentPath + " during inventory structure copy. This is a bug.");
                            }
                            Object att = withAttachments ? other.getNode(EmptyRelativePath.I).getAttachment() : null;
                            parentNode = new FullNode((Entity.Blueprint)other.getRoot(), att);
                            entities.put(parentPath, parentNode);
                        }
                        try (Stream<FullNode> s = other.getChildNodes(parent.get(), childType);){
                            otherChildren = s.collect(Collectors.toList());
                        }
                        otherChildren.forEach(c -> {
                            RelativePath.Extender childPath = parentPath.modified().extend(childSeg, c.getEntity().getId());
                            RelativePath cp = childPath.get();
                            FullNode childNode = (FullNode)entities.get(cp);
                            if (childNode == null) {
                                Object att = withAttachments ? other.getNode(cp).getAttachment() : null;
                                childNode = new FullNode(c.getEntity(), att);
                                entities.put(cp, childNode);
                            }
                            for (SegmentType childChildSeg : SegmentType.values()) {
                                if (!childPath.canExtendTo(childChildSeg).booleanValue() || !EntityType.supports(childChildSeg)) continue;
                                ElementTypeVisitor.accept((SegmentType)childChildSeg, (ElementTypeVisitor)this, (Object)childPath);
                            }
                        });
                    }
                }
            };
            R root = other.getRoot();
            RelativePath empty = EmptyRelativePath.I;
            try (Stream<Entity.Blueprint> s = other.getAllChildren(empty);){
                acs = s.collect(Collectors.toList());
            }
            acs.forEach(arg_0 -> Offline.lambda$copy$0((ElementTypeVisitor)visitor, empty, arg_0));
            HashMap<RelativePath, Map<EntityType, Set<FullNode>>> children = new HashMap<RelativePath, Map<EntityType, Set<FullNode>>>();
            HashMap<RelativePath, FullNode> blueprints = new HashMap<RelativePath, FullNode>();
            for (Map.Entry e : entities.entrySet()) {
                RelativePath entityPath = (RelativePath)e.getKey();
                FullNode entity = (FullNode)e.getValue();
                blueprints.put(entityPath, entity);
                RelativePath parent = entityPath.up();
                if (parent.equals((Object)entityPath)) continue;
                EntityType entityType = EntityType.of(Blueprint.getEntityTypeOf(entity.getEntity()));
                Map childrenByType = children.computeIfAbsent(parent, k -> new HashMap());
                Set childrenBlueprints = childrenByType.computeIfAbsent(entityType, k -> new TreeSet<FullNode>(Helper.ENTITY_ORDER));
                childrenBlueprints.add(entity);
            }
            return new Offline<R>(root, blueprints, children);
        }

        public Builder<Root> asBuilder() {
            RelativePath rootPath = EmptyRelativePath.I;
            Object attachment = this.getNode(rootPath).getAttachment();
            return new Builder((Entity.Blueprint)this.root, attachment, EmptyRelativePath.I, this.entities, this.children, null);
        }

        public static <R extends Entity.Blueprint> Builder<R> of(R root) {
            return Offline.of(root, null);
        }

        public static <R extends Entity.Blueprint> Builder<R> of(R root, Object attachment) {
            return new Builder<R>(root, attachment);
        }

        @Override
        public Root getRoot() {
            return this.root;
        }

        @Override
        public <E extends Entity, B extends Entity.Blueprint> Stream<B> getChildren(RelativePath parent, Class<E> childType) {
            return this.children.getOrDefault(parent, Collections.emptyMap()).getOrDefault((Object)EntityType.of(childType), Collections.emptySet()).stream().map(FullNode::getEntity);
        }

        @Override
        public Entity.Blueprint get(RelativePath path) {
            return this.entities.getOrDefault(path, FullNode.EMPTY).getEntity();
        }

        @Override
        public FullNode getNode(RelativePath path) {
            return this.entities.get(path);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Offline offline = (Offline)o;
            if (!((Entity.Blueprint)this.root).equals(offline.root)) {
                return false;
            }
            if (!this.children.equals(offline.children)) {
                return false;
            }
            return this.entities.equals(offline.entities);
        }

        public int hashCode() {
            int result = ((Entity.Blueprint)this.root).hashCode();
            result = 31 * result + this.children.hashCode();
            result = 31 * result + this.entities.hashCode();
            return result;
        }

        private static /* synthetic */ void lambda$copy$0(ElementTypeVisitor visitor, RelativePath empty, Entity.Blueprint b) {
            Void cfr_ignored_0 = (Void)ElementTypeVisitor.accept((SegmentType)Blueprint.getSegmentTypeOf(b), (ElementTypeVisitor)visitor, (Object)empty.modified());
        }

        /* synthetic */ Offline(Entity.Blueprint x0, Map x1, Map x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    public static enum EntityType {
        feed(Feed.class, Feed.Blueprint.class, SegmentType.f),
        resourceType(ResourceType.class, ResourceType.Blueprint.class, SegmentType.rt),
        metricType(MetricType.class, MetricType.Blueprint.class, SegmentType.mt),
        operationType(OperationType.class, OperationType.Blueprint.class, SegmentType.ot),
        metric(Metric.class, Metric.Blueprint.class, SegmentType.m),
        resource(Resource.class, Resource.Blueprint.class, SegmentType.r),
        dataEntity(DataEntity.class, DataEntity.Blueprint.class, SegmentType.d);

        public final Class<? extends Entity> elementType;
        public final Class<? extends Entity.Blueprint> blueprintType;
        public final SegmentType segmentType;

        public static EntityType of(Class<?> type) {
            for (EntityType t : EntityType.values()) {
                if (!type.equals(t.elementType)) continue;
                return t;
            }
            throw new IllegalArgumentException("Unsupported type of entity: " + type);
        }

        public static EntityType of(SegmentType seg) {
            for (EntityType t : EntityType.values()) {
                if (seg != t.segmentType) continue;
                return t;
            }
            throw new IllegalArgumentException("Unsupported type of path segment: " + seg);
        }

        public static boolean supports(SegmentType seg) {
            for (EntityType t : EntityType.values()) {
                if (seg != t.segmentType) continue;
                return true;
            }
            return false;
        }

        public static EntityType ofBlueprint(Class<?> type) {
            for (EntityType t : EntityType.values()) {
                if (!type.equals(t.blueprintType)) continue;
                return t;
            }
            return null;
        }

        private EntityType(Class<? extends Entity> elementType, Class<? extends Entity.Blueprint> blueprintType, SegmentType segmentType) {
            this.elementType = elementType;
            this.blueprintType = blueprintType;
            this.segmentType = segmentType;
        }
    }

    public static final class FullNode {
        static final FullNode EMPTY = new FullNode(null, null);
        private final Entity.Blueprint entity;
        private final Object attachment;

        public FullNode(Entity.Blueprint entity, Object attachment) {
            this.entity = entity;
            this.attachment = attachment;
        }

        public Entity.Blueprint getEntity() {
            return this.entity;
        }

        public Object getAttachment() {
            return this.attachment;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FullNode)) {
                return false;
            }
            FullNode fullNode = (FullNode)o;
            return this.entity != null ? this.entity.equals(fullNode.entity) : fullNode.entity == null;
        }

        public int hashCode() {
            return this.entity != null ? this.entity.hashCode() : 0;
        }
    }
}

