/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.cmd;

import java.util.Map;
import org.hawkular.agent.monitor.cmd.AbstractResourcePathCommand;
import org.hawkular.agent.monitor.cmd.CommandContext;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.hawkular.agent.monitor.protocol.dmr.DMRSession;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.cmdgw.api.AddDatasourceRequest;
import org.hawkular.cmdgw.api.AddDatasourceResponse;
import org.hawkular.cmdgw.api.ResponseStatus;
import org.hawkular.dmr.api.OperationBuilder;
import org.hawkular.dmr.api.SubsystemDatasourceConstants;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class AddDatasourceCommand
extends AbstractResourcePathCommand<AddDatasourceRequest, AddDatasourceResponse>
implements SubsystemDatasourceConstants.DatasourceNodeConstants,
SubsystemDatasourceConstants.XaDatasourceNodeConstants,
SubsystemDatasourceConstants {
    public static final Class<AddDatasourceRequest> REQUEST_CLASS = AddDatasourceRequest.class;

    public AddDatasourceCommand() {
        super("Add", "Datasource");
    }

    @Override
    protected AddDatasourceResponse createResponse() {
        return new AddDatasourceResponse();
    }

    @Override
    protected BinaryData execute(ModelControllerClient controllerClient, EndpointService<DMRNodeLocation, DMRSession> endpointService, String modelNodePath, BasicMessageWithExtraData<AddDatasourceRequest> envelope, AddDatasourceResponse response, CommandContext context, DMRSession dmrContext) throws Exception {
        OperationBuilder.CompositeOperationBuilder batch;
        ModelNode dsAdr;
        String dsPropsDmrResourceType;
        String dsDmrResourceType;
        AddDatasourceRequest request = (AddDatasourceRequest)envelope.getBasicMessage();
        response.setDatasourceName(request.getDatasourceName());
        response.setXaDatasource(request.isXaDatasource());
        Map props = request.getDatasourceProperties();
        if (request.isXaDatasource()) {
            dsDmrResourceType = "xa-data-source";
            dsPropsDmrResourceType = "xa-datasource-properties";
            dsAdr = OperationBuilder.address().subsystemDatasources().segment(dsDmrResourceType, request.getDatasourceName()).build();
            batch = ((OperationBuilder.AddOperationBuilder)OperationBuilder.composite().add().address(dsAdr)).attribute("jndi-name", request.getJndiName()).attribute("driver-name", request.getDriverName()).attribute("xa-datasource-class", request.getXaDataSourceClass()).attribute("user-name", request.getUserName()).attribute("password", request.getPassword()).parentBuilder();
        } else {
            dsDmrResourceType = "data-source";
            dsPropsDmrResourceType = "connection-properties";
            dsAdr = OperationBuilder.address().subsystemDatasources().segment(dsDmrResourceType, request.getDatasourceName()).build();
            batch = ((OperationBuilder.AddOperationBuilder)OperationBuilder.composite().add().address(dsAdr)).attribute("jndi-name", request.getJndiName()).attribute("driver-name", request.getDriverName()).attribute("driver-class", request.getDriverClass()).attribute("connection-url", request.getConnectionUrl()).attribute("user-name", request.getUserName()).attribute("password", request.getPassword()).parentBuilder();
        }
        if (!props.isEmpty()) {
            for (Map.Entry prop : props.entrySet()) {
                ((OperationBuilder.AddOperationBuilder)batch.add().address().segments(dsAdr).segment(dsPropsDmrResourceType, (String)prop.getKey()).parentBuilder()).attribute("value", (String)prop.getValue()).parentBuilder();
            }
        }
        batch.execute(controllerClient).assertSuccess();
        endpointService.discoverAll();
        return null;
    }

    @Override
    protected void success(BasicMessageWithExtraData<AddDatasourceRequest> envelope, AddDatasourceResponse response) {
        response.setStatus(ResponseStatus.OK);
        response.setMessage(String.format("Added Datasource: %s", ((AddDatasourceRequest)envelope.getBasicMessage()).getDatasourceName()));
    }

    @Override
    protected void validate(BasicMessageWithExtraData<AddDatasourceRequest> envelope, MonitoredEndpoint endpoint) {
    }

    @Override
    protected void validate(String modelNodePath, BasicMessageWithExtraData<AddDatasourceRequest> envelope) {
    }
}

