/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.cmd;

import java.io.InputStream;
import org.hawkular.agent.monitor.cmd.AbstractResourcePathCommand;
import org.hawkular.agent.monitor.cmd.CommandContext;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.inventory.ResourceManager;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.hawkular.agent.monitor.protocol.dmr.DMRSession;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.cmdgw.api.DeployApplicationRequest;
import org.hawkular.cmdgw.api.DeployApplicationResponse;
import org.hawkular.cmdgw.api.MessageUtils;
import org.hawkular.cmdgw.api.ResourcePathRequest;
import org.hawkular.cmdgw.api.ResourcePathResponse;
import org.hawkular.dmrclient.DeploymentJBossASClient;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.jboss.as.controller.client.ModelControllerClient;

public class DeployApplicationCommand
extends AbstractResourcePathCommand<DeployApplicationRequest, DeployApplicationResponse> {
    private static final MsgLogger log = AgentLoggers.getLogger(DeployApplicationCommand.class);
    public static final Class<DeployApplicationRequest> REQUEST_CLASS = DeployApplicationRequest.class;

    public DeployApplicationCommand() {
        super("Deploy", "Application");
    }

    @Override
    protected BinaryData execute(ModelControllerClient controllerClient, EndpointService<DMRNodeLocation, DMRSession> endpointService, String modelNodePath, BasicMessageWithExtraData<DeployApplicationRequest> envelope, DeployApplicationResponse response, CommandContext context, DMRSession dmrContext) throws Exception {
        DeployApplicationRequest request = (DeployApplicationRequest)envelope.getBasicMessage();
        String resourcePath = request.getResourcePath();
        String destFileName = request.getDestinationFileName();
        boolean enabled = request.getEnabled() == null ? true : request.getEnabled();
        CanonicalPath canonicalPath = CanonicalPath.fromString((String)request.getResourcePath());
        String resourceId = canonicalPath.ids().getResourcePath().getSegment().getElementId();
        ResourceManager<DMRNodeLocation> resourceManager = endpointService.getResourceManager();
        Resource<DMRNodeLocation> resource = resourceManager.getResource(new ID(resourceId));
        if (resource == null) {
            throw new IllegalArgumentException(String.format("Cannot deploy application: unknown resource [%s]", resourcePath));
        }
        MessageUtils.prepareResourcePathResponse((ResourcePathRequest)request, (ResourcePathResponse)response);
        response.setDestinationFileName(request.getDestinationFileName());
        DeploymentJBossASClient client = new DeploymentJBossASClient(dmrContext.getClient());
        client.deployStandalone(destFileName, (InputStream)envelope.getBinaryData(), enabled);
        return null;
    }

    @Override
    protected void validate(String modelNodePath, BasicMessageWithExtraData<DeployApplicationRequest> envelope) {
    }

    @Override
    protected void validate(BasicMessageWithExtraData<DeployApplicationRequest> envelope, MonitoredEndpoint endpoint) {
    }

    @Override
    protected DeployApplicationResponse createResponse() {
        return new DeployApplicationResponse();
    }
}

