/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.cmd;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hawkular.agent.monitor.cmd.AbstractResourcePathCommand;
import org.hawkular.agent.monitor.cmd.CommandContext;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.hawkular.agent.monitor.protocol.dmr.DMRSession;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.cmdgw.api.UpdateDatasourceRequest;
import org.hawkular.cmdgw.api.UpdateDatasourceResponse;
import org.hawkular.dmr.api.DmrApiException;
import org.hawkular.dmr.api.OperationBuilder;
import org.hawkular.dmr.api.SubsystemDatasourceConstants;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class UpdateDatasourceCommand
extends AbstractResourcePathCommand<UpdateDatasourceRequest, UpdateDatasourceResponse>
implements SubsystemDatasourceConstants,
SubsystemDatasourceConstants.DatasourceNodeConstants,
SubsystemDatasourceConstants.XaDatasourceNodeConstants {
    private static final MsgLogger log = AgentLoggers.getLogger(UpdateDatasourceCommand.class);
    public static final Class<UpdateDatasourceRequest> REQUEST_CLASS = UpdateDatasourceRequest.class;

    public UpdateDatasourceCommand() {
        super("Update", "Datasource");
    }

    @Override
    protected UpdateDatasourceResponse createResponse() {
        return new UpdateDatasourceResponse();
    }

    @Override
    protected BinaryData execute(ModelControllerClient controllerClient, EndpointService<DMRNodeLocation, DMRSession> endpointService, String modelNodePath, BasicMessageWithExtraData<UpdateDatasourceRequest> envelope, UpdateDatasourceResponse response, CommandContext context, DMRSession dmrContext) throws Exception {
        UpdateDatasourceRequest request = (UpdateDatasourceRequest)envelope.getBasicMessage();
        ModelNode adr = OperationBuilder.address().segments(modelNodePath).build();
        this.assertNotRename(adr, request.getDatasourceName());
        boolean isXaDatasource = this.isXa(adr);
        if (isXaDatasource) {
            OperationBuilder.CompositeOperationBuilder batch = ((OperationBuilder.WriteAttributeOperationBuilder)((OperationBuilder.WriteAttributeOperationBuilder)((OperationBuilder.WriteAttributeOperationBuilder)((OperationBuilder.WriteAttributeOperationBuilder)((OperationBuilder.WriteAttributeOperationBuilder)((OperationBuilder.WriteAttributeOperationBuilder)OperationBuilder.composite().writeAttribute().address(adr)).attribute("jndi-name", request.getJndiName()).parentBuilder().writeAttribute().address(adr)).attribute("driver-name", request.getDriverName()).parentBuilder().writeAttribute().address(adr)).attribute("xa-datasource-class", request.getXaDataSourceClass()).parentBuilder().writeAttribute().address(adr)).attribute("user-name", request.getUserName()).parentBuilder().writeAttribute().address(adr)).attribute("password", request.getPassword()).parentBuilder().writeAttribute().address(adr)).attribute("security-domain", request.getConnectionUrl()).parentBuilder();
            this.syncProps(controllerClient, adr, "xa-datasource-properties", request.getDatasourceProperties(), batch, isXaDatasource);
            try {
                batch.execute(controllerClient).assertSuccess();
            }
            catch (DmrApiException e) {
                log.warn("Trying to update xa-datasource-properties for the second time, see https://issues.jboss.org/browse/WFLY-5527");
                batch.execute(controllerClient).assertSuccess();
            }
        } else {
            OperationBuilder.CompositeOperationBuilder batch = ((OperationBuilder.WriteAttributeOperationBuilder)((OperationBuilder.WriteAttributeOperationBuilder)((OperationBuilder.WriteAttributeOperationBuilder)((OperationBuilder.WriteAttributeOperationBuilder)((OperationBuilder.WriteAttributeOperationBuilder)((OperationBuilder.WriteAttributeOperationBuilder)OperationBuilder.composite().writeAttribute().address(adr)).attribute("jndi-name", request.getJndiName()).parentBuilder().writeAttribute().address(adr)).attribute("driver-name", request.getDriverName()).parentBuilder().writeAttribute().address(adr)).attribute("driver-class", request.getDriverClass()).parentBuilder().writeAttribute().address(adr)).attribute("connection-url", request.getConnectionUrl()).parentBuilder().writeAttribute().address(adr)).attribute("user-name", request.getUserName()).parentBuilder().writeAttribute().address(adr)).attribute("password", request.getPassword()).parentBuilder();
            this.syncProps(controllerClient, adr, "connection-properties", request.getDatasourceProperties(), batch, isXaDatasource);
            batch.execute(controllerClient).assertSuccess();
        }
        endpointService.discoverAll();
        return null;
    }

    private boolean isXa(ModelNode adr) {
        List props = adr.asPropertyList();
        Property lastProp = (Property)props.get(props.size() - 1);
        switch (lastProp.getName()) {
            case "xa-data-source": {
                return true;
            }
            case "data-source": {
                return false;
            }
        }
        String msg = String.format("DMR Address [%s] was supposed to be either a [%s] or [%s] address, which it is not", adr.toString(), "xa-data-source", "data-source");
        throw new IllegalStateException(msg);
    }

    private void syncProps(ModelControllerClient client, ModelNode parentAddress, String propType, Map<String, String> newProps, OperationBuilder.CompositeOperationBuilder<?> batch, boolean isXaDatasource) {
        List availableProps = ((OperationBuilder.NodeListOperationResult)((OperationBuilder.NodeListOperationResult)((OperationBuilder.ReadChildrenResourcesOperationBuilder)OperationBuilder.readChildrenResources().address(parentAddress)).childType(propType).execute(client)).assertSuccess()).getNodeList();
        if (newProps == null) {
            newProps = Collections.emptyMap();
        }
        HashSet<String> updatedPropNames = new HashSet<String>();
        for (ModelNode modelNode : availableProps) {
            Property prop = modelNode.asProperty();
            String availPropName = prop.getName();
            String availPropValue = prop.getValue().get("value").asString();
            String newVal = newProps.get(availPropName);
            if (newVal == null) {
                ((OperationBuilder.RemoveOperationBuilder)batch.remove().address().segments(parentAddress).segment(propType, availPropName).parentBuilder()).parentBuilder();
                continue;
            }
            if (!newVal.equals(availPropValue)) {
                log.tracef("Modification of [%s=%s]: ![%s].equals([%s])", new Object[]{propType, availPropName, newVal, availPropValue});
                ((OperationBuilder.RemoveOperationBuilder)batch.remove().address().segments(parentAddress).segment(propType, availPropName).parentBuilder()).parentBuilder();
                ((OperationBuilder.AddOperationBuilder)batch.add().address().segments(parentAddress).segment(propType, availPropName).parentBuilder()).valueAttribute(newVal).parentBuilder();
                updatedPropNames.add(availPropName);
                continue;
            }
            log.tracef("No change for [%s=%s]: [%s].equals([%s])", new Object[]{propType, availPropName, newVal, availPropValue});
            updatedPropNames.add(availPropName);
        }
        for (Map.Entry entry : newProps.entrySet()) {
            String newPropName = (String)entry.getKey();
            if (updatedPropNames.contains(newPropName)) continue;
            ((OperationBuilder.AddOperationBuilder)batch.add().address().segments(parentAddress).segment(propType, newPropName).parentBuilder()).valueAttribute((String)entry.getValue()).parentBuilder();
        }
    }

    @Override
    protected void validate(String modelNodePath, BasicMessageWithExtraData<UpdateDatasourceRequest> envelope) {
    }

    @Override
    protected void validate(BasicMessageWithExtraData<UpdateDatasourceRequest> envelope, MonitoredEndpoint endpoint) {
    }
}

