/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.inventory;

import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.MetricType;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;

public class InventoryIdUtil {
    public static ResourceIdParts parseResourceId(String resourceId) {
        if (resourceId == null) {
            throw new IllegalArgumentException("Invalid resource ID - cannot be null");
        }
        String[] parts = resourceId.split("~", 3);
        if (parts.length != 3) {
            throw new IllegalArgumentException("Cannot parse invalid ID: " + resourceId);
        }
        return new ResourceIdParts(parts[0], parts[1], parts[2]);
    }

    public static ID generateResourceId(String feedId, MonitoredEndpoint endpoint, String idPart) {
        ID id = new ID(String.format("%s~%s~%s", feedId, endpoint.getName(), idPart));
        return id;
    }

    public static ID generateMetricInstanceId(ID resourceId, MetricType<?> metricType) {
        ID id = new ID(String.format("MI~R~[%s]~MT~%s", resourceId, metricType.getName()));
        return id;
    }

    public static ID generateAvailInstanceId(ID resourceId, AvailType<?> availType) {
        ID id = new ID(String.format("AI~R~[%s]~AT~%s", resourceId, availType.getName()));
        return id;
    }

    public static class ResourceIdParts {
        private final String feedId;
        private final String managedServerName;
        private final String idPart;

        private ResourceIdParts(String feedId, String managedServerName, String idPart) {
            this.feedId = feedId;
            this.managedServerName = managedServerName;
            this.idPart = idPart;
        }

        public String getFeedId() {
            return this.feedId;
        }

        public String getManagedServerName() {
            return this.managedServerName;
        }

        public String getIdPart() {
            return this.idPart;
        }
    }
}

