/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.inventory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.LocationResolver;
import org.jgrapht.alg.DirectedNeighborIndex;
import org.jgrapht.event.GraphVertexChangeEvent;
import org.jgrapht.event.VertexSetListener;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.ListenableDirectedGraph;
import org.jgrapht.traverse.BreadthFirstIterator;
import org.jgrapht.traverse.DepthFirstIterator;

public final class ResourceManager<L> {
    private static final MsgLogger log = AgentLoggers.getLogger(ResourceManager.class);
    private final ReadWriteLock graphLock = new ReentrantReadWriteLock(true);
    private final Lock graphLockRead = this.graphLock.readLock();
    private final Lock graphLockWrite = this.graphLock.writeLock();
    private volatile DirectedNeighborIndex<Resource<L>, DefaultEdge> neighborIndex;
    private volatile Map<ID, Resource<L>> resourceCache;
    private volatile ListenableDirectedGraph<Resource<L>, DefaultEdge> resourcesGraph;

    public ResourceManager() {
        this.reinitializeIfNecessary();
    }

    public void addResource(Resource<L> newResource) throws IllegalArgumentException {
        this.graphLockWrite.lock();
        try {
            this.resourcesGraph.addVertex(newResource);
            if (newResource.getParent() != null) {
                this.resourcesGraph.addEdge(newResource, newResource.getParent());
            }
        }
        finally {
            this.graphLockWrite.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Resource<L>> findResources(L query, LocationResolver<L> locationResolver) {
        this.graphLockRead.lock();
        try {
            ArrayList<Resource> result = new ArrayList<Resource>();
            BreadthFirstIterator it = new BreadthFirstIterator(this.resourcesGraph);
            while (it.hasNext()) {
                Resource resource = (Resource)it.next();
                if (!locationResolver.matches(query, resource.getLocation())) continue;
                result.add(resource);
            }
            List<Resource<L>> list = Collections.unmodifiableList(result);
            return list;
        }
        finally {
            this.graphLockRead.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Resource<L>> getChildren(Resource<L> resource) {
        this.graphLockRead.lock();
        try {
            Set directChildren = this.neighborIndex.predecessorsOf(resource);
            Set<Resource<L>> set = Collections.unmodifiableSet(new HashSet(directChildren));
            return set;
        }
        finally {
            this.graphLockRead.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource<L> getParent(Resource<L> resource) {
        this.graphLockRead.lock();
        try {
            Set directParents = this.neighborIndex.successorsOf(resource);
            if (directParents.isEmpty()) {
                Resource<L> resource2 = null;
                return resource2;
            }
            Resource resource3 = (Resource)directParents.iterator().next();
            return resource3;
        }
        finally {
            this.graphLockRead.unlock();
        }
    }

    public Resource<L> getResource(ID resourceId) {
        this.graphLockRead.lock();
        try {
            Resource<L> resource = this.resourceCache.get(resourceId);
            return resource;
        }
        finally {
            this.graphLockRead.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Resource<L>> getResourcesBreadthFirst() {
        this.graphLockRead.lock();
        try {
            ArrayList<Object> result = new ArrayList<Object>();
            BreadthFirstIterator it = new BreadthFirstIterator(this.resourcesGraph);
            while (it.hasNext()) {
                result.add(it.next());
            }
            List<Resource<L>> list = Collections.unmodifiableList(result);
            return list;
        }
        finally {
            this.graphLockRead.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Resource<L>> getRootResources() {
        this.graphLockRead.lock();
        try {
            HashSet<Resource> roots = new HashSet<Resource>();
            Set allTypes = this.resourcesGraph.vertexSet();
            for (Resource type : allTypes) {
                if (!this.neighborIndex.successorsOf((Object)type).isEmpty()) continue;
                roots.add(type);
            }
            Set set = Collections.unmodifiableSet(roots);
            return set;
        }
        finally {
            this.graphLockRead.unlock();
        }
    }

    public void logTreeGraph(String logMsg, long duration) {
        if (!log.isDebugEnabled()) {
            return;
        }
        StringBuilder graphString = new StringBuilder();
        for (Resource<L> resource : this.getResourcesBreadthFirst()) {
            for (Resource<L> parent = resource.getParent(); parent != null; parent = parent.getParent()) {
                graphString.append("...");
            }
            graphString.append(resource).append("\n");
        }
        log.debugf("%s\n%s\nDiscovery duration: [%d]ms", logMsg, graphString, duration);
    }

    private void reinitializeIfNecessary() {
        if (this.resourceCache == null || this.resourceCache.size() > 0) {
            this.resourcesGraph = new ListenableDirectedGraph(DefaultEdge.class);
            this.neighborIndex = new DirectedNeighborIndex(this.resourcesGraph);
            this.resourcesGraph.addGraphListener(this.neighborIndex);
            this.resourceCache = new HashMap<ID, Resource<L>>();
            this.resourcesGraph.addVertexSetListener((VertexSetListener)new VertexCacheListener());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Resource<L>> removeResources(L query, LocationResolver<L> locationResolver) {
        this.graphLockWrite.lock();
        try {
            ArrayList<Resource> result = new ArrayList<Resource>();
            DepthFirstIterator it = new DepthFirstIterator(this.resourcesGraph);
            while (it.hasNext()) {
                Resource resource = (Resource)it.next();
                if (!locationResolver.isParent(query, resource.getLocation())) continue;
                result.add(resource);
                this.resourcesGraph.removeVertex((Object)resource);
                this.resourcesGraph.removeEdge((Object)resource, resource.getParent());
            }
            List<Resource<L>> list = Collections.unmodifiableList(result);
            return list;
        }
        finally {
            this.graphLockWrite.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceResources(List<Resource<L>> newResources) throws IllegalArgumentException {
        this.graphLockWrite.lock();
        try {
            this.reinitializeIfNecessary();
            for (Resource<L> resource : newResources) {
                this.resourcesGraph.addVertex(resource);
                if (resource.getParent() == null) continue;
                this.resourcesGraph.addEdge(resource, resource.getParent());
            }
        }
        finally {
            this.graphLockWrite.unlock();
        }
    }

    private class VertexCacheListener
    implements VertexSetListener<Resource<L>> {
        private VertexCacheListener() {
        }

        public void vertexAdded(GraphVertexChangeEvent<Resource<L>> e) {
            ResourceManager.this.resourceCache.put(((Resource)e.getVertex()).getID(), e.getVertex());
        }

        public void vertexRemoved(GraphVertexChangeEvent<Resource<L>> e) {
            ResourceManager.this.resourceCache.remove(((Resource)e.getVertex()).getID());
        }
    }
}

