/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol.dmr;

import com.codahale.metrics.Timer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hawkular.agent.monitor.diagnostics.ProtocolDiagnostics;
import org.hawkular.agent.monitor.inventory.AttributeLocation;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.Driver;
import org.hawkular.agent.monitor.protocol.ProtocolException;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.hawkular.dmr.api.OperationBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DMRDriver
implements Driver<DMRNodeLocation> {
    private static final MsgLogger log = AgentLoggers.getLogger(DMRDriver.class);
    private final ModelControllerClient client;
    private final MonitoredEndpoint endpoint;
    private final ProtocolDiagnostics diagnostics;

    private static Object toObject(ModelNode value) throws ProtocolException {
        switch (value.getType()) {
            case BIG_DECIMAL: {
                return value.asBigDecimal();
            }
            case BIG_INTEGER: {
                return value.asBigInteger();
            }
            case BOOLEAN: {
                return value.asBoolean();
            }
            case BYTES: {
                return value.asBytes();
            }
            case DOUBLE: {
                return value.asDouble();
            }
            case INT: {
                return value.asInt();
            }
            case LONG: {
                return value.asLong();
            }
            case OBJECT: {
                return value.asObject();
            }
            case PROPERTY: {
                return value.asProperty();
            }
            case STRING: {
                return value.asString();
            }
            case UNDEFINED: {
                return null;
            }
            case LIST: {
                return DMRDriver.toObjectList(value.asList());
            }
        }
        throw new ProtocolException("cannot handle an attribute of type [" + value.getType() + "]");
    }

    private static List<Object> toObjectList(List<ModelNode> nodeList) throws ProtocolException {
        if (nodeList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>(nodeList.size());
        for (ModelNode node : nodeList) {
            if (node.hasDefined("result")) {
                result.add(DMRDriver.toObject(node.get("result")));
                continue;
            }
            throw new IllegalStateException("No 'result' in a nodeList item [" + node + "]");
        }
        return Collections.unmodifiableList(result);
    }

    public DMRDriver(ModelControllerClient client, MonitoredEndpoint endpoint, ProtocolDiagnostics diagnostics) {
        this.client = client;
        this.endpoint = endpoint;
        this.diagnostics = diagnostics;
    }

    @Override
    public boolean attributeExists(AttributeLocation<DMRNodeLocation> location) {
        Optional result = ((OperationBuilder.ReadResourceOperationBuilder)OperationBuilder.readResource().address(location.getLocation().getPathAddress())).includeRuntime().execute(this.client).getOptionalResultNode();
        return result.isPresent();
    }

    @Override
    public Object fetchAttribute(AttributeLocation<DMRNodeLocation> location) throws ProtocolException {
        ModelNode value;
        OperationBuilder.OperationResult opResult;
        String[] attribute = location.getAttribute().split("#");
        String useAttribute = attribute[0];
        OperationBuilder.ReadAttributeOperationBuilder opBuilder = ((OperationBuilder.ReadAttributeOperationBuilder)OperationBuilder.readAttribute().address(location.getLocation().getPathAddress())).resolveExpressions().name(useAttribute);
        try (Timer.Context timerContext = this.diagnostics.getRequestTimer().time();){
            opResult = opBuilder.execute(this.client);
        }
        catch (Exception e) {
            this.diagnostics.getErrorRate().mark(1L);
            throw new ProtocolException("Error fetching DMR attribute [" + useAttribute + "]", e);
        }
        try {
            value = opResult.assertSuccess().getResultNode();
        }
        catch (Exception e) {
            this.diagnostics.getErrorRate().mark(1L);
            throw new ProtocolException("Unsuccessful fetching DMR attribute [" + useAttribute + "]", e);
        }
        if (attribute.length > 1 && value != null && value.isDefined()) {
            useAttribute = attribute[1];
            value = value.get(useAttribute);
        }
        if (value == null || !value.isDefined()) {
            return null;
        }
        return this.postProcessAttribute(useAttribute, DMRDriver.toObject(value));
    }

    @Override
    public Map<DMRNodeLocation, ModelNode> fetchNodes(DMRNodeLocation query) throws ProtocolException {
        Optional resultNode = ((OperationBuilder.ReadResourceOperationBuilder)OperationBuilder.readResource().address(query.getPathAddress())).includeRuntime().execute(this.client).getOptionalResultNode();
        if (resultNode.isPresent()) {
            ModelNode n = (ModelNode)resultNode.get();
            if (n.getType() == ModelType.OBJECT) {
                return Collections.singletonMap(query, n);
            }
            if (n.getType() == ModelType.LIST) {
                HashMap<DMRNodeLocation, ModelNode> result = new HashMap<DMRNodeLocation, ModelNode>();
                List list = n.asList();
                for (ModelNode item : list) {
                    ModelNode pathAddress = item.get("address");
                    result.put(DMRNodeLocation.of(pathAddress), item.hasDefined("result") ? item.get("result") : new ModelNode());
                }
                return Collections.unmodifiableMap(result);
            }
            throw new IllegalStateException("Invalid type - please report this bug: " + n.getType() + " [[" + n.toString() + "]]");
        }
        return Collections.emptyMap();
    }

    public ModelControllerClient getClient() {
        return this.client;
    }

    protected Object postProcessAttribute(String attribute, Object oldValue) {
        if ("bound-address".equals(attribute) && oldValue != null) {
            try {
                String host;
                InetAddress[] resolvedAddresses;
                String newValue;
                InetAddress dmrAddr = InetAddress.getByName((String)oldValue);
                if (dmrAddr.isAnyLocalAddress() && this.endpoint.getConnectionData() != null && this.endpoint.getConnectionData().getUri() != null && !oldValue.equals(newValue = Stream.of(resolvedAddresses = InetAddress.getAllByName(host = this.endpoint.getConnectionData().getUri().getHost())).map(a -> a.getHostAddress()).collect(Collectors.joining(", ")))) {
                    return newValue;
                }
            }
            catch (UnknownHostException e) {
                log.warnf(e, "Could not parse IP address [%s]", oldValue);
            }
        }
        return oldValue;
    }
}

