/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol.jmx;

import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.hawkular.agent.monitor.diagnostics.ProtocolDiagnostics;
import org.hawkular.agent.monitor.inventory.AttributeLocation;
import org.hawkular.agent.monitor.protocol.Driver;
import org.hawkular.agent.monitor.protocol.ProtocolException;
import org.hawkular.agent.monitor.protocol.jmx.JMXNodeLocation;
import org.jolokia.client.J4pClient;
import org.jolokia.client.exception.J4pException;
import org.jolokia.client.request.J4pReadRequest;
import org.jolokia.client.request.J4pReadResponse;
import org.jolokia.client.request.J4pRequest;
import org.jolokia.client.request.J4pSearchRequest;
import org.jolokia.client.request.J4pSearchResponse;

public class JMXDriver
implements Driver<JMXNodeLocation> {
    private final J4pClient client;
    private final ProtocolDiagnostics diagnostics;

    public JMXDriver(J4pClient client, ProtocolDiagnostics diagnostics) {
        this.client = client;
        this.diagnostics = diagnostics;
    }

    @Override
    public Map<JMXNodeLocation, ObjectName> fetchNodes(JMXNodeLocation query) throws ProtocolException {
        try {
            J4pSearchRequest searchReq = new J4pSearchRequest(query.getObjectName().getCanonicalName());
            J4pSearchResponse searchResponse = (J4pSearchResponse)this.client.execute((J4pRequest)searchReq);
            HashMap<JMXNodeLocation, ObjectName> result = new HashMap<JMXNodeLocation, ObjectName>();
            for (ObjectName objectName : searchResponse.getObjectNames()) {
                JMXNodeLocation location = new JMXNodeLocation(objectName);
                result.put(location, objectName);
            }
            return Collections.unmodifiableMap(result);
        }
        catch (MalformedObjectNameException e) {
            throw new ProtocolException(e);
        }
        catch (J4pException e) {
            throw new ProtocolException(e);
        }
    }

    @Override
    public boolean attributeExists(AttributeLocation<JMXNodeLocation> location) throws ProtocolException {
        return true;
    }

    @Override
    public Object fetchAttribute(AttributeLocation<JMXNodeLocation> location) throws ProtocolException {
        try {
            J4pReadResponse response;
            String[] attribute = location.getAttribute().split("#");
            J4pReadRequest request = new J4pReadRequest(location.getLocation().getObjectName(), new String[]{attribute[0]});
            if (attribute.length > 1) {
                request.setPath(attribute[1]);
            }
            try (Timer.Context timerContext = this.diagnostics.getRequestTimer().time();){
                response = (J4pReadResponse)this.client.execute((J4pRequest)request);
            }
            Collection responseObjectNames = response.getObjectNames();
            switch (responseObjectNames.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return response.getValue();
                }
            }
            ArrayList<Object> results = new ArrayList<Object>(responseObjectNames.size());
            for (ObjectName responseObjectName : responseObjectNames) {
                Object value = response.getValue(responseObjectName, location.getAttribute());
                results.add(value);
            }
            return Collections.unmodifiableList(results);
        }
        catch (Exception e) {
            this.diagnostics.getErrorRate().mark(1L);
            throw new ProtocolException(e);
        }
    }

    public J4pClient getClient() {
        return this.client;
    }
}

