/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol.jmx;

import org.hawkular.agent.monitor.diagnostics.ProtocolDiagnostics;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.inventory.ResourceTypeManager;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.jmx.JMXDriver;
import org.hawkular.agent.monitor.protocol.jmx.JMXLocationResolver;
import org.hawkular.agent.monitor.protocol.jmx.JMXNodeLocation;
import org.hawkular.agent.monitor.protocol.jmx.JMXSession;
import org.hawkular.agent.monitor.protocol.jmx.JmxClientFactory;
import org.jolokia.client.J4pClient;

public class JMXEndpointService
extends EndpointService<JMXNodeLocation, JMXSession> {
    private final JmxClientFactory clientFactory;

    public JMXEndpointService(String feedId, MonitoredEndpoint endpoint, ResourceTypeManager<JMXNodeLocation> resourceTypeManager, ProtocolDiagnostics diagnostics) {
        super(feedId, endpoint, resourceTypeManager, new JMXLocationResolver(), diagnostics);
        this.clientFactory = new JmxClientFactory(endpoint);
    }

    @Override
    public JMXSession openSession() {
        J4pClient client = this.clientFactory.createClient();
        JMXDriver driver = new JMXDriver(client, this.diagnostics);
        return new JMXSession(this.feedId, this.endpoint, this.resourceTypeManager, driver, this.locationResolver, client);
    }
}

