/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol.jmx;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.hawkular.agent.monitor.protocol.LocationResolver;
import org.hawkular.agent.monitor.protocol.jmx.JMXNodeLocation;

public class JMXLocationResolver
implements LocationResolver<JMXNodeLocation> {
    @Override
    public JMXNodeLocation absolutize(JMXNodeLocation base, JMXNodeLocation location) {
        return location.getObjectName() != null ? location : base;
    }

    @Override
    public boolean isParent(JMXNodeLocation parent, JMXNodeLocation child) {
        if (child == null) {
            throw new IllegalArgumentException("Cannot compute [" + this.getClass().getName() + "].isParentOf() with a null child argument");
        }
        if (parent.getCanonicalKeys().size() > child.getCanonicalKeys().size()) {
            return false;
        }
        int prefixLength = parent.getCanonicalKeys().size();
        ObjectName childObjectName = child.getObjectName();
        if (prefixLength == child.getCanonicalKeys().size()) {
            return parent.getObjectName().apply(childObjectName);
        }
        Hashtable<String, String> prefixProps = new Hashtable<String, String>(prefixLength + prefixLength / 2);
        Iterator<String> it = child.getCanonicalKeys().iterator();
        for (int i = 0; i < prefixLength && it.hasNext(); ++i) {
            String key = it.next();
            prefixProps.put(key, childObjectName.getKeyProperty(key));
        }
        try {
            ObjectName prefixObjectName = new ObjectName(childObjectName.getDomain(), prefixProps);
            return parent.getObjectName().apply(prefixObjectName);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean matches(JMXNodeLocation query, JMXNodeLocation location) {
        return query.getObjectName().apply(location.getObjectName());
    }

    @Override
    public String applyTemplate(String nameTemplate, JMXNodeLocation location, String endpointName) {
        nameTemplate = nameTemplate.replace("%_ManagedServerName%", endpointName);
        for (Map.Entry<String, String> entry : location.getObjectName().getKeyPropertyList().entrySet()) {
            if (nameTemplate.indexOf("%") == -1) break;
            String key = entry.getKey();
            String value = entry.getValue();
            nameTemplate = nameTemplate.replace("%" + key + "%", value);
        }
        return nameTemplate;
    }
}

