/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol.platform;

import org.hawkular.agent.monitor.protocol.LocationResolver;
import org.hawkular.agent.monitor.protocol.platform.PlatformNodeLocation;
import org.hawkular.agent.monitor.protocol.platform.PlatformPath;

public class PlatformLocationResolver
implements LocationResolver<PlatformNodeLocation> {
    @Override
    public PlatformNodeLocation absolutize(PlatformNodeLocation base, PlatformNodeLocation location) {
        if (base == null || base.getPlatformPath().equals(PlatformPath.empty())) {
            return location;
        }
        PlatformPath path = location.getPlatformPath();
        if (path.equals(PlatformPath.empty())) {
            return base;
        }
        PlatformPath absPath = PlatformPath.builder().segments(base.getPlatformPath()).segments(path).build();
        return new PlatformNodeLocation(absPath);
    }

    @Override
    public boolean isParent(PlatformNodeLocation parent, PlatformNodeLocation child) {
        return parent.getPlatformPath().isParentOf(child.getPlatformPath());
    }

    @Override
    public boolean matches(PlatformNodeLocation query, PlatformNodeLocation location) {
        return query.getPlatformPath().apply(query.getPlatformPath());
    }

    @Override
    public String applyTemplate(String nameTemplate, PlatformNodeLocation location, String endpointName) {
        String name = location.getPlatformPath().getLastSegment().getName();
        return String.format(nameTemplate, name);
    }
}

