/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.storage;

import com.squareup.okhttp.Callback;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.hawkular.agent.monitor.api.Avail;
import org.hawkular.agent.monitor.api.AvailDataPayloadBuilder;
import org.hawkular.agent.monitor.api.InventoryEvent;
import org.hawkular.agent.monitor.api.MetricDataPayloadBuilder;
import org.hawkular.agent.monitor.diagnostics.Diagnostics;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.storage.AvailDataPoint;
import org.hawkular.agent.monitor.storage.HttpClientBuilder;
import org.hawkular.agent.monitor.storage.MetricDataPoint;
import org.hawkular.agent.monitor.storage.MetricsOnlyAvailDataPayloadBuilder;
import org.hawkular.agent.monitor.storage.MetricsOnlyMetricDataPayloadBuilder;
import org.hawkular.agent.monitor.storage.StorageAdapter;
import org.hawkular.agent.monitor.util.Util;

public class MetricsOnlyStorageAdapter
implements StorageAdapter {
    private static final MsgLogger log = AgentLoggers.getLogger(MetricsOnlyStorageAdapter.class);
    private MonitorServiceConfiguration.StorageAdapterConfiguration config;
    private Diagnostics diagnostics;
    private HttpClientBuilder httpClientBuilder;

    @Override
    public void initialize(MonitorServiceConfiguration.StorageAdapterConfiguration config, Diagnostics diag, HttpClientBuilder httpClientBuilder) {
        this.config = config;
        this.diagnostics = diag;
        this.httpClientBuilder = httpClientBuilder;
    }

    @Override
    public MonitorServiceConfiguration.StorageAdapterConfiguration getStorageAdapterConfiguration() {
        return this.config;
    }

    @Override
    public MetricDataPayloadBuilder createMetricDataPayloadBuilder() {
        return new MetricsOnlyMetricDataPayloadBuilder();
    }

    @Override
    public AvailDataPayloadBuilder createAvailDataPayloadBuilder() {
        return new MetricsOnlyAvailDataPayloadBuilder();
    }

    @Override
    public void storeMetrics(Set<MetricDataPoint> datapoints) {
        if (datapoints == null || datapoints.isEmpty()) {
            return;
        }
        MetricDataPayloadBuilder payloadBuilder = this.createMetricDataPayloadBuilder();
        for (MetricDataPoint datapoint : datapoints) {
            long timestamp = datapoint.getTimestamp();
            double value = datapoint.getValue();
            payloadBuilder.addDataPoint(datapoint.getKey(), timestamp, value, datapoint.getMetricType());
        }
        this.store(payloadBuilder);
    }

    @Override
    public void store(final MetricDataPayloadBuilder payloadBuilder) {
        String jsonPayload = "?";
        try {
            jsonPayload = payloadBuilder.toPayload().toString();
            StringBuilder url = Util.getContextUrlString(this.config.getUrl(), this.config.getMetricsContext());
            url.append("metrics/data");
            final Request request = this.httpClientBuilder.buildJsonPostRequest(url.toString(), Collections.singletonMap("Hawkular-Tenant", this.config.getTenantId()), jsonPayload);
            final String jsonPayloadFinal = jsonPayload;
            this.httpClientBuilder.getHttpClient().newCall(request).enqueue(new Callback(){

                public void onFailure(Request request2, IOException e) {
                    log.errorFailedToStoreMetricData(e, jsonPayloadFinal);
                    MetricsOnlyStorageAdapter.this.diagnostics.getStorageErrorRate().mark(1L);
                }

                public void onResponse(Response response) throws IOException {
                    if (response.code() != 200) {
                        IOException e = new IOException("status-code=[" + response.code() + "], reason=[" + response.message() + "], url=[" + request.urlString() + "]");
                        log.errorFailedToStoreMetricData(e, jsonPayloadFinal);
                        MetricsOnlyStorageAdapter.this.diagnostics.getStorageErrorRate().mark(1L);
                        throw e;
                    }
                    MetricsOnlyStorageAdapter.this.diagnostics.getMetricRate().mark((long)payloadBuilder.getNumberDataPoints());
                }
            });
        }
        catch (Throwable t) {
            log.errorFailedToStoreMetricData(t, jsonPayload);
            this.diagnostics.getStorageErrorRate().mark(1L);
        }
    }

    @Override
    public void storeAvails(Set<AvailDataPoint> datapoints) {
        if (datapoints == null || datapoints.isEmpty()) {
            return;
        }
        AvailDataPayloadBuilder payloadBuilder = this.createAvailDataPayloadBuilder();
        for (AvailDataPoint datapoint : datapoints) {
            long timestamp = datapoint.getTimestamp();
            Avail value = datapoint.getValue();
            payloadBuilder.addDataPoint(datapoint.getKey(), timestamp, value);
        }
        this.store(payloadBuilder);
    }

    @Override
    public void store(final AvailDataPayloadBuilder payloadBuilder) {
        String jsonPayload = "?";
        try {
            jsonPayload = payloadBuilder.toPayload().toString();
            StringBuilder url = Util.getContextUrlString(this.config.getUrl(), this.config.getMetricsContext());
            url.append("availability/data");
            final Request request = this.httpClientBuilder.buildJsonPostRequest(url.toString(), Collections.singletonMap("Hawkular-Tenant", this.config.getTenantId()), jsonPayload);
            final String jsonPayloadFinal = jsonPayload;
            this.httpClientBuilder.getHttpClient().newCall(request).enqueue(new Callback(){

                public void onFailure(Request request2, IOException e) {
                    log.errorFailedToStoreAvailData(e, jsonPayloadFinal);
                    MetricsOnlyStorageAdapter.this.diagnostics.getStorageErrorRate().mark(1L);
                }

                public void onResponse(Response response) throws IOException {
                    if (response.code() != 200) {
                        IOException e = new IOException("status-code=[" + response.code() + "], reason=[" + response.message() + "], url=[" + request.urlString() + "]");
                        log.errorFailedToStoreAvailData(e, jsonPayloadFinal);
                        MetricsOnlyStorageAdapter.this.diagnostics.getStorageErrorRate().mark(1L);
                        throw e;
                    }
                    MetricsOnlyStorageAdapter.this.diagnostics.getAvailRate().mark((long)payloadBuilder.getNumberDataPoints());
                }
            });
        }
        catch (Throwable t) {
            log.errorFailedToStoreAvailData(t, jsonPayload);
            this.diagnostics.getStorageErrorRate().mark(1L);
        }
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException("Standalone Hawkular Metrics does not support inventory");
    }

    @Override
    public <L> void discoverAllFinished(InventoryEvent<L> event) {
        throw new UnsupportedOperationException("Standalone Hawkular Metrics does not support inventory");
    }

    @Override
    public <L> void resourcesAdded(InventoryEvent<L> event) {
        throw new UnsupportedOperationException("Standalone Hawkular Metrics does not support inventory");
    }

    @Override
    public <L> void resourceRemoved(InventoryEvent<L> event) {
        throw new UnsupportedOperationException("Standalone Hawkular Metrics does not support inventory");
    }
}

