/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.inventory;

import javax.net.ssl.SSLContext;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.inventory.ConnectionData;

public final class MonitoredEndpoint {
    private static final MonitoredEndpoint DEFAULT_LOCAL_DMR_ENDPOINT = new MonitoredEndpoint("_self", null, null);
    private final ConnectionData connectionData;
    private final String name;
    private final SSLContext sslContext;

    public static MonitoredEndpoint getDefaultLocalDmrEndpoint() {
        return DEFAULT_LOCAL_DMR_ENDPOINT;
    }

    public static MonitoredEndpoint of(MonitorServiceConfiguration.EndpointConfiguration endpointConfiguration, SSLContext sslContext) {
        return new MonitoredEndpoint(endpointConfiguration.getName(), endpointConfiguration.getConnectionData(), sslContext);
    }

    MonitoredEndpoint(String name, ConnectionData connectionData, SSLContext sslContext) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot create a new [" + this.getClass().getName() + "] with a null name");
        }
        this.name = name;
        this.connectionData = connectionData;
        this.sslContext = sslContext;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MonitoredEndpoint)) {
            return false;
        }
        return this.name.equals(((MonitoredEndpoint)obj).name);
    }

    public ConnectionData getConnectionData() {
        return this.connectionData;
    }

    public String getName() {
        return this.name;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean isLocal() {
        return this.connectionData == null;
    }

    public String toString() {
        return String.format("Endpoint[%s]:[%s]", this.getName(), this.getConnectionData());
    }
}

