/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.agent.monitor.api.InventoryListener;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.Session;

public class ProtocolService<L, S extends Session<L>> {
    private final Map<String, EndpointService<L, S>> endpointServices;

    public static <L, S extends Session<L>> Builder<L, S> builder() {
        return new Builder();
    }

    public ProtocolService(Map<String, EndpointService<L, S>> endpointServices) {
        this.endpointServices = endpointServices;
    }

    public Map<String, EndpointService<L, S>> getEndpointServices() {
        return this.endpointServices;
    }

    public void discoverAll() {
        for (EndpointService<L, S> service : this.endpointServices.values()) {
            service.discoverAll();
        }
    }

    public void start() {
        for (EndpointService<L, S> service : this.endpointServices.values()) {
            service.start();
        }
    }

    public void stop() {
        for (EndpointService<L, S> service : this.endpointServices.values()) {
            service.stop();
        }
    }

    public void addInventoryListener(InventoryListener listener) {
        for (EndpointService<L, S> service : this.endpointServices.values()) {
            service.addInventoryListener(listener);
        }
    }

    public void removeInventoryListener(InventoryListener listener) {
        for (EndpointService<L, S> service : this.endpointServices.values()) {
            service.removeInventoryListener(listener);
        }
    }

    public static class Builder<L, S extends Session<L>> {
        private Map<String, EndpointService<L, S>> endpointServices = new HashMap<String, EndpointService<L, S>>();

        public ProtocolService<L, S> build() {
            return new ProtocolService<L, S>(Collections.unmodifiableMap(this.endpointServices));
        }

        public Builder<L, S> endpointService(EndpointService<L, S> endpointService) {
            this.endpointServices.put(endpointService.getEndpoint().getName(), endpointService);
            return this;
        }
    }
}

