/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.service;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import org.hawkular.agent.monitor.api.HawkularMonitorContext;
import org.hawkular.agent.monitor.api.HawkularMonitorContextImpl;
import org.hawkular.agent.monitor.cmd.FeedCommProcessor;
import org.hawkular.agent.monitor.diagnostics.Diagnostics;
import org.hawkular.agent.monitor.diagnostics.DiagnosticsImpl;
import org.hawkular.agent.monitor.diagnostics.JBossLoggingReporter;
import org.hawkular.agent.monitor.diagnostics.StorageReporter;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.ProtocolServices;
import org.hawkular.agent.monitor.protocol.dmr.DMREndpointService;
import org.hawkular.agent.monitor.protocol.dmr.ModelControllerClientFactory;
import org.hawkular.agent.monitor.scheduler.SchedulerConfiguration;
import org.hawkular.agent.monitor.scheduler.SchedulerService;
import org.hawkular.agent.monitor.storage.AvailStorageProxy;
import org.hawkular.agent.monitor.storage.HawkularStorageAdapter;
import org.hawkular.agent.monitor.storage.HttpClientBuilder;
import org.hawkular.agent.monitor.storage.InventoryStorageProxy;
import org.hawkular.agent.monitor.storage.MetricStorageProxy;
import org.hawkular.agent.monitor.storage.MetricsOnlyStorageAdapter;
import org.hawkular.agent.monitor.storage.StorageAdapter;
import org.hawkular.agent.monitor.util.Util;
import org.hawkular.inventory.api.model.Feed;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.security.SSLContextService;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.server.Services;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class MonitorService
implements Service<MonitorService> {
    private static final MsgLogger log = AgentLoggers.getLogger(MonitorService.class);
    private final InjectedValue<ModelController> modelControllerValue = new InjectedValue();
    private final InjectedValue<ServerEnvironment> serverEnvironmentValue = new InjectedValue();
    private final InjectedValue<ControlledProcessStateService> processStateValue = new InjectedValue();
    private final InjectedValue<SocketBinding> httpSocketBindingValue = new InjectedValue();
    private final InjectedValue<SocketBinding> httpsSocketBindingValue = new InjectedValue();
    private final InjectedValue<OutboundSocketBinding> serverOutboundSocketBindingValue = new InjectedValue();
    private final Map<String, InjectedValue<SSLContext>> trustOnlySSLContextValues = new HashMap<String, InjectedValue<SSLContext>>();
    private boolean started = false;
    private PropertyChangeListener serverStateListener;
    private final MonitorServiceConfiguration bootConfiguration;
    private MonitorServiceConfiguration configuration;
    private String feedId;
    private Diagnostics diagnostics;
    private ScheduledReporter diagnosticsReporter;
    private StorageAdapter storageAdapter;
    private HttpClientBuilder httpClientBuilder;
    private FeedCommProcessor feedComm;
    private SchedulerService schedulerService;
    private final MetricStorageProxy metricStorageProxy = new MetricStorageProxy();
    private final AvailStorageProxy availStorageProxy = new AvailStorageProxy();
    private final InventoryStorageProxy inventoryStorageProxy = new InventoryStorageProxy();
    private ProtocolServices protocolServices;
    private ModelControllerClientFactory localModelControllerClientFactory;

    private static MonitorServiceConfiguration buildRuntimeConfiguration(MonitorServiceConfiguration bootConfiguration, InjectedValue<SocketBinding> httpSocketBindingValue, InjectedValue<SocketBinding> httpsSocketBindingValue, InjectedValue<OutboundSocketBinding> serverOutboundSocketBindingValue, Map<String, InjectedValue<SSLContext>> trustOnlySSLContextValues) {
        MonitorServiceConfiguration.StorageAdapterConfiguration bootStorageAdapter = bootConfiguration.getStorageAdapter();
        if (bootStorageAdapter.getTenantId() != null && bootStorageAdapter.getUrl() != null) {
            return bootConfiguration;
        }
        String useUrl = bootStorageAdapter.getUrl();
        if (useUrl == null) {
            try {
                int port;
                String address;
                if (bootStorageAdapter.getServerOutboundSocketBindingRef() == null) {
                    SocketBinding socketBinding = bootStorageAdapter.isUseSSL() ? (SocketBinding)httpsSocketBindingValue.getValue() : (SocketBinding)httpSocketBindingValue.getValue();
                    address = socketBinding.getAddress().getHostAddress();
                    if (address.equals("0.0.0.0") || address.equals("::/128")) {
                        address = InetAddress.getLocalHost().getCanonicalHostName();
                    }
                    port = socketBinding.getAbsolutePort();
                } else {
                    OutboundSocketBinding serverBinding = (OutboundSocketBinding)serverOutboundSocketBindingValue.getValue();
                    address = serverBinding.getResolvedDestinationAddress().getHostAddress();
                    port = serverBinding.getDestinationPort();
                }
                String protocol = bootStorageAdapter.isUseSSL() ? "https" : "http";
                useUrl = String.format("%s://%s:%d", protocol, address, port);
            }
            catch (UnknownHostException uhe) {
                throw new IllegalArgumentException("Cannot determine Hawkular server host", uhe);
            }
        }
        String useTenantId = bootStorageAdapter.getTenantId();
        if (bootStorageAdapter.getType() == MonitorServiceConfiguration.StorageReportTo.HAWKULAR) {
            try {
                StringBuilder url = Util.getContextUrlString(useUrl, bootStorageAdapter.getAccountsContext());
                url.append("personas/current");
                SSLContext sslContext = MonitorService.getSslContext(bootConfiguration, trustOnlySSLContextValues);
                HttpClientBuilder httpClientBuilder = new HttpClientBuilder(bootConfiguration.getStorageAdapter(), sslContext);
                OkHttpClient httpclient = httpClientBuilder.getHttpClient();
                String tenantUrl = Util.getContextUrlString(useUrl, bootStorageAdapter.getInventoryContext()).append("tenant").toString();
                httpclient.newCall(httpClientBuilder.buildJsonGetRequest(tenantUrl, null)).execute();
                Request request = httpClientBuilder.buildJsonGetRequest(url.toString(), null);
                Response httpResponse = httpclient.newCall(request).execute();
                if (!httpResponse.isSuccessful()) {
                    throw new Exception("status-code=[" + httpResponse.code() + "], reason=[" + httpResponse.message() + "], url=[" + url + "]");
                }
                String fromServer = httpResponse.body().string();
                Matcher matcher = Pattern.compile("\"id\":\"(.*?)\"").matcher(fromServer);
                if (matcher.find()) {
                    String tenantIdFromAccounts = matcher.group(1);
                    if (useTenantId != null && !tenantIdFromAccounts.equals(useTenantId)) {
                        log.warnIgnoringTenantIdFromXml(useTenantId, tenantIdFromAccounts);
                    }
                    useTenantId = tenantIdFromAccounts;
                }
                log.debugf("Tenant ID [%s]", useTenantId == null ? "unknown" : useTenantId);
            }
            catch (Throwable t) {
                throw new RuntimeException("Cannot get tenant ID", t);
            }
        }
        MonitorServiceConfiguration.StorageAdapterConfiguration runtimeStorageAdapter = new MonitorServiceConfiguration.StorageAdapterConfiguration(bootStorageAdapter.getType(), bootStorageAdapter.getUsername(), bootStorageAdapter.getPassword(), bootStorageAdapter.getSecurityKey(), bootStorageAdapter.getSecuritySecret(), useTenantId, useUrl, bootStorageAdapter.isUseSSL(), bootStorageAdapter.getServerOutboundSocketBindingRef(), bootStorageAdapter.getAccountsContext(), bootStorageAdapter.getInventoryContext(), bootStorageAdapter.getMetricsContext(), bootStorageAdapter.getFeedcommContext(), bootStorageAdapter.getKeystorePath(), bootStorageAdapter.getKeystorePassword(), bootStorageAdapter.getSecurityRealm());
        return bootConfiguration.cloneWith(runtimeStorageAdapter);
    }

    private static SSLContext getSslContext(MonitorServiceConfiguration configuration, Map<String, InjectedValue<SSLContext>> trustOnlySSLContextValues) {
        SSLContext result = null;
        String bootSecurityRealm = configuration.getStorageAdapter().getSecurityRealm();
        if (bootSecurityRealm != null) {
            result = (SSLContext)trustOnlySSLContextValues.get(bootSecurityRealm).getOptionalValue();
        }
        return result;
    }

    public MonitorService(MonitorServiceConfiguration bootConfiguration) {
        this.bootConfiguration = bootConfiguration;
    }

    public MonitorService getValue() {
        return this;
    }

    public HawkularMonitorContext getHawkularMonitorContext() {
        return new HawkularMonitorContextImpl(this.metricStorageProxy, this.availStorageProxy, this.inventoryStorageProxy);
    }

    public void addDependencies(ServiceBuilder<MonitorService> bldr) {
        String securityRealm;
        bldr.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, this.serverEnvironmentValue);
        bldr.addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, this.modelControllerValue);
        bldr.addDependency(ControlledProcessStateService.SERVICE_NAME, ControlledProcessStateService.class, this.processStateValue);
        bldr.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{"http"}), SocketBinding.class, this.httpSocketBindingValue);
        bldr.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{"https"}), SocketBinding.class, this.httpsSocketBindingValue);
        if (this.bootConfiguration.getStorageAdapter().getServerOutboundSocketBindingRef() != null) {
            bldr.addDependency(OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{this.bootConfiguration.getStorageAdapter().getServerOutboundSocketBindingRef()}), OutboundSocketBinding.class, this.serverOutboundSocketBindingValue);
        }
        if (this.bootConfiguration.getStorageAdapter().getSecurityRealm() != null) {
            InjectedValue iv = new InjectedValue();
            this.trustOnlySSLContextValues.put(this.bootConfiguration.getStorageAdapter().getSecurityRealm(), (InjectedValue<SSLContext>)iv);
            boolean trustStoreOnly = true;
            SSLContextService.ServiceUtil.addDependency(bldr, (Injector)iv, (ServiceName)SecurityRealm.ServiceUtil.createServiceName((String)this.bootConfiguration.getStorageAdapter().getSecurityRealm()), (boolean)trustStoreOnly);
        }
        for (MonitorServiceConfiguration.EndpointConfiguration endpoint : this.bootConfiguration.getDmrConfiguration().getEndpoints().values()) {
            securityRealm = endpoint.getSecurityRealm();
            if (securityRealm == null) continue;
            this.addSslContext(securityRealm, bldr);
        }
        for (MonitorServiceConfiguration.EndpointConfiguration endpoint : this.bootConfiguration.getJmxConfiguration().getEndpoints().values()) {
            securityRealm = endpoint.getSecurityRealm();
            if (securityRealm == null) continue;
            this.addSslContext(securityRealm, bldr);
        }
    }

    private void addSslContext(String securityRealm, ServiceBuilder<MonitorService> bldr) {
        if (securityRealm != null && !this.trustOnlySSLContextValues.containsKey(securityRealm)) {
            InjectedValue iv = new InjectedValue();
            this.trustOnlySSLContextValues.put(securityRealm, (InjectedValue<SSLContext>)iv);
            boolean trustStoreOnly = true;
            SSLContextService.ServiceUtil.addDependency(bldr, (Injector)iv, (ServiceName)SecurityRealm.ServiceUtil.createServiceName((String)securityRealm), (boolean)trustStoreOnly);
        }
    }

    public boolean isMonitorServiceStarted() {
        return this.started;
    }

    public void start(StartContext startContext) throws StartException {
        ControlledProcessStateService stateService = (ControlledProcessStateService)this.processStateValue.getValue();
        this.serverStateListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (ControlledProcessState.State.RUNNING.equals(evt.getNewValue())) {
                    MonitorService.this.startMonitorService();
                }
            }
        };
        stateService.addPropertyChangeListener(this.serverStateListener);
    }

    public void stop(StopContext stopContext) {
        this.stopMonitorService();
    }

    public void startMonitorService() {
        if (this.isMonitorServiceStarted()) {
            return;
        }
        try {
            log.infoStarting();
            this.configuration = MonitorService.buildRuntimeConfiguration(this.bootConfiguration, this.httpSocketBindingValue, this.httpsSocketBindingValue, this.serverOutboundSocketBindingValue, this.trustOnlySSLContextValues);
            log.infoUsingServerSideUrl(this.configuration.getStorageAdapter().getUrl());
            SSLContext ssl = MonitorService.getSslContext(this.configuration, this.trustOnlySSLContextValues);
            this.httpClientBuilder = new HttpClientBuilder(this.configuration.getStorageAdapter(), ssl);
            this.localModelControllerClientFactory = ModelControllerClientFactory.createLocal((ModelController)this.modelControllerValue.getValue());
            try (ModelControllerClient c = this.localModelControllerClientFactory.createClient();){
                this.feedId = DMREndpointService.lookupServerIdentifier(c);
            }
            catch (Exception e) {
                throw new Exception("Could not obtain local feed ID", e);
            }
            MetricRegistry metricRegistry = new MetricRegistry();
            this.diagnostics = new DiagnosticsImpl(this.configuration.getDiagnostics(), metricRegistry, this.feedId);
            if (this.configuration.getStorageAdapter().getType() == MonitorServiceConfiguration.StorageReportTo.HAWKULAR) {
                if (this.configuration.getStorageAdapter().getTenantId() == null) {
                    log.errorNoTenantIdFromAccounts();
                    throw new Exception("Failed to get tenant ID");
                }
                try {
                    this.registerFeed();
                }
                catch (Exception e) {
                    log.errorCannotDoAnythingWithoutFeed(e);
                    throw new Exception("Agent needs a feed to run");
                }
                try {
                    this.connectToCommandGatewayCommChannel();
                }
                catch (Exception e) {
                    log.errorCannotEstablishFeedComm(e);
                }
            } else if (this.configuration.getStorageAdapter().getTenantId() == null) {
                log.errorMustHaveTenantIdConfigured();
                throw new Exception("Agent needs a tenant ID to run");
            }
            try {
                this.startStorageAdapter();
            }
            catch (Exception e) {
                log.errorCannotStartStorageAdapter(e);
                throw new Exception("Agent cannot start storage adapter");
            }
            try {
                this.startScheduler();
            }
            catch (Exception e) {
                log.errorCannotInitializeScheduler(e);
                throw new Exception("Agent cannot initialize scheduler");
            }
            ProtocolServices ps = ProtocolServices.builder(this.feedId, this.diagnostics, this.trustOnlySSLContextValues).dmrProtocolService(this.localModelControllerClientFactory, this.configuration.getDmrConfiguration()).jmxProtocolService(this.configuration.getJmxConfiguration()).platformProtocolService(this.configuration.getPlatformConfiguration()).autoDiscoveryScanPeriodSecs(this.configuration.getAutoDiscoveryScanPeriodSecs()).build();
            ps.addInventoryListener(this.inventoryStorageProxy);
            ps.addInventoryListener(this.schedulerService);
            this.protocolServices = ps;
            this.protocolServices.start();
            this.started = true;
        }
        catch (Throwable t) {
            log.errorFailedToStartAgent(t);
            this.started = true;
            this.stopMonitorService();
        }
    }

    public void stopMonitorService() {
        if (!this.isMonitorServiceStarted()) {
            return;
        }
        log.infoStopping();
        AtomicReference<Object> error = new AtomicReference<Object>(null);
        try {
            try {
                if (this.feedComm != null) {
                    this.feedComm.disconnect();
                    this.feedComm = null;
                }
            }
            catch (Throwable t) {
                error.compareAndSet(null, t);
                log.debug("Cannot shutdown feed comm but will continue shutdown", t);
            }
            try {
                if (this.protocolServices != null) {
                    this.protocolServices.stop();
                    this.protocolServices.removeInventoryListener(this.inventoryStorageProxy);
                    this.protocolServices.removeInventoryListener(this.schedulerService);
                    this.protocolServices = null;
                }
            }
            catch (Throwable t) {
                error.compareAndSet(null, t);
                log.debug("Cannot shutdown protocol services but will continue shutdown", t);
            }
            try {
                this.stopScheduler();
            }
            catch (Throwable t) {
                error.compareAndSet(null, t);
                log.debug("Cannot shutdown scheduler but will continue shutdown", t);
            }
            try {
                this.stopStorageAdapter();
            }
            catch (Throwable t) {
                error.compareAndSet(null, t);
                log.debug("Cannot shutdown storage adapter but will continue shutdown", t);
            }
            if (this.diagnosticsReporter != null) {
                this.diagnosticsReporter.stop();
                if (this.configuration.getDiagnostics().isEnabled()) {
                    this.diagnosticsReporter.report();
                }
                this.diagnosticsReporter = null;
            }
            if (this.serverStateListener != null) {
                ((ControlledProcessStateService)this.processStateValue.getValue()).removePropertyChangeListener(this.serverStateListener);
                this.serverStateListener = null;
            }
            if (error.get() != null) {
                throw (Throwable)error.get();
            }
        }
        catch (Throwable t) {
            log.warnFailedToStopAgent(t);
        }
        finally {
            this.started = false;
        }
    }

    private File getDataDirectory() {
        File dataDir = new File(((ServerEnvironment)this.serverEnvironmentValue.getValue()).getServerDataDir(), "hawkular-agent");
        dataDir.mkdirs();
        return dataDir;
    }

    private void startStorageAdapter() throws Exception {
        switch (this.configuration.getStorageAdapter().getType()) {
            case HAWKULAR: {
                this.storageAdapter = new HawkularStorageAdapter();
                break;
            }
            case METRICS: {
                this.storageAdapter = new MetricsOnlyStorageAdapter();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid storage adapter: " + this.configuration.getStorageAdapter());
            }
        }
        this.storageAdapter.initialize(this.configuration.getStorageAdapter(), this.diagnostics, this.httpClientBuilder);
        this.metricStorageProxy.setStorageAdapter(this.storageAdapter);
        this.availStorageProxy.setStorageAdapter(this.storageAdapter);
        this.inventoryStorageProxy.setStorageAdapter(this.storageAdapter);
        switch (this.configuration.getDiagnostics().getReportTo()) {
            case LOG: {
                this.diagnosticsReporter = JBossLoggingReporter.forRegistry(this.diagnostics.getMetricRegistry()).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).outputTo(Logger.getLogger(this.getClass())).withLoggingLevel(JBossLoggingReporter.LoggingLevel.DEBUG).build();
                break;
            }
            case STORAGE: {
                this.diagnosticsReporter = StorageReporter.forRegistry(this.diagnostics.getMetricRegistry(), this.configuration.getDiagnostics(), this.storageAdapter).feedId(this.feedId).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
                break;
            }
            default: {
                throw new Exception("Invalid diagnostics type: " + (Object)((Object)this.configuration.getDiagnostics().getReportTo()));
            }
        }
        if (this.configuration.getDiagnostics().isEnabled()) {
            this.diagnosticsReporter.start((long)this.configuration.getDiagnostics().getInterval(), this.configuration.getDiagnostics().getTimeUnits());
        }
    }

    private void stopStorageAdapter() {
        if (this.storageAdapter != null) {
            this.storageAdapter.shutdown();
            this.storageAdapter = null;
        }
    }

    private void startScheduler() throws Exception {
        if (this.schedulerService == null) {
            SchedulerConfiguration schedulerConfig = new SchedulerConfiguration();
            schedulerConfig.setDiagnosticsConfig(this.configuration.getDiagnostics());
            schedulerConfig.setStorageAdapterConfig(this.configuration.getStorageAdapter());
            schedulerConfig.setMetricDispatcherBufferSize(this.configuration.getMetricDispatcherBufferSize());
            schedulerConfig.setMetricDispatcherMaxBatchSize(this.configuration.getMetricDispatcherMaxBatchSize());
            schedulerConfig.setAvailDispatcherBufferSize(this.configuration.getAvailDispatcherBufferSize());
            schedulerConfig.setAvailDispatcherMaxBatchSize(this.configuration.getAvailDispatcherMaxBatchSize());
            this.schedulerService = new SchedulerService(schedulerConfig, this.diagnostics, this.storageAdapter);
        }
        this.schedulerService.start();
    }

    private void stopScheduler() {
        if (this.schedulerService != null) {
            this.schedulerService.stop();
            this.schedulerService = null;
        }
    }

    private void registerFeed() throws Exception {
        String desiredFeedId = this.feedId;
        try {
            File feedFile = new File(this.getDataDirectory(), "feedId.txt");
            try {
                String feedIdFromDataFile = Util.read(feedFile);
                feedIdFromDataFile = feedIdFromDataFile.trim();
                if (!desiredFeedId.equals(feedIdFromDataFile)) {
                    log.warnf("Will use feed ID [%s] found in [%s]; note that it is different than our desired feed ID [%s].", feedIdFromDataFile, feedFile, desiredFeedId);
                    this.feedId = feedIdFromDataFile;
                }
                return;
            }
            catch (FileNotFoundException feedIdFromDataFile) {
                Feed.Blueprint feedPojo = new Feed.Blueprint(desiredFeedId, null);
                String jsonPayload = Util.toJson(feedPojo);
                StringBuilder url = Util.getContextUrlString(this.configuration.getStorageAdapter().getUrl(), this.configuration.getStorageAdapter().getInventoryContext());
                url.append("feeds");
                OkHttpClient httpclient = this.httpClientBuilder.getHttpClient();
                Request request = this.httpClientBuilder.buildJsonPostRequest(url.toString(), null, jsonPayload);
                Response httpResponse = httpclient.newCall(request).execute();
                if (httpResponse.code() == 201) {
                    String feedObjectFromServer = httpResponse.body().string();
                    Feed feed = Util.fromJson(feedObjectFromServer, Feed.class);
                    if (desiredFeedId.equals(feed.getId())) {
                        log.infof("Feed ID registered [%s]", feed.getId());
                    } else {
                        log.errorf("Server gave us a feed ID [%s] but we wanted [%s]", feed.getId(), desiredFeedId);
                        log.errorf("Using feed ID [%s]; make sure the agent doesn't lose its data file", feed.getId());
                    }
                    this.feedId = feed.getId();
                } else if (httpResponse.code() == 409) {
                    log.infof("Feed ID [%s] was already registered; it will be reused", this.feedId);
                } else {
                    throw new Exception("status-code=[" + httpResponse.code() + "], reason=[" + httpResponse.message() + "], url=[" + request.urlString() + "]");
                }
                Util.write(this.feedId, feedFile);
            }
        }
        catch (Throwable t) {
            throw new Exception(String.format("Cannot create feed [%s]", desiredFeedId), t);
        }
    }

    private void connectToCommandGatewayCommChannel() throws Exception {
        this.feedComm = new FeedCommProcessor(this.httpClientBuilder, this.configuration, this.feedId, this);
        this.feedComm.connect();
    }

    public ProtocolServices getProtocolServices() {
        return this.protocolServices;
    }
}

