/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.storage;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.ws.WebSocketCall;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.util.Util;

public class HttpClientBuilder {
    private static final MsgLogger log = AgentLoggers.getLogger(HttpClientBuilder.class);
    private final String password;
    private final String username;
    private final boolean useSSL;
    private final String keystorePath;
    private final String keystorePassword;
    private final SSLContext sslContext;
    private final OkHttpClient httpClient;

    public HttpClientBuilder(MonitorServiceConfiguration.StorageAdapterConfiguration storageAdapter, SSLContext sslContext) {
        if (storageAdapter.getSecurityKey() != null) {
            this.username = storageAdapter.getSecurityKey();
            this.password = storageAdapter.getSecuritySecret();
        } else {
            this.username = storageAdapter.getUsername();
            this.password = storageAdapter.getPassword();
        }
        this.useSSL = storageAdapter.isUseSSL();
        this.keystorePath = storageAdapter.getKeystorePath();
        this.keystorePassword = storageAdapter.getKeystorePassword();
        OkHttpClient httpClient = new OkHttpClient();
        if (this.useSSL) {
            this.sslContext = sslContext == null ? this.buildSSLContext() : sslContext;
            httpClient.setSslSocketFactory(this.sslContext.getSocketFactory());
            httpClient.setHostnameVerifier((HostnameVerifier)new NullHostNameVerifier());
        } else {
            this.sslContext = null;
        }
        this.httpClient = httpClient;
    }

    public OkHttpClient getHttpClient() throws Exception {
        return this.httpClient;
    }

    public Request buildJsonGetRequest(String url, Map<String, String> headers) {
        String base64Credentials = Util.base64Encode(this.username + ":" + this.password);
        Request.Builder requestBuilder = new Request.Builder().url(url).addHeader("Authorization", "Basic " + base64Credentials).addHeader("Accept", "application/json");
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                requestBuilder.addHeader(header.getKey(), header.getValue());
            }
        }
        return requestBuilder.get().build();
    }

    public Request buildJsonPostRequest(String url, Map<String, String> headers, String jsonPayload) {
        String base64Credentials = Util.base64Encode(this.username + ":" + this.password);
        Request.Builder requestBuilder = new Request.Builder().url(url).addHeader("Authorization", "Basic " + base64Credentials).addHeader("Accept", "application/json");
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                requestBuilder.addHeader(header.getKey(), header.getValue());
            }
        }
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonPayload);
        return requestBuilder.post(body).build();
    }

    public Request buildJsonPutRequest(String url, Map<String, String> headers, String jsonPayload) {
        String base64Credentials = Util.base64Encode(this.username + ":" + this.password);
        Request.Builder requestBuilder = new Request.Builder().url(url).addHeader("Authorization", "Basic " + base64Credentials).addHeader("Accept", "application/json");
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                requestBuilder.addHeader(header.getKey(), header.getValue());
            }
        }
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonPayload);
        return requestBuilder.put(body).build();
    }

    public WebSocketCall createWebSocketCall(String url, Map<String, String> headers) {
        String base64Credentials = Util.base64Encode(this.username + ":" + this.password);
        Request.Builder requestBuilder = new Request.Builder().url(url).addHeader("Authorization", "Basic " + base64Credentials).addHeader("Accept", "application/json");
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                requestBuilder.addHeader(header.getKey(), header.getValue());
            }
        }
        Request request = requestBuilder.build();
        WebSocketCall wsc = WebSocketCall.create((OkHttpClient)this.httpClient, (Request)request);
        return wsc;
    }

    private SSLContext buildSSLContext() {
        try {
            KeyStore keyStore = this.readKeyStore();
            SSLContext sslContext = SSLContext.getInstance("SSL");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, this.keystorePassword.toCharArray());
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
            return sslContext;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Cannot create SSL context from keystore [%s]", this.keystorePath), e);
        }
    }

    private KeyStore readKeyStore() throws Exception {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        char[] password = this.keystorePassword.toCharArray();
        File file = new File(this.keystorePath);
        log.infoUseKeystore(file.getAbsolutePath());
        try (FileInputStream fis = new FileInputStream(file);){
            ks.load(fis, password);
        }
        return ks;
    }

    private class NullHostNameVerifier
    implements HostnameVerifier {
        private NullHostNameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            log.debugf("HTTP client is blindly approving cert for [%s]", hostname);
            return true;
        }
    }
}

