/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.storage;

import java.util.Set;
import org.hawkular.agent.monitor.api.Avail;
import org.hawkular.agent.monitor.api.AvailDataPayloadBuilder;
import org.hawkular.agent.monitor.api.InventoryEvent;
import org.hawkular.agent.monitor.api.MetricDataPayloadBuilder;
import org.hawkular.agent.monitor.diagnostics.Diagnostics;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.storage.AsyncInventoryStorage;
import org.hawkular.agent.monitor.storage.AvailDataPoint;
import org.hawkular.agent.monitor.storage.HawkularAvailDataPayloadBuilder;
import org.hawkular.agent.monitor.storage.HawkularMetricDataPayloadBuilder;
import org.hawkular.agent.monitor.storage.HttpClientBuilder;
import org.hawkular.agent.monitor.storage.MetricDataPoint;
import org.hawkular.agent.monitor.storage.MetricsOnlyStorageAdapter;
import org.hawkular.agent.monitor.storage.StorageAdapter;

public class HawkularStorageAdapter
implements StorageAdapter {
    private static final MsgLogger log = AgentLoggers.getLogger(HawkularStorageAdapter.class);
    private String feedId;
    private MonitorServiceConfiguration.StorageAdapterConfiguration config;
    private Diagnostics diagnostics;
    private HttpClientBuilder httpClientBuilder;
    private AsyncInventoryStorage inventoryStorage;

    @Override
    public void initialize(String feedId, MonitorServiceConfiguration.StorageAdapterConfiguration config, Diagnostics diag, HttpClientBuilder httpClientBuilder) {
        this.feedId = feedId;
        this.config = config;
        this.diagnostics = diag;
        this.httpClientBuilder = httpClientBuilder;
        this.inventoryStorage = new AsyncInventoryStorage(feedId, config, httpClientBuilder, this.diagnostics);
    }

    @Override
    public MonitorServiceConfiguration.StorageAdapterConfiguration getStorageAdapterConfiguration() {
        return this.config;
    }

    @Override
    public MetricDataPayloadBuilder createMetricDataPayloadBuilder() {
        return new HawkularMetricDataPayloadBuilder();
    }

    @Override
    public AvailDataPayloadBuilder createAvailDataPayloadBuilder() {
        return new HawkularAvailDataPayloadBuilder();
    }

    @Override
    public void storeMetrics(Set<MetricDataPoint> datapoints) {
        if (datapoints == null || datapoints.isEmpty()) {
            return;
        }
        MetricDataPayloadBuilder payloadBuilder = this.createMetricDataPayloadBuilder();
        for (MetricDataPoint datapoint : datapoints) {
            long timestamp = datapoint.getTimestamp();
            double value = datapoint.getValue();
            payloadBuilder.addDataPoint(datapoint.getKey(), timestamp, value, datapoint.getMetricType());
        }
        this.store(payloadBuilder);
    }

    @Override
    public void store(MetricDataPayloadBuilder payloadBuilder) {
        MetricsOnlyStorageAdapter metricsAdapter = new MetricsOnlyStorageAdapter();
        metricsAdapter.initialize(this.feedId, this.getStorageAdapterConfiguration(), this.diagnostics, this.httpClientBuilder);
        metricsAdapter.store(payloadBuilder);
    }

    @Override
    public void storeAvails(Set<AvailDataPoint> datapoints) {
        if (datapoints == null || datapoints.isEmpty()) {
            return;
        }
        AvailDataPayloadBuilder payloadBuilder = this.createAvailDataPayloadBuilder();
        for (AvailDataPoint datapoint : datapoints) {
            long timestamp = datapoint.getTimestamp();
            Avail value = datapoint.getValue();
            payloadBuilder.addDataPoint(datapoint.getKey(), timestamp, value);
        }
        this.store(payloadBuilder);
    }

    @Override
    public void store(AvailDataPayloadBuilder payloadBuilder) {
        MetricsOnlyStorageAdapter metricsAdapter = new MetricsOnlyStorageAdapter();
        metricsAdapter.initialize(this.feedId, this.getStorageAdapterConfiguration(), this.diagnostics, this.httpClientBuilder);
        metricsAdapter.store(payloadBuilder);
    }

    @Override
    public <L> void resourcesAdded(InventoryEvent<L> event) {
        this.inventoryStorage.resourcesAdded(event);
    }

    @Override
    public <L> void resourcesRemoved(InventoryEvent<L> event) {
        this.inventoryStorage.resourcesRemoved(event);
    }

    @Override
    public void shutdown() {
        this.inventoryStorage.shutdown();
    }
}

