/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.inventory;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.Name;
import org.hawkular.agent.monitor.inventory.NamedObject;
import org.hawkular.agent.monitor.inventory.NodeLocationProvider;

public class TypeSet<T extends NamedObject>
extends NamedObject {
    private static final TypeSet<NodeLocationProvider<?>> EMPTY = new TypeSet(ID.NULL_ID, new Name(TypeSet.class.getSimpleName() + ".EMPTY"), false, Collections.emptyMap());
    private final boolean enabled;
    private final Map<Name, T> typeMap;

    public static <T extends NamedObject> TypeSetBuilder<T> builder() {
        return new TypeSetBuilder();
    }

    public static <T extends NodeLocationProvider<?>> TypeSet<T> empty() {
        return EMPTY;
    }

    private TypeSet(ID id, Name name, boolean enabled, Map<Name, T> typeMap) {
        super(id, name);
        this.enabled = enabled;
        this.typeMap = typeMap;
    }

    public Map<Name, T> getTypeMap() {
        return this.typeMap;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isDisabledOrEmpty() {
        return !this.isEnabled() || this.typeMap == null || this.typeMap.isEmpty();
    }

    public static class TypeSetBuilder<T extends NamedObject> {
        private boolean enabled = true;
        private ID id;
        private Name name;
        private Map<Name, T> typeMap = new HashMap<Name, T>();

        private TypeSetBuilder() {
        }

        public TypeSet<T> build() {
            return new TypeSet(this.id, this.name, this.enabled, Collections.unmodifiableMap(this.typeMap));
        }

        public TypeSetBuilder<T> enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public TypeSetBuilder<T> id(ID id) {
            this.id = id;
            return this;
        }

        public TypeSetBuilder<T> name(Name name) {
            this.name = name;
            return this;
        }

        public TypeSetBuilder<T> type(T type) {
            this.typeMap.put(((NamedObject)type).getName(), type);
            return this;
        }
    }
}

