/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hawkular.agent.monitor.inventory.AttributeLocation;
import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.InventoryIdUtil;
import org.hawkular.agent.monitor.inventory.MeasurementInstance;
import org.hawkular.agent.monitor.inventory.MetricType;
import org.hawkular.agent.monitor.inventory.Name;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.inventory.ResourceConfigurationPropertyInstance;
import org.hawkular.agent.monitor.inventory.ResourceConfigurationPropertyType;
import org.hawkular.agent.monitor.inventory.ResourceType;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.Driver;
import org.hawkular.agent.monitor.protocol.LocationResolver;
import org.hawkular.agent.monitor.protocol.ProtocolException;
import org.hawkular.agent.monitor.protocol.Session;
import org.hawkular.agent.monitor.util.Consumer;
import org.hawkular.agent.monitor.util.Util;

public final class Discovery<L> {
    private static final MsgLogger log = AgentLoggers.getLogger(Discovery.class);

    public <N> void discoverChildren(Resource<L> parent, ResourceType<L> childType, Session<L> session, Consumer<Resource<L>> resourceConsumer) {
        try {
            Object parentLocation = parent != null ? (Object)parent.getLocation() : null;
            log.debugf("Discovering children of [%s] of type [%s]", parent, childType);
            Object childQuery = session.getLocationResolver().absolutize(parentLocation, childType.getLocation());
            Map nativeResources = session.getDriver().fetchNodes(childQuery);
            for (Map.Entry entry : nativeResources.entrySet()) {
                Object location = entry.getKey();
                String resourceName = session.getLocationResolver().applyTemplate(childType.getResourceNameTemplate(), location, session.getEndpoint().getName());
                ID id = InventoryIdUtil.generateResourceId(session.getEndpoint(), location.toString());
                Resource.Builder<L> builder = ((Resource.Builder)((Resource.Builder)((Resource.Builder)Resource.builder().id(id)).name(new Name(resourceName))).location(location)).type(childType);
                if (parent != null) {
                    builder.parent(parent);
                }
                this.discoverResourceConfiguration(id, childType, location, entry.getValue(), builder, session);
                this.addMetricAndAvailInstances(id, childType, location, entry.getValue(), builder, session);
                Resource<L> resource = builder.build();
                log.debugf("Discovered resource [%s]", resource);
                if (resourceConsumer != null) {
                    resourceConsumer.accept(resource);
                }
                Set<ResourceType<L>> childTypes = session.getResourceTypeManager().getChildren(childType);
                for (ResourceType<L> nextLevelChildType : childTypes) {
                    this.discoverChildren(resource, nextLevelChildType, session, resourceConsumer);
                }
            }
        }
        catch (Exception e) {
            log.errorf(e, "Failed to discover resources in [%s]", session.getEndpoint());
            resourceConsumer.report(e);
        }
    }

    private <N> void discoverResourceConfiguration(ID resourceId, ResourceType<L> type, L parentAddress, N baseNode, Resource.Builder<L> builder, Session<L> session) {
        Collection<ResourceConfigurationPropertyType<L>> confPropTypes = type.getResourceConfigurationPropertyTypes();
        for (ResourceConfigurationPropertyType<L> confPropType : confPropTypes) {
            try {
                String resConfPropValue;
                AttributeLocation location = confPropType.getAttributeLocation();
                LocationResolver<L> locationResolver = session.getLocationResolver();
                AttributeLocation<L> instanceLocation = locationResolver.absolutize(parentAddress, location);
                Driver<L> driver = session.getDriver();
                if (!locationResolver.isMultiTarget(instanceLocation.getLocation())) {
                    Object o = driver.fetchAttribute(instanceLocation);
                    resConfPropValue = o == null ? null : o.toString();
                } else {
                    Map<L, Object> attribMap = driver.fetchAttributeAsMap(instanceLocation);
                    if (attribMap == null || attribMap.isEmpty()) {
                        resConfPropValue = null;
                    } else {
                        HashMap<String, String> resConfigPropMap = new HashMap<String, String>(attribMap.size());
                        L multiTargetLocation = instanceLocation.getLocation();
                        for (Map.Entry<L, Object> entry : attribMap.entrySet()) {
                            L singleLocation = entry.getKey();
                            String attribValue = String.valueOf(entry.getValue());
                            String attribKey = locationResolver.findWildcardMatch(multiTargetLocation, singleLocation);
                            resConfigPropMap.put(attribKey, attribValue);
                        }
                        resConfPropValue = Util.toJson(resConfigPropMap);
                    }
                }
                ResourceConfigurationPropertyInstance<L> cpi = new ResourceConfigurationPropertyInstance<L>(ID.NULL_ID, confPropType.getName(), instanceLocation, confPropType, resConfPropValue);
                builder.resourceConfigurationProperty(cpi);
            }
            catch (Exception e) {
                log.warnf(e, "Failed to discover config [%s] for resource [%s]", confPropType, parentAddress);
            }
        }
    }

    private <N> void addMetricAndAvailInstances(ID resourceId, ResourceType<L> type, L parentLocation, N baseNode, Resource.Builder<L> builder, Session<L> session) {
        Name name;
        ID id;
        AttributeLocation<L> instanceLocation;
        AttributeLocation location;
        for (MetricType<L> metricType : type.getMetricTypes()) {
            location = metricType.getAttributeLocation();
            try {
                instanceLocation = session.getLocationResolver().absolutize(parentLocation, location);
                if (!session.getDriver().attributeExists(instanceLocation)) continue;
                id = InventoryIdUtil.generateMetricInstanceId(session.getFeedId(), resourceId, metricType);
                name = metricType.getName();
                MeasurementInstance<L, MetricType<L>> metricInstance = new MeasurementInstance<L, MetricType<L>>(id, name, instanceLocation, metricType);
                builder.metric(metricInstance);
            }
            catch (ProtocolException e) {
                log.warnFailedToLocate(e, metricType.getClass().getName(), String.valueOf(location), String.valueOf(parentLocation));
            }
        }
        for (AvailType availType : type.getAvailTypes()) {
            location = availType.getAttributeLocation();
            try {
                instanceLocation = session.getLocationResolver().absolutize(parentLocation, location);
                if (!session.getDriver().attributeExists(instanceLocation)) continue;
                id = InventoryIdUtil.generateAvailInstanceId(session.getFeedId(), resourceId, availType);
                name = availType.getName();
                MeasurementInstance<L, AvailType> availInstance = new MeasurementInstance<L, AvailType>(id, name, instanceLocation, availType);
                builder.avail(availInstance);
            }
            catch (ProtocolException e) {
                log.warnFailedToLocate(e, availType.getClass().getName(), String.valueOf(location), String.valueOf(parentLocation));
            }
        }
    }
}

