/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol.platform;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hawkular.agent.monitor.inventory.Name;

public interface Constants {
    public static final Name PLATFORM = new Name("Platform");
    public static final Name OPERATING_SYSTEM_SYS_CPU_LOAD = new Name("System CPU Load");
    public static final Name OPERATING_SYSTEM_SYS_LOAD_AVG = new Name("System Load Average");
    public static final Name FILE_STORE_USABLE_SPACE = new Name("Usable Space");
    public static final Name FILE_STORE_TOTAL_SPACE = new Name("Total Space");
    public static final Name MEMORY_AVAILABLE = new Name("Available Memory");
    public static final Name MEMORY_TOTAL = new Name("Total Memory");
    public static final Name PROCESSOR_CPU_USAGE = new Name("CPU Usage");
    public static final Name POWER_SOURCE_REMAINING_CAPACITY = new Name("Remaining Capacity");
    public static final Name POWER_SOURCE_TIME_REMAINING = new Name("Time Remaining");

    public static enum PlatformResourceType {
        OPERATING_SYSTEM("Operating System", Arrays.asList(OPERATING_SYSTEM_SYS_CPU_LOAD, OPERATING_SYSTEM_SYS_LOAD_AVG)),
        FILE_STORE("File Store", Arrays.asList(FILE_STORE_USABLE_SPACE, FILE_STORE_TOTAL_SPACE)),
        MEMORY("Memory", Arrays.asList(MEMORY_AVAILABLE, MEMORY_TOTAL)),
        PROCESSOR("Processor", Arrays.asList(PROCESSOR_CPU_USAGE)),
        POWER_SOURCE("Power Source", Arrays.asList(POWER_SOURCE_REMAINING_CAPACITY, POWER_SOURCE_TIME_REMAINING));

        private final Name name;
        private final List<Name> metricNames;

        private PlatformResourceType(String label, List<Name> metricNames) {
            this.name = new Name(label);
            this.metricNames = Collections.unmodifiableList(metricNames);
        }

        public Name getName() {
            return this.name;
        }

        public List<Name> getMetricNames() {
            return this.metricNames;
        }
    }
}

