/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol;

import com.codahale.metrics.Timer;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.hawkular.agent.monitor.api.Avail;
import org.hawkular.agent.monitor.api.InventoryEvent;
import org.hawkular.agent.monitor.api.InventoryListener;
import org.hawkular.agent.monitor.api.SamplingService;
import org.hawkular.agent.monitor.diagnostics.ProtocolDiagnostics;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.inventory.AttributeLocation;
import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.inventory.MeasurementInstance;
import org.hawkular.agent.monitor.inventory.MetricType;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.inventory.ResourceManager;
import org.hawkular.agent.monitor.inventory.ResourceType;
import org.hawkular.agent.monitor.inventory.ResourceTypeManager;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.Discovery;
import org.hawkular.agent.monitor.protocol.Driver;
import org.hawkular.agent.monitor.protocol.LocationResolver;
import org.hawkular.agent.monitor.protocol.Session;
import org.hawkular.agent.monitor.service.ServiceStatus;
import org.hawkular.agent.monitor.storage.AvailDataPoint;
import org.hawkular.agent.monitor.storage.MetricDataPoint;
import org.hawkular.agent.monitor.util.Consumer;
import org.hawkular.agent.monitor.util.ThreadFactoryGenerator;

public abstract class EndpointService<L, S extends Session<L>>
implements SamplingService<L> {
    private static final MsgLogger LOG = AgentLoggers.getLogger(EndpointService.class);
    private final MonitoredEndpoint<MonitorServiceConfiguration.EndpointConfiguration> endpoint;
    private final String feedId;
    private final InventoryListenerSupport inventoryListenerSupport = new InventoryListenerSupport();
    private final ResourceManager<L> resourceManager;
    private final ResourceTypeManager<L> resourceTypeManager;
    private final LocationResolver<L> locationResolver;
    private final ProtocolDiagnostics diagnostics;
    private final ExecutorService fullDiscoveryScanThreadPool;
    protected volatile ServiceStatus status = ServiceStatus.INITIAL;

    public EndpointService(String feedId, MonitoredEndpoint<MonitorServiceConfiguration.EndpointConfiguration> endpoint, ResourceTypeManager<L> resourceTypeManager, LocationResolver<L> locationResolver, ProtocolDiagnostics diagnostics) {
        this.feedId = feedId;
        this.endpoint = endpoint;
        this.resourceManager = new ResourceManager();
        this.resourceTypeManager = resourceTypeManager;
        this.locationResolver = locationResolver;
        this.diagnostics = diagnostics;
        ThreadFactory threadFactory = ThreadFactoryGenerator.generateFactory(true, "Hawkular WildFly Agent Full Discovery Scan");
        this.fullDiscoveryScanThreadPool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1), threadFactory);
    }

    public String getFeedId() {
        return this.feedId;
    }

    @Override
    public MonitoredEndpoint<MonitorServiceConfiguration.EndpointConfiguration> getMonitoredEndpoint() {
        return this.endpoint;
    }

    public ResourceManager<L> getResourceManager() {
        return this.resourceManager;
    }

    public ResourceTypeManager<L> getResourceTypeManager() {
        return this.resourceTypeManager;
    }

    public LocationResolver<L> getLocationResolver() {
        return this.locationResolver;
    }

    public ProtocolDiagnostics getDiagnostics() {
        return this.diagnostics;
    }

    public void addInventoryListener(InventoryListener listener) {
        this.status.assertInitialOrStopped(this.getClass(), "addInventoryListener()");
        this.inventoryListenerSupport.inventoryListeners.add(listener);
        LOG.debugf("Added inventory listener [%s] for endpoint [%s]", listener, this.getMonitoredEndpoint());
    }

    public void removeInventoryListener(InventoryListener listener) {
        this.status.assertInitialOrStopped(this.getClass(), "removeInventoryListener()");
        this.inventoryListenerSupport.inventoryListeners.remove(listener);
        LOG.debugf("Removed inventory listener [%s] for endpoint [%s]", listener, this.getMonitoredEndpoint());
    }

    public abstract S openSession();

    public void discoverAll() {
        this.status.assertRunning(this.getClass(), "discoverAll()");
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LOG.infoDiscoveryRequested(EndpointService.this.getMonitoredEndpoint());
                long duration = -1L;
                try (Object session = EndpointService.this.openSession();){
                    Set rootTypes = EndpointService.this.resourceTypeManager.getRootResourceTypes();
                    Timer.Context timer = EndpointService.this.getDiagnostics().getFullDiscoveryScanTimer().time();
                    for (ResourceType rootType : rootTypes) {
                        EndpointService.this.discoverChildren(null, rootType, session);
                    }
                    long nanos = timer.stop();
                    duration = TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS);
                }
                catch (Exception e) {
                    LOG.errorCouldNotAccess(EndpointService.this, e);
                }
                EndpointService.this.resourceManager.logTreeGraph("Discovered all resources for [" + EndpointService.this.endpoint + "]", duration);
            }
        };
        try {
            this.fullDiscoveryScanThreadPool.execute(runnable);
        }
        catch (RejectedExecutionException ree) {
            LOG.debugf("Redundant full discovery scan will be ignored for endpoint [%s]", this.getMonitoredEndpoint());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discoverChildren(L parentLocation, ResourceType<L> childType, S session) {
        this.status.assertRunning(this.getClass(), "discoverChildren()");
        LOG.debugf("Being asked to discover children of type [%s] under parent [%s] for endpoint [%s]", childType, parentLocation, this.getMonitoredEndpoint());
        Closeable sessionToUse = null;
        try {
            sessionToUse = (Closeable)(session == null ? this.openSession() : session);
            List<Resource<L>> parents = parentLocation != null ? this.resourceManager.findResources(parentLocation, ((Session)sessionToUse).getLocationResolver()) : Arrays.asList(new Resource[]{null});
            final ArrayList added = new ArrayList();
            Discovery<L> discovery = new Discovery<L>();
            for (Resource<L> parent : parents) {
                discovery.discoverChildren(parent, childType, (Session<L>)sessionToUse, new Consumer<Resource<L>>(){

                    @Override
                    public void accept(Resource<L> resource) {
                        ResourceManager.AddResult result = EndpointService.this.resourceManager.addResource(resource);
                        if (result.getEffect() != ResourceManager.AddResult.Effect.UNCHANGED) {
                            added.add(result.getResource());
                        }
                    }

                    @Override
                    public void report(Throwable e) {
                        LOG.errorCouldNotAccess(EndpointService.this, e);
                    }
                });
            }
            this.inventoryListenerSupport.fireResourcesAdded(Collections.unmodifiableList(added));
        }
        catch (Exception e) {
            LOG.errorCouldNotAccess(this, e);
        }
        finally {
            if (session == null && sessionToUse != null) {
                try {
                    sessionToUse.close();
                }
                catch (IOException ioe) {
                    LOG.warnf("Could not close session created for children discovery", ioe);
                }
            }
        }
    }

    @Override
    public void measureAvails(Collection<MeasurementInstance<L, AvailType<L>>> instances, Consumer<AvailDataPoint> consumer) {
        this.status.assertRunning(this.getClass(), "measureAvails()");
        LOG.debugf("Checking [%d] avails for endpoint [%s]", instances.size(), this.getMonitoredEndpoint());
        try (S session = this.openSession();){
            Driver driver = ((Session)session).getDriver();
            for (MeasurementInstance<L, AvailType<L>> instance : instances) {
                AttributeLocation location = instance.getAttributeLocation();
                Object o = driver.fetchAttribute(location);
                Pattern pattern = ((AvailType)instance.getType()).getUpPattern();
                Avail avail = null;
                if (o instanceof List) {
                    List list = (List)o;
                    for (Object item : list) {
                        Avail a = this.toAvail(pattern, item);
                        if (avail == null) {
                            avail = a;
                            continue;
                        }
                        avail = a == Avail.DOWN ? Avail.DOWN : avail;
                    }
                } else {
                    avail = this.toAvail(((AvailType)instance.getType()).getUpPattern(), o);
                }
                long ts = System.currentTimeMillis();
                String key = this.generateMeasurementKey(instance);
                AvailDataPoint dataPoint = new AvailDataPoint(key, ts, avail);
                consumer.accept(dataPoint);
            }
        }
        catch (Exception e) {
            LOG.errorCouldNotAccess(this, e);
        }
    }

    @Override
    public void measureMetrics(Collection<MeasurementInstance<L, MetricType<L>>> instances, Consumer<MetricDataPoint> consumer) {
        this.status.assertRunning(this.getClass(), "measureMetrics()");
        LOG.debugf("Collecting [%d] metrics for endpoint [%s]", instances.size(), this.getMonitoredEndpoint());
        try (S session = this.openSession();){
            Driver driver = ((Session)session).getDriver();
            for (MeasurementInstance<L, MetricType<L>> instance : instances) {
                AttributeLocation location = instance.getAttributeLocation();
                Object o = driver.fetchAttribute(location);
                double value = 0.0;
                if (o instanceof List) {
                    List list = (List)o;
                    for (Object item : list) {
                        double num = this.toDouble(item);
                        value += num;
                    }
                } else {
                    value = this.toDouble(o);
                }
                long ts = System.currentTimeMillis();
                String key = this.generateMeasurementKey(instance);
                MetricDataPoint dataPoint = new MetricDataPoint(key, ts, value, ((MetricType)instance.getType()).getMetricType());
                consumer.accept(dataPoint);
            }
        }
        catch (Exception e) {
            LOG.errorCouldNotAccess(this, e);
        }
    }

    public void removeResources(L location) {
        this.status.assertRunning(this.getClass(), "removeResources()");
        try (S session = this.openSession();){
            List<Resource<L>> removed = this.resourceManager.removeResources(location, ((Session)session).getLocationResolver());
            this.inventoryListenerSupport.fireResourcesRemoved(removed);
        }
        catch (Exception e) {
            LOG.errorCouldNotAccess(this, e);
        }
    }

    public final void start() {
        this.status.assertInitialOrStopped(this.getClass(), "start()");
        this.status = ServiceStatus.STARTING;
        this.status = ServiceStatus.RUNNING;
        LOG.debugf("Started [%s]", this.toString());
    }

    public void stop() {
        this.status.assertRunning(this.getClass(), "stop()");
        this.status = ServiceStatus.STOPPING;
        this.status = ServiceStatus.STOPPED;
        LOG.debugf("Stopped [%s]", this.toString());
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.getMonitoredEndpoint());
    }

    public int hashCode() {
        int result = 31 + (this.endpoint == null ? 0 : this.endpoint.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EndpointService)) {
            return false;
        }
        EndpointService other = (EndpointService)obj;
        return !(this.endpoint == null ? other.endpoint != null : !this.endpoint.equals(other.endpoint));
    }

    public String generateMeasurementKey(MeasurementInstance<L, ?> instance) {
        String key = instance.getID().getIDString();
        return key;
    }

    private double toDouble(Object valueObject) {
        double value = valueObject == null ? Double.NaN : (valueObject instanceof Number ? ((Number)valueObject).doubleValue() : Double.valueOf(valueObject.toString()).doubleValue());
        return value;
    }

    private Avail toAvail(Pattern pattern, Object value) {
        if (pattern == null) {
            if (value instanceof Boolean) {
                return (Boolean)value != false ? Avail.UP : Avail.DOWN;
            }
            if (value instanceof String) {
                return AvailType.getDefaultUpPattern().matcher((String)value).matches() ? Avail.UP : Avail.DOWN;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue() == 0 ? Avail.DOWN : Avail.UP;
            }
            throw new RuntimeException("Cannot handle an availability value of type [" + value.getClass().getName() + "]");
        }
        return pattern.matcher(String.valueOf(value)).matches() ? Avail.UP : Avail.DOWN;
    }

    private class InventoryListenerSupport {
        private final List<InventoryListener> inventoryListeners = new ArrayList<InventoryListener>();

        private InventoryListenerSupport() {
        }

        public void fireResourcesAdded(List<Resource<L>> resources) {
            if (!resources.isEmpty()) {
                LOG.debugf("Firing inventory event for [%s] added/modified resources", resources.size());
                InventoryEvent event = new InventoryEvent(EndpointService.this, resources);
                for (InventoryListener inventoryListener : this.inventoryListeners) {
                    inventoryListener.resourcesAdded(event);
                }
            }
        }

        public void fireResourcesRemoved(List<Resource<L>> resources) {
            if (!resources.isEmpty()) {
                LOG.debugf("Firing inventory event for [%s] removed resources", resources.size());
                InventoryEvent event = new InventoryEvent(EndpointService.this, resources);
                for (InventoryListener inventoryListener : this.inventoryListeners) {
                    inventoryListener.resourcesRemoved(event);
                }
            }
        }
    }
}

