/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.dynamicprotocol;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.hawkular.agent.monitor.dynamicprotocol.DynamicEndpointService;
import org.hawkular.agent.monitor.util.ThreadFactoryGenerator;

public class DynamicProtocolService {
    private final Map<String, DynamicEndpointService> endpointServices;
    private ScheduledExecutorService threadPool;

    public static Builder builder() {
        return new Builder();
    }

    public DynamicProtocolService(Map<String, DynamicEndpointService> endpointServices) {
        this.endpointServices = endpointServices;
    }

    public Map<String, DynamicEndpointService> getDynamicEndpointServices() {
        return this.endpointServices;
    }

    public void start() {
        ThreadFactory threadFactory = ThreadFactoryGenerator.generateFactory(true, "Hawkular WildFly Agent Dynamic Protocol Service Thread Pool");
        this.threadPool = Executors.newScheduledThreadPool(1, threadFactory);
        for (DynamicEndpointService service : this.endpointServices.values()) {
            service.start();
            int interval = service.getMonitoredEndpoint().getEndpointConfiguration().getInterval();
            TimeUnit timeUnits = service.getMonitoredEndpoint().getEndpointConfiguration().getTimeUnits();
            long startDelay = new Random().nextInt(60);
            long intervalSecs = timeUnits.convert(interval, timeUnits);
            this.threadPool.scheduleWithFixedDelay(service, startDelay, intervalSecs, TimeUnit.SECONDS);
        }
    }

    public void stop() {
        try {
            this.threadPool.shutdown();
            this.threadPool.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        for (DynamicEndpointService service : this.endpointServices.values()) {
            service.stop();
        }
    }

    public static class Builder {
        private Map<String, DynamicEndpointService> endpointServices = new HashMap<String, DynamicEndpointService>();

        public DynamicProtocolService build() {
            return new DynamicProtocolService(Collections.unmodifiableMap(this.endpointServices));
        }

        public Builder endpointService(DynamicEndpointService endpointService) {
            this.endpointServices.put(endpointService.getMonitoredEndpoint().getName(), endpointService);
            return this;
        }
    }
}

