/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.extension;

import org.hawkular.agent.monitor.extension.SubsystemExtension;
import org.hawkular.agent.monitor.service.MonitorService;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.ServiceRegistry;

public class OperationSubsystemStart
implements OperationStepHandler {
    private static final Logger LOGGER = Logger.getLogger(OperationSubsystemStart.class);

    public void execute(OperationContext opContext, ModelNode model) throws OperationFailedException {
        try {
            ServiceName name = SubsystemExtension.SERVICE_NAME;
            ServiceRegistry serviceRegistry = opContext.getServiceRegistry(true);
            MonitorService service = (MonitorService)serviceRegistry.getRequiredService(name).getValue();
            boolean restart = model.get("restart").asBoolean(false);
            if (restart) {
                LOGGER.debug((Object)"Asked to restart the Hawkualr Monitor service. Will stop it, then restart it now.");
                service.stopMonitorService();
            } else {
                LOGGER.debug((Object)"Asked to start the Hawkular Monitor service");
            }
            if (!service.isMonitorServiceStarted()) {
                service.startMonitorService();
            }
        }
        catch (ServiceNotFoundException snfe) {
            throw new OperationFailedException("Cannot restart Hawkular Monitor service - it is disabled", (Throwable)snfe);
        }
        catch (Exception e) {
            throw new OperationFailedException("Cannot restart Hawkular Monitor service", (Throwable)e);
        }
        opContext.stepCompleted();
    }
}

