/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.storage;

import com.codahale.metrics.Timer;
import com.fasterxml.jackson.core.type.TypeReference;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.hawkular.agent.monitor.api.InventoryEvent;
import org.hawkular.agent.monitor.api.InventoryStorage;
import org.hawkular.agent.monitor.diagnostics.Diagnostics;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.Instance;
import org.hawkular.agent.monitor.inventory.MeasurementInstance;
import org.hawkular.agent.monitor.inventory.MeasurementType;
import org.hawkular.agent.monitor.inventory.MetricType;
import org.hawkular.agent.monitor.inventory.NamedObject;
import org.hawkular.agent.monitor.inventory.Operation;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.inventory.ResourceConfigurationPropertyInstance;
import org.hawkular.agent.monitor.inventory.ResourceConfigurationPropertyType;
import org.hawkular.agent.monitor.inventory.ResourceType;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.storage.HttpClientBuilder;
import org.hawkular.agent.monitor.util.Util;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricDataType;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.MetricUnit;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.StructuredData;

public class AsyncInventoryStorage
implements InventoryStorage {
    private static final MsgLogger log = AgentLoggers.getLogger(AsyncInventoryStorage.class);
    private final String feedId;
    private final MonitorServiceConfiguration.StorageAdapterConfiguration config;
    private final HttpClientBuilder httpClientBuilder;
    private final Diagnostics diagnostics;
    private final ArrayBlockingQueue<QueueElement> queue;
    private final Worker worker;

    private static String getInventoryId(NamedObject no) {
        String id = no.getID().equals(ID.NULL_ID) ? no.getName().getNameString() : no.getID().getIDString();
        return id;
    }

    public AsyncInventoryStorage(String feedId, MonitorServiceConfiguration.StorageAdapterConfiguration config, HttpClientBuilder httpClientBuilder, Diagnostics diagnostics) {
        this.feedId = feedId;
        this.config = config;
        this.httpClientBuilder = httpClientBuilder;
        this.diagnostics = diagnostics;
        this.queue = new ArrayBlockingQueue(10000);
        this.worker = new Worker(this.queue);
        this.worker.start();
    }

    public void shutdown() {
        log.debugf("Shutting down async inventory storage", new Object[0]);
        this.worker.stopRunning();
        this.worker.interrupt();
        try {
            this.worker.join(60000L);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public <L> void resourcesAdded(InventoryEvent<L> event) {
        for (Resource<L> resource : event.getPayload()) {
            this.diagnostics.getInventoryStorageBufferSize().inc();
            this.queue.add(new AddResourceQueueElement(this.feedId, resource));
        }
    }

    @Override
    public <L> void resourcesRemoved(InventoryEvent<L> event) {
        for (Resource<L> resource : event.getPayload()) {
            this.diagnostics.getInventoryStorageBufferSize().inc();
            this.queue.add(new RemoveResourceQueueElement(this.feedId, resource));
        }
    }

    private class Worker
    extends Thread {
        private final ArrayBlockingQueue<QueueElement> queue;
        private boolean keepRunning;

        public Worker(ArrayBlockingQueue<QueueElement> queue) {
            super("Hawkular-WildFly-Agent-Inventory-Storage");
            this.keepRunning = true;
            this.queue = queue;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (this.keepRunning) {
                    QueueElement sample = this.queue.take();
                    ArrayList<QueueElement> qElements = new ArrayList<QueueElement>();
                    qElements.add(sample);
                    do {
                        Thread.sleep(2000L);
                    } while (this.queue.drainTo(qElements) > 0);
                    AsyncInventoryStorage.this.diagnostics.getInventoryStorageBufferSize().dec((long)qElements.size());
                    try {
                        ArrayList contiguousGroups = new ArrayList();
                        ArrayList<QueueElement> nextGroup = new ArrayList<QueueElement>();
                        contiguousGroups.add(nextGroup);
                        for (QueueElement qElement : qElements) {
                            if (!nextGroup.isEmpty() && !((QueueElement)nextGroup.get(0)).getClass().isInstance(qElement)) {
                                nextGroup = new ArrayList();
                                contiguousGroups.add(nextGroup);
                            }
                            nextGroup.add(qElement);
                        }
                        for (List contiguousGroup : contiguousGroups) {
                            QueueElement firstElement = (QueueElement)contiguousGroup.get(0);
                            if (firstElement instanceof AddResourceQueueElement) {
                                this.addResources(contiguousGroup);
                                continue;
                            }
                            if (firstElement instanceof RemoveResourceQueueElement) {
                                this.removeResources(contiguousGroup);
                                continue;
                            }
                            log.errorInvalidQueueElement(firstElement.getClass());
                        }
                    }
                    catch (InterruptedException ie) {
                        throw ie;
                    }
                    catch (Exception exception) {
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void stopRunning() {
            this.keepRunning = false;
        }

        private void removeResources(List<QueueElement> removeQueueElements) throws Exception {
            log.debugf("Removing [%d] resources that were found in inventory work queue", removeQueueElements.size());
            StringBuilder url = Util.getContextUrlString(AsyncInventoryStorage.this.config.getUrl(), AsyncInventoryStorage.this.config.getInventoryContext());
            for (QueueElement resourceElement : removeQueueElements) {
                StringBuilder deleteUrl = new StringBuilder(url.toString());
                deleteUrl.append("feeds/").append(resourceElement.getFeedId()).append("/resources");
                for (Resource<?> resource : this.getAncestry(resourceElement.getResource())) {
                    deleteUrl.append('/');
                    deleteUrl.append(Util.urlEncode(resource.getID().getIDString()));
                }
                Request request = AsyncInventoryStorage.this.httpClientBuilder.buildJsonDeleteRequest(deleteUrl.toString(), null);
                long start = System.currentTimeMillis();
                Response response = AsyncInventoryStorage.this.httpClientBuilder.getHttpClient().newCall(request).execute();
                long duration = System.currentTimeMillis() - start;
                if (response.code() != 204 && response.code() != 404) {
                    throw new Exception("status-code=[" + response.code() + "], reason=[" + response.message() + "], url=[" + request.urlString() + "]");
                }
                log.debugf("Took [%d]ms to remove resource [%s]", duration, resourceElement.getResource());
            }
        }

        private void addResources(List<QueueElement> addQueueElements) throws Exception {
            log.debugf("Adding [%d] resources that were found in inventory work queue", addQueueElements.size());
            BulkPayloadBuilder builder = new BulkPayloadBuilder(AsyncInventoryStorage.this.config.getTenantId(), AsyncInventoryStorage.this.feedId);
            for (QueueElement elem : addQueueElements) {
                Resource<?> resource = elem.getResource();
                ResourceType<?> resourceType = resource.getResourceType();
                builder.resourceType(resourceType);
                if (resource.getParent() != null && !resource.getParent().isPersisted()) {
                    log.debugf("Parent [%s] of resource [%s] might not have been persisted. This may or may not cause problems storing to inventory.", resource.getParent(), resource);
                }
                builder.resource(resource);
                log.debugf("Storing resource and eventually its type in inventory: [%s]", resource);
            }
            Map<String, Map<String, List<AbstractElement.Blueprint>>> payload = builder.build();
            if (!payload.isEmpty()) {
                try {
                    Reader responseBodyReader;
                    StringBuilder url = Util.getContextUrlString(AsyncInventoryStorage.this.config.getUrl(), AsyncInventoryStorage.this.config.getInventoryContext());
                    url.append("bulk");
                    String jsonPayload = Util.toJson(payload);
                    log.tracef("About to send a bulk insert request to inventory: [%s]", jsonPayload);
                    Request request = AsyncInventoryStorage.this.httpClientBuilder.buildJsonPostRequest(url.toString(), null, jsonPayload);
                    Call call = AsyncInventoryStorage.this.httpClientBuilder.getHttpClient().newCall(request);
                    Timer.Context timer = AsyncInventoryStorage.this.diagnostics.getInventoryStorageRequestTimer().time();
                    Response response = call.execute();
                    long durationNanos = timer.stop();
                    if (response.code() != 201 && response.code() != 409) {
                        throw new Exception("status-code=[" + response.code() + "], reason=[" + response.message() + "], url=[" + request.urlString() + "]");
                    }
                    AsyncInventoryStorage.this.diagnostics.getInventoryRate().mark((long)addQueueElements.size());
                    if (log.isDebugEnabled()) {
                        long durationMs = TimeUnit.MILLISECONDS.convert(durationNanos, TimeUnit.NANOSECONDS);
                        log.debugf("Took [%d]ms to store [%d] resources", durationMs, addQueueElements.size());
                        String body = response.body().string();
                        responseBodyReader = new StringReader(body);
                        log.tracef("Body of bulk insert request response: %s", body);
                    } else {
                        responseBodyReader = response.body().charStream();
                    }
                    TypeReference<LinkedHashMap<String, LinkedHashMap<String, Object>>> typeRef = new TypeReference<LinkedHashMap<String, LinkedHashMap<String, Object>>>(){};
                    LinkedHashMap<String, LinkedHashMap<String, Object>> responses = Util.fromJson(responseBodyReader, typeRef);
                    for (Map.Entry<String, LinkedHashMap<String, Object>> typeEntry : responses.entrySet()) {
                        block8: for (Map.Entry<String, Object> entityEntry : typeEntry.getValue().entrySet()) {
                            Object rawCode = entityEntry.getValue();
                            if (!(rawCode instanceof Integer)) continue;
                            int code = (Integer)rawCode;
                            switch (code) {
                                case 201: 
                                case 409: {
                                    continue block8;
                                }
                            }
                            log.errorFailedToStorePathToInventory(code, typeEntry.getKey(), entityEntry.getKey());
                        }
                    }
                    for (QueueElement elem : addQueueElements) {
                        elem.getResource().setPersisted(true);
                        elem.getResource().getResourceType().setPersisted(true);
                    }
                }
                catch (InterruptedException ie) {
                    throw ie;
                }
                catch (Exception e) {
                    AsyncInventoryStorage.this.diagnostics.getStorageErrorRate().mark(1L);
                    log.errorFailedToStoreInventoryData(e);
                    throw new Exception("Cannot create resources or their resourceTypes", e);
                }
            }
        }

        private List<Resource<?>> getAncestry(Resource<?> resource) {
            ArrayList ancestry = new ArrayList();
            for (Resource<?> current = resource; current != null; current = current.getParent()) {
                ancestry.add(current);
            }
            Collections.reverse(ancestry);
            return ancestry;
        }
    }

    private static class BulkPayloadBuilder {
        private Map<String, Map<String, List<AbstractElement.Blueprint>>> result = new LinkedHashMap<String, Map<String, List<AbstractElement.Blueprint>>>();
        private Set<String> addedIds = new HashSet<String>();
        private final String feedId;
        private final String tenantId;

        public BulkPayloadBuilder(String tenantId, String feedId) {
            this.tenantId = tenantId;
            this.feedId = feedId;
        }

        public Map<String, Map<String, List<AbstractElement.Blueprint>>> build() {
            Map<String, Map<String, List<AbstractElement.Blueprint>>> result = this.result;
            this.result = new LinkedHashMap<String, Map<String, List<AbstractElement.Blueprint>>>();
            this.addedIds = new HashSet<String>();
            return result;
        }

        private BulkPayloadBuilder entity(Entity.Blueprint blueprint, Class<? extends Entity<?, ?>> entityClass) {
            String parentPath = ((CanonicalPath)this.newPathPrefix().get()).toString();
            return this.entity(blueprint, entityClass, parentPath);
        }

        private BulkPayloadBuilder entity(Entity.Blueprint blueprint, Class<? extends Entity<?, ?>> entityClass, String parentPath) {
            String id = blueprint.getId();
            if (!this.addedIds.contains(id)) {
                this.relationshipOrEntity(parentPath, entityClass, (AbstractElement.Blueprint)blueprint);
                this.addedIds.add(id);
            }
            return this;
        }

        private void metric(Instance<?, ?> metric) {
            String metricId = AsyncInventoryStorage.getInventoryId(metric);
            String metricTypeId = AsyncInventoryStorage.getInventoryId(metric.getType());
            String metricTypePath = ((CanonicalPath)((CanonicalPath.MetricTypeBuilder)this.newPathPrefix().metricType(metricTypeId)).get()).toString();
            Metric.Blueprint blueprint = new Metric.Blueprint(metricTypePath, metricId, metric.getName().getNameString(), metric.getProperties(), null, null);
            this.entity((Entity.Blueprint)blueprint, Metric.class);
        }

        private void metricType(MeasurementType<?> metricType) {
            MetricDataType metricDataType;
            MetricUnit mu = MetricUnit.NONE;
            if (metricType instanceof MetricType) {
                mu = MetricUnit.valueOf((String)((MetricType)metricType).getMetricUnits().name());
                switch (((MetricType)metricType).getMetricType()) {
                    case GAUGE: {
                        metricDataType = MetricDataType.GAUGE;
                        break;
                    }
                    case COUNTER: {
                        metricDataType = MetricDataType.COUNTER;
                        break;
                    }
                    default: {
                        metricDataType = MetricDataType.GAUGE;
                        break;
                    }
                }
            } else if (metricType instanceof AvailType) {
                metricDataType = MetricDataType.AVAILABILITY;
            } else {
                throw new IllegalArgumentException("Invalid measurement type - please report this bug: " + metricType.getClass());
            }
            MetricType.Blueprint blueprint = new MetricType.Blueprint(AsyncInventoryStorage.getInventoryId(metricType), metricType.getName().getNameString(), mu, metricDataType, metricType.getProperties(), Long.valueOf(metricType.getInterval().seconds()), null, null);
            this.entity((Entity.Blueprint)blueprint, org.hawkular.inventory.api.model.MetricType.class);
        }

        private void operation(Operation<?> operation, String resourceTypePath) {
            OperationType.Blueprint blueprint = new OperationType.Blueprint(AsyncInventoryStorage.getInventoryId(operation), operation.getName().getNameString(), operation.getProperties(), null, null);
            this.entity((Entity.Blueprint)blueprint, OperationType.class, resourceTypePath);
        }

        private CanonicalPath.FeedBuilder newPathPrefix() {
            return (CanonicalPath.FeedBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(this.tenantId)).feed(this.feedId);
        }

        private void relationship(CanonicalPath parent, Relationship.Blueprint child) {
            this.relationshipOrEntity(parent.toString(), Relationship.class, (AbstractElement.Blueprint)child);
        }

        private void relationshipOrEntity(String path, Class<? extends AbstractElement<?, ?>> entityClass, AbstractElement.Blueprint blueprint) {
            String key;
            List<AbstractElement.Blueprint> list;
            Map<String, List<AbstractElement.Blueprint>> pathEntities = this.result.get(path);
            if (pathEntities == null) {
                pathEntities = new LinkedHashMap<String, List<AbstractElement.Blueprint>>();
                this.result.put(path, pathEntities);
            }
            if ((list = pathEntities.get(key = BulkPayloadBuilder.toKey(entityClass))) == null) {
                list = new ArrayList<AbstractElement.Blueprint>();
                pathEntities.put(key, list);
            }
            list.add(blueprint);
        }

        public <L> BulkPayloadBuilder resource(Resource<L> resource) {
            String resourceTypePath = ((CanonicalPath)((CanonicalPath.ResourceTypeBuilder)this.newPathPrefix().resourceType(AsyncInventoryStorage.getInventoryId(resource.getResourceType()))).get()).toString();
            Resource.Blueprint rPojo = new Resource.Blueprint(AsyncInventoryStorage.getInventoryId(resource), resource.getName().getNameString(), resourceTypePath, resource.getProperties(), null, null);
            StringBuilder parentPath = new StringBuilder();
            for (Resource<L> parent = resource.getParent(); parent != null; parent = parent.getParent()) {
                String resourceIdPath = "/" + Util.urlEncode(parent.getID().getIDString());
                parentPath.insert(0, resourceIdPath);
            }
            CanonicalPath parentCanonicalPath = parentPath.length() == 0 ? (CanonicalPath)this.newPathPrefix().get() : CanonicalPath.fromPartiallyUntypedString((String)parentPath.toString(), (CanonicalPath)((CanonicalPath)this.newPathPrefix().get()), org.hawkular.inventory.api.model.Resource.class);
            this.relationshipOrEntity(parentCanonicalPath.toString(), org.hawkular.inventory.api.model.Resource.class, (AbstractElement.Blueprint)rPojo);
            String resourcePath = parentPath.toString() + "/" + Util.urlEncode(resource.getID().getIDString());
            CanonicalPath resourceCanonicalPath = CanonicalPath.fromPartiallyUntypedString((String)resourcePath, (CanonicalPath)((CanonicalPath)this.newPathPrefix().get()), org.hawkular.inventory.api.model.Resource.class);
            Collection<ResourceConfigurationPropertyInstance<L>> resConfigInstances = resource.getResourceConfigurationProperties();
            if (resConfigInstances != null && !resConfigInstances.isEmpty()) {
                StructuredData.MapBuilder structDataBuilder = StructuredData.get().map();
                for (ResourceConfigurationPropertyInstance<L> resourceConfigurationPropertyInstance : resConfigInstances) {
                    structDataBuilder.putString(resourceConfigurationPropertyInstance.getID().getIDString(), resourceConfigurationPropertyInstance.getValue());
                }
                DataEntity.Blueprint dataEntity = new DataEntity.Blueprint((DataEntity.Role)Resources.DataRole.configuration, structDataBuilder.build(), null);
                this.relationshipOrEntity(resourceCanonicalPath.toString(), DataEntity.class, (AbstractElement.Blueprint)dataEntity);
            }
            Collection<MeasurementInstance<L, MetricType<L>>> metricInstances = resource.getMetrics();
            for (Instance instance : metricInstances) {
                this.metric(instance);
                CanonicalPath canonicalPath = (CanonicalPath)((CanonicalPath.MetricBuilder)this.newPathPrefix().metric(AsyncInventoryStorage.getInventoryId(instance))).get();
                Relationship.Blueprint bp = new Relationship.Blueprint(Relationships.Direction.outgoing, Relationships.WellKnown.incorporates.toString(), canonicalPath, Collections.emptyMap());
                this.relationship(resourceCanonicalPath, bp);
            }
            Collection<MeasurementInstance<L, AvailType<L>>> availInstances = resource.getAvails();
            for (Instance instance : availInstances) {
                this.metric(instance);
                CanonicalPath metricPath = (CanonicalPath)((CanonicalPath.MetricBuilder)this.newPathPrefix().metric(AsyncInventoryStorage.getInventoryId(instance))).get();
                Relationship.Blueprint bp = new Relationship.Blueprint(Relationships.Direction.outgoing, Relationships.WellKnown.incorporates.toString(), metricPath, Collections.emptyMap());
                this.relationship(resourceCanonicalPath, bp);
            }
            return this;
        }

        public BulkPayloadBuilder resourceType(ResourceType<?> resourceType) {
            String resourceTypeId = AsyncInventoryStorage.getInventoryId(resourceType);
            ResourceType.Blueprint blueprint = new ResourceType.Blueprint(resourceTypeId, resourceType.getName().getNameString(), resourceType.getProperties(), null, null);
            this.entity((Entity.Blueprint)blueprint, org.hawkular.inventory.api.model.ResourceType.class);
            CanonicalPath parentPath = (CanonicalPath)((CanonicalPath.ResourceTypeBuilder)this.newPathPrefix().resourceType(AsyncInventoryStorage.getInventoryId(resourceType))).get();
            Collection<MetricType<?>> metricTypes = resourceType.getMetricTypes();
            for (MetricType<?> metricType : metricTypes) {
                this.metricType(metricType);
                String string = AsyncInventoryStorage.getInventoryId(metricType);
                CanonicalPath metricTypePath = (CanonicalPath)((CanonicalPath.MetricTypeBuilder)this.newPathPrefix().metricType(string)).get();
                Relationship.Blueprint blueprint2 = new Relationship.Blueprint(Relationships.Direction.outgoing, Relationships.WellKnown.incorporates.toString(), metricTypePath, Collections.emptyMap());
                this.relationship(parentPath, blueprint2);
            }
            Collection<AvailType<?>> availTypes = resourceType.getAvailTypes();
            for (AvailType<?> availType : availTypes) {
                this.metricType(availType);
                String metricTypeId = AsyncInventoryStorage.getInventoryId(availType);
                CanonicalPath canonicalPath = (CanonicalPath)((CanonicalPath.MetricTypeBuilder)this.newPathPrefix().metricType(metricTypeId)).get();
                Relationship.Blueprint bp = new Relationship.Blueprint(Relationships.Direction.outgoing, Relationships.WellKnown.incorporates.toString(), canonicalPath, Collections.emptyMap());
                this.relationship(parentPath, bp);
            }
            String string = ((CanonicalPath)((CanonicalPath.ResourceTypeBuilder)this.newPathPrefix().resourceType(resourceTypeId)).get()).toString();
            Collection<Operation<?>> collection = resourceType.getOperations();
            for (Operation operation : collection) {
                this.operation(operation, string);
            }
            Collection<ResourceConfigurationPropertyType<?>> rcpts = resourceType.getResourceConfigurationPropertyTypes();
            if (rcpts != null && !rcpts.isEmpty()) {
                StructuredData.MapBuilder mapBuilder = StructuredData.get().map();
                for (ResourceConfigurationPropertyType resourceConfigurationPropertyType : rcpts) {
                    mapBuilder.putString(resourceConfigurationPropertyType.getID().getIDString(), resourceConfigurationPropertyType.getName().getNameString());
                }
                DataEntity.Blueprint dataEntity = new DataEntity.Blueprint((DataEntity.Role)ResourceTypes.DataRole.configurationSchema, mapBuilder.build(), null);
                this.relationshipOrEntity(parentPath.toString(), DataEntity.class, (AbstractElement.Blueprint)dataEntity);
            }
            return this;
        }

        private static String toKey(Class<? extends AbstractElement<?, ?>> cl) {
            String src = cl.getSimpleName();
            return new StringBuilder(src.length()).append(Character.toLowerCase(src.charAt(0))).append(src.substring(1)).toString();
        }
    }

    private static class RemoveResourceQueueElement
    extends QueueElement {
        public RemoveResourceQueueElement(String feedId, Resource<?> resource) {
            super(feedId, resource);
        }
    }

    private static class AddResourceQueueElement
    extends QueueElement {
        public AddResourceQueueElement(String feedId, Resource<?> resource) {
            super(feedId, resource);
        }
    }

    private static abstract class QueueElement {
        private final String feedId;
        private final Resource<?> resource;

        public QueueElement(String feedId, Resource<?> resource) {
            this.feedId = feedId;
            this.resource = resource;
        }

        public String getFeedId() {
            return this.feedId;
        }

        public Resource<?> getResource() {
            return this.resource;
        }

        public String toString() {
            return String.format("%s:%s:%s", this.getClass().getSimpleName(), this.getFeedId(), this.getResource());
        }
    }
}

