/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.cmd;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import org.hawkular.agent.monitor.cmd.Command;
import org.hawkular.agent.monitor.cmd.CommandContext;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.inventory.InventoryIdUtil;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.hawkular.agent.monitor.protocol.dmr.DMRSession;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.cmdgw.api.MessageUtils;
import org.hawkular.cmdgw.api.ResourcePathRequest;
import org.hawkular.cmdgw.api.ResourcePathResponse;
import org.hawkular.cmdgw.api.ResponseStatus;
import org.hawkular.cmdgw.api.ServerRefreshIndicator;
import org.hawkular.dmr.api.OperationBuilder;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public abstract class AbstractResourcePathCommand<REQ extends ResourcePathRequest, RESP extends ResourcePathResponse>
implements Command<REQ, RESP> {
    private static final MsgLogger log = AgentLoggers.getLogger(AbstractResourcePathCommand.class);
    protected final String entityType;
    protected final String operationName;

    public AbstractResourcePathCommand(String operationName, String entityType) {
        this.operationName = operationName;
        this.entityType = entityType;
    }

    protected String getOperationName(BasicMessageWithExtraData<REQ> envelope) {
        return this.operationName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BasicMessageWithExtraData<RESP> execute(BasicMessageWithExtraData<REQ> envelope, CommandContext context) throws Exception {
        ResourcePathRequest request = (ResourcePathRequest)envelope.getBasicMessage();
        String rawResourcePath = request.getResourcePath();
        log.infoReceivedResourcePathCommand(this.getOperationName(envelope), this.entityType, rawResourcePath);
        RESP response = this.createResponse();
        MessageUtils.prepareResourcePathResponse((ResourcePathRequest)request, response);
        BinaryData binaryData = null;
        Object controllerClient = null;
        long timestampBeforeExecution = System.currentTimeMillis();
        try {
            this.validate(envelope);
            CanonicalPath canonicalPath = CanonicalPath.fromString((String)rawResourcePath);
            String resourceId = canonicalPath.ids().getResourcePath().getSegment().getElementId();
            InventoryIdUtil.ResourceIdParts idParts = InventoryIdUtil.parseResourceId(resourceId);
            String modelNodePath = idParts.getIdPart();
            this.validate(modelNodePath, envelope);
            String managedServerName = idParts.getManagedServerName();
            EndpointService<DMRNodeLocation, DMRSession> endpointService = context.getDiscoveryService().getProtocolServices().getDmrProtocolService().getEndpointServices().get(managedServerName);
            if (endpointService == null) {
                throw new IllegalArgumentException(String.format("Cannot perform [%s] on a [%s] given by inventory path [%s]: unknown managed server [%s]", this.getOperationName(envelope), this.entityType, managedServerName));
            }
            this.validate(envelope, endpointService.getMonitoredEndpoint());
            DMRSession session = endpointService.openSession();
            controllerClient = session.getClient();
            binaryData = this.execute((ModelControllerClient)controllerClient, endpointService, modelNodePath, envelope, response, context, session);
            this.success(envelope, response);
        }
        catch (Throwable t) {
            response.setStatus(ResponseStatus.ERROR);
            String formattedTimestamp = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mmX").withZone(ZoneOffset.UTC).format(Instant.ofEpochMilli(timestampBeforeExecution));
            String msg = String.format("Could not perform [%s] on a [%s] given by inventory path [%s] requested on [%s]: %s", this.getOperationName(envelope), this.entityType, rawResourcePath, formattedTimestamp, t.getMessage());
            response.setMessage(msg);
            log.debug(msg, t);
        }
        finally {
            if (controllerClient != null) {
                try {
                    controllerClient.close();
                }
                catch (Exception e) {
                    log.errorCannotClose(e, controllerClient.getClass().getName());
                }
            }
        }
        return new BasicMessageWithExtraData(response, binaryData);
    }

    protected abstract BinaryData execute(ModelControllerClient var1, EndpointService<DMRNodeLocation, DMRSession> var2, String var3, BasicMessageWithExtraData<REQ> var4, RESP var5, CommandContext var6, DMRSession var7) throws Exception;

    protected abstract void validate(String var1, BasicMessageWithExtraData<REQ> var2);

    protected void validate(BasicMessageWithExtraData<REQ> envelope) {
        if (((ResourcePathRequest)envelope.getBasicMessage()).getResourcePath() == null) {
            throw new IllegalArgumentException(String.format("resourcePath of a [%s] cannot be null", envelope.getClass().getName()));
        }
    }

    protected abstract void validate(BasicMessageWithExtraData<REQ> var1, MonitoredEndpoint<? extends MonitorServiceConfiguration.AbstractEndpointConfiguration> var2);

    protected abstract RESP createResponse();

    protected void success(BasicMessageWithExtraData<REQ> envelope, RESP response) {
        response.setStatus(ResponseStatus.OK);
        String msg = String.format("Performed [%s] on a [%s] given by Inventory path [%s]", this.getOperationName(envelope), this.entityType, ((ResourcePathRequest)envelope.getBasicMessage()).getResourcePath());
        response.setMessage(msg);
    }

    protected void setServerRefreshIndicator(OperationBuilder.OperationResult<?> opResults, RESP response) {
        Optional processState = opResults.getOptionalProcessState();
        if (processState.isPresent()) {
            try {
                response.setServerRefreshIndicator(ServerRefreshIndicator.fromValue((String)((String)processState.get()).toUpperCase()));
            }
            catch (Exception e) {
                log.warnf("Cannot set server refresh indicator - process state is invalid", e);
            }
        }
    }

    protected void assertLocalServer(MonitoredEndpoint<? extends MonitorServiceConfiguration.AbstractEndpointConfiguration> endpoint) {
        if (!endpoint.isLocal()) {
            throw new IllegalStateException(String.format("Cannot perform [%s] on a [%s] on a non local instance of [%s].", this.operationName, this.entityType, endpoint.getClass().getName()));
        }
    }

    protected void assertNotRename(ModelNode adr, String newName) {
        List adrProps = adr.asPropertyList();
        String nameFromPath = ((Property)adrProps.get(adrProps.size() - 1)).getValue().asString();
        if (!nameFromPath.equals(newName)) {
            String msg = String.format("Renaming a [%s] is not supported. Old name: [%s], new name: [%s]", this.entityType, nameFromPath, newName);
            throw new IllegalArgumentException(msg);
        }
    }
}

