/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.dynamicprotocol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.hawkular.agent.monitor.api.HawkularWildFlyAgentContext;
import org.hawkular.agent.monitor.dynamicprotocol.DynamicProtocolService;
import org.hawkular.agent.monitor.dynamicprotocol.prometheus.PrometheusDynamicEndpointService;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.inventory.Name;
import org.hawkular.agent.monitor.inventory.NameSet;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.jboss.msc.value.InjectedValue;

public class DynamicProtocolServices {
    private static final MsgLogger log = AgentLoggers.getLogger(DynamicProtocolServices.class);
    private final DynamicProtocolService prometheusProtocolService;
    private final List<DynamicProtocolService> services;

    public static Builder builder(String feedId, Map<String, InjectedValue<SSLContext>> sslContexts) {
        return new Builder(feedId, sslContexts);
    }

    public DynamicProtocolServices(DynamicProtocolService prometheusProtocolService) {
        this.prometheusProtocolService = prometheusProtocolService;
        this.services = Collections.unmodifiableList(Arrays.asList(prometheusProtocolService));
    }

    public void start() {
        for (DynamicProtocolService service : this.services) {
            service.start();
        }
    }

    public void stop() {
        for (DynamicProtocolService service : this.services) {
            service.stop();
        }
    }

    public DynamicProtocolService getPrometheusProtocolService() {
        return this.prometheusProtocolService;
    }

    public List<DynamicProtocolService> getServices() {
        return this.services;
    }

    public static class Builder {
        private final String feedId;
        private DynamicProtocolService prometheusProtocolService;
        private final Map<String, InjectedValue<SSLContext>> sslContexts;

        public Builder(String feedId, Map<String, InjectedValue<SSLContext>> sslContexts) {
            this.feedId = feedId;
            this.sslContexts = sslContexts;
        }

        public DynamicProtocolServices build() {
            return new DynamicProtocolServices(this.prometheusProtocolService);
        }

        public Builder prometheusDynamicProtocolService(MonitorServiceConfiguration.DynamicProtocolConfiguration protocolConfig, HawkularWildFlyAgentContext hawkularStorage) {
            DynamicProtocolService.Builder builder = DynamicProtocolService.builder();
            for (MonitorServiceConfiguration.DynamicEndpointConfiguration endpointConfig : protocolConfig.getEndpoints().values()) {
                if (!endpointConfig.isEnabled()) {
                    log.infoManagedServerDisabled(endpointConfig.getName().toString());
                    continue;
                }
                String securityRealm = endpointConfig.getSecurityRealm();
                SSLContext sslContext = null;
                if (securityRealm != null) {
                    InjectedValue<SSLContext> injectedValue = this.sslContexts.get(securityRealm);
                    if (injectedValue == null) {
                        throw new IllegalArgumentException("Unknown security realm: " + securityRealm);
                    }
                    sslContext = (SSLContext)injectedValue.getOptionalValue();
                }
                MonitoredEndpoint<MonitorServiceConfiguration.DynamicEndpointConfiguration> endpoint = MonitoredEndpoint.of(endpointConfig, sslContext);
                ArrayList<Name> metrics = new ArrayList<Name>();
                for (Name metricSetName : endpointConfig.getMetricSets()) {
                    NameSet metricSet = protocolConfig.getMetrics().get(metricSetName);
                    if (metricSet == null || !metricSet.isEnabled()) continue;
                    metrics.addAll(metricSet.getNameSet());
                }
                PrometheusDynamicEndpointService endpointService = new PrometheusDynamicEndpointService(this.feedId, endpoint, hawkularStorage, metrics);
                builder.endpointService(endpointService);
                log.debugf("[%s] created", endpointService);
            }
            this.prometheusProtocolService = builder.build();
            return this;
        }
    }
}

