/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.dynamicprotocol.prometheus;

import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.hawkular.agent.monitor.api.HawkularWildFlyAgentContext;
import org.hawkular.agent.monitor.api.MetricDataPayloadBuilder;
import org.hawkular.agent.monitor.api.MetricStorage;
import org.hawkular.agent.monitor.dynamicprotocol.DynamicEndpointService;
import org.hawkular.agent.monitor.dynamicprotocol.prometheus.HawkularPrometheusScraper;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.inventory.Name;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.prometheus.types.Counter;
import org.hawkular.agent.prometheus.types.Gauge;
import org.hawkular.agent.prometheus.types.Histogram;
import org.hawkular.agent.prometheus.types.Metric;
import org.hawkular.agent.prometheus.types.MetricFamily;
import org.hawkular.agent.prometheus.types.Summary;
import org.hawkular.agent.prometheus.walkers.PrometheusMetricsWalker;
import org.hawkular.metrics.client.common.MetricType;

public class PrometheusDynamicEndpointService
extends DynamicEndpointService {
    private static final MsgLogger log = AgentLoggers.getLogger(PrometheusDynamicEndpointService.class);
    private final Set<String> metricExactNames;
    private final Set<Pattern> metricRegexNames;
    private final String tenantId;

    public PrometheusDynamicEndpointService(String feedId, MonitoredEndpoint<MonitorServiceConfiguration.DynamicEndpointConfiguration> endpoint, HawkularWildFlyAgentContext hawkularStorage, Collection<Name> metrics) {
        super(feedId, endpoint, hawkularStorage, metrics);
        this.tenantId = endpoint.getEndpointConfiguration().getTenantId();
        if (metrics.isEmpty()) {
            this.metricExactNames = null;
            this.metricRegexNames = null;
        } else {
            this.metricExactNames = new HashSet<String>();
            this.metricRegexNames = new HashSet<Pattern>();
            for (Name name : metrics) {
                String nameString = name.getNameString();
                if (nameString.matches("[a-zA-Z_:][a-zA-Z0-9_:]*")) {
                    this.metricExactNames.add(nameString);
                    continue;
                }
                this.metricRegexNames.add(Pattern.compile(nameString));
            }
        }
    }

    @Override
    public void run() {
        HawkularPrometheusScraper scraper;
        MonitorServiceConfiguration.DynamicEndpointConfiguration endpointConfig = this.getMonitoredEndpoint().getEndpointConfiguration();
        log.tracef("Prometheus job starting: %s", endpointConfig);
        try {
            scraper = new HawkularPrometheusScraper(endpointConfig, this.getMonitoredEndpoint().getSSLContext());
        }
        catch (MalformedURLException e) {
            log.errorf(e, "Error with Prometheus endpoint [%s], stopping this endpoint service", endpointConfig);
            throw new RuntimeException(e);
        }
        try {
            scraper.scrape(new Walker());
        }
        catch (Throwable t) {
            log.errorf(t, "Failed to scrape data from Prometheus endpoint [%s]", endpointConfig);
        }
    }

    class Walker
    implements PrometheusMetricsWalker {
        private MetricStorage metricStorage;
        private MetricDataPayloadBuilder payloadBuilder;

        public void walkStart() {
            HawkularWildFlyAgentContext storage = PrometheusDynamicEndpointService.this.getHawkularStorage();
            this.metricStorage = storage.getMetricStorage();
            this.payloadBuilder = this.metricStorage.createMetricDataPayloadBuilder();
            this.payloadBuilder.setTenantId(PrometheusDynamicEndpointService.this.tenantId);
        }

        public void walkFinish(int familiesProcessed, int metricsProcessed) {
            log.debugf("Storing [%d] of [%d] Prometheus metrics from endpoint [%s]", this.payloadBuilder.getNumberDataPoints(), metricsProcessed, PrometheusDynamicEndpointService.this.getMonitoredEndpoint());
            this.metricStorage.store(this.payloadBuilder, 0L);
        }

        public void walkMetricFamily(MetricFamily family, int index) {
            if (this.shouldMetricBeIgnored(family.getName())) {
                return;
            }
            log.debugf("Processing Prometheus Metric Family [%d]: [%s] (%s) (%d total metrics)", new Object[]{index + 1, family.getName(), family.getType(), family.getMetrics().size()});
        }

        public void walkCounterMetric(MetricFamily family, Counter metric, int index) {
            if (this.shouldMetricBeIgnored(metric.getName())) {
                return;
            }
            log.debugf("Processing Prometheus Counter Metric [%s|%s]: value=%f", family.getName(), this.buildLabelListString(metric.getLabels(), null, null), metric.getValue());
            String key = this.generateKey((Metric)metric);
            log.debugf("Will store counter in Hawkular Metrics with key: %s", key);
            this.payloadBuilder.addDataPoint(key, System.currentTimeMillis(), metric.getValue(), MetricType.COUNTER);
        }

        public void walkGaugeMetric(MetricFamily family, Gauge metric, int index) {
            if (this.shouldMetricBeIgnored(metric.getName())) {
                return;
            }
            log.debugf("Processing Prometheus Gauge Metric [%s|%s]: value=%f", family.getName(), this.buildLabelListString(metric.getLabels(), null, null), metric.getValue());
            String key = this.generateKey((Metric)metric);
            log.debugf("Will store gauge in Hawkular Metrics with key: %s", key);
            this.payloadBuilder.addDataPoint(key, System.currentTimeMillis(), metric.getValue(), MetricType.GAUGE);
        }

        public void walkSummaryMetric(MetricFamily family, Summary metric, int index) {
            if (this.shouldMetricBeIgnored(metric.getName())) {
                return;
            }
            log.debugf("Prometheus SUMMARY metrics not yet supported - skipping [%s|%s|%s]", family.getName(), this.buildLabelListString(metric.getLabels(), null, null), metric.getQuantiles());
        }

        public void walkHistogramMetric(MetricFamily family, Histogram metric, int index) {
            if (this.shouldMetricBeIgnored(metric.getName())) {
                return;
            }
            log.debugf("Prometheus HISTOGRAM metrics not yet supported - skipping [%s|%s|%s]", family.getName(), this.buildLabelListString(metric.getLabels(), null, null), metric.getBuckets());
        }

        private boolean shouldMetricBeIgnored(String metricName) {
            if (PrometheusDynamicEndpointService.this.metricExactNames == null) {
                return false;
            }
            if (PrometheusDynamicEndpointService.this.metricExactNames.contains(metricName)) {
                return false;
            }
            for (Pattern pattern : PrometheusDynamicEndpointService.this.metricRegexNames) {
                if (!pattern.matcher(metricName).matches()) continue;
                return false;
            }
            return true;
        }

        private String generateKey(Metric metric) {
            StringBuilder key = new StringBuilder();
            key.append(PrometheusDynamicEndpointService.this.getFeedId()).append("_");
            if (!PrometheusDynamicEndpointService.this.getMonitoredEndpoint().getEndpointConfiguration().getLabels().isEmpty()) {
                key.append(PrometheusDynamicEndpointService.this.getMonitoredEndpoint().getEndpointConfiguration().getLabels().toString()).append("_");
            }
            key.append(metric.getName()).append("_");
            if (!metric.getLabels().isEmpty()) {
                key.append(this.buildLabelListString(metric.getLabels(), null, null)).append("_");
            }
            return key.toString();
        }
    }
}

