/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.extension;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.hawkular.agent.monitor.api.Avail;
import org.hawkular.agent.monitor.extension.DMRAvailAttributes;
import org.hawkular.agent.monitor.extension.DMRAvailSetAttributes;
import org.hawkular.agent.monitor.extension.DMRMetricAttributes;
import org.hawkular.agent.monitor.extension.DMRMetricSetAttributes;
import org.hawkular.agent.monitor.extension.DMROperationAttributes;
import org.hawkular.agent.monitor.extension.DMRResourceConfigAttributes;
import org.hawkular.agent.monitor.extension.DMRResourceTypeAttributes;
import org.hawkular.agent.monitor.extension.DMRResourceTypeSetAttributes;
import org.hawkular.agent.monitor.extension.DiagnosticsAttributes;
import org.hawkular.agent.monitor.extension.FileStoresAttributes;
import org.hawkular.agent.monitor.extension.JMXAvailAttributes;
import org.hawkular.agent.monitor.extension.JMXAvailSetAttributes;
import org.hawkular.agent.monitor.extension.JMXMetricAttributes;
import org.hawkular.agent.monitor.extension.JMXMetricSetAttributes;
import org.hawkular.agent.monitor.extension.JMXOperationAttributes;
import org.hawkular.agent.monitor.extension.JMXResourceConfigAttributes;
import org.hawkular.agent.monitor.extension.JMXResourceTypeAttributes;
import org.hawkular.agent.monitor.extension.JMXResourceTypeSetAttributes;
import org.hawkular.agent.monitor.extension.LocalDMRAttributes;
import org.hawkular.agent.monitor.extension.MemoryAttributes;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.extension.PlatformAttributes;
import org.hawkular.agent.monitor.extension.PowerSourcesAttributes;
import org.hawkular.agent.monitor.extension.ProcessorsAttributes;
import org.hawkular.agent.monitor.extension.PrometheusMetricSetAttributes;
import org.hawkular.agent.monitor.extension.RemoteDMRAttributes;
import org.hawkular.agent.monitor.extension.RemoteJMXAttributes;
import org.hawkular.agent.monitor.extension.RemotePrometheusAttributes;
import org.hawkular.agent.monitor.extension.StorageAttributes;
import org.hawkular.agent.monitor.extension.SubsystemAttributes;
import org.hawkular.agent.monitor.inventory.AttributeLocation;
import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.inventory.ConnectionData;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.Interval;
import org.hawkular.agent.monitor.inventory.MetricType;
import org.hawkular.agent.monitor.inventory.Name;
import org.hawkular.agent.monitor.inventory.NameSet;
import org.hawkular.agent.monitor.inventory.NodeLocationProvider;
import org.hawkular.agent.monitor.inventory.Operation;
import org.hawkular.agent.monitor.inventory.ResourceConfigurationPropertyType;
import org.hawkular.agent.monitor.inventory.ResourceType;
import org.hawkular.agent.monitor.inventory.TypeSet;
import org.hawkular.agent.monitor.inventory.TypeSets;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.hawkular.agent.monitor.protocol.jmx.JMXNodeLocation;
import org.hawkular.agent.monitor.protocol.platform.Constants;
import org.hawkular.agent.monitor.protocol.platform.PlatformNodeLocation;
import org.hawkular.agent.monitor.protocol.platform.PlatformPath;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class MonitorServiceConfigurationBuilder {
    private static final MsgLogger log = AgentLoggers.getLogger(MonitorServiceConfigurationBuilder.class);
    private MonitorServiceConfiguration.ProtocolConfiguration.Builder<DMRNodeLocation> dmrConfigBuilder;
    private MonitorServiceConfiguration.ProtocolConfiguration.Builder<JMXNodeLocation> jmxConfigBuilder;
    private MonitorServiceConfiguration.ProtocolConfiguration.Builder<PlatformNodeLocation> platformConfigBuilder;
    private MonitorServiceConfiguration.DynamicProtocolConfiguration.Builder prometheusConfigBuilder;
    private MonitorServiceConfiguration.DiagnosticsConfiguration diagnostics;
    private MonitorServiceConfiguration.StorageAdapterConfiguration storageAdapter;
    private MonitorServiceConfiguration.GlobalConfiguration globalConfiguration;

    public MonitorServiceConfigurationBuilder(ModelNode config, OperationContext context) throws OperationFailedException {
        this.globalConfiguration = MonitorServiceConfigurationBuilder.determineGlobalConfig(config, context);
        this.storageAdapter = MonitorServiceConfigurationBuilder.determineStorageAdapterConfig(config, context);
        this.diagnostics = MonitorServiceConfigurationBuilder.determineDiagnosticsConfig(config, context);
        this.dmrConfigBuilder = MonitorServiceConfiguration.ProtocolConfiguration.builder();
        this.jmxConfigBuilder = MonitorServiceConfiguration.ProtocolConfiguration.builder();
        this.platformConfigBuilder = MonitorServiceConfiguration.ProtocolConfiguration.builder();
        this.prometheusConfigBuilder = MonitorServiceConfiguration.DynamicProtocolConfiguration.builder();
        TypeSets.Builder<DMRNodeLocation> dmrTypeSetsBuilder = TypeSets.builder();
        TypeSets.Builder<JMXNodeLocation> jmxTypeSetsBuilder = TypeSets.builder();
        HashMap<Name, NameSet> prometheusMetricSets = new HashMap<Name, NameSet>();
        MonitorServiceConfigurationBuilder.determineMetricSetDmr(config, context, dmrTypeSetsBuilder);
        MonitorServiceConfigurationBuilder.determineAvailSetDmr(config, context, dmrTypeSetsBuilder);
        MonitorServiceConfigurationBuilder.determineMetricSetJmx(config, context, jmxTypeSetsBuilder);
        MonitorServiceConfigurationBuilder.determineAvailSetJmx(config, context, jmxTypeSetsBuilder);
        MonitorServiceConfigurationBuilder.determineMetricSetPrometheus(config, context, prometheusMetricSets);
        MonitorServiceConfigurationBuilder.determineResourceTypeSetDmr(config, context, dmrTypeSetsBuilder);
        MonitorServiceConfigurationBuilder.determineResourceTypeSetJmx(config, context, jmxTypeSetsBuilder);
        this.dmrConfigBuilder.typeSets(dmrTypeSetsBuilder.build());
        this.jmxConfigBuilder.typeSets(jmxTypeSetsBuilder.build());
        this.prometheusConfigBuilder.metricSets(prometheusMetricSets);
        TypeSets<PlatformNodeLocation> platformTypeSets = MonitorServiceConfigurationBuilder.buildPlatformTypeSets(config, context);
        this.platformConfigBuilder.typeSets(platformTypeSets);
        if (!platformTypeSets.isDisabledOrEmpty()) {
            MonitorServiceConfiguration.EndpointConfiguration endpoint = new MonitorServiceConfiguration.EndpointConfiguration("platform", true, null, null, null, Avail.DOWN, null);
            this.platformConfigBuilder.endpoint(endpoint);
        }
        this.determineManagedServers(config, context);
    }

    public MonitorServiceConfiguration build() {
        return new MonitorServiceConfiguration(this.globalConfiguration, this.diagnostics, this.storageAdapter, this.dmrConfigBuilder.build(), this.jmxConfigBuilder.build(), this.platformConfigBuilder.build(), this.prometheusConfigBuilder.build());
    }

    private static void determineMetricSetDmr(ModelNode config, OperationContext context, TypeSets.Builder<DMRNodeLocation> typeSetsBuilder) throws OperationFailedException {
        boolean enabled = false;
        if (config.hasDefined("metric-set-dmr")) {
            List metricSetsList = config.get("metric-set-dmr").asPropertyList();
            for (Property metricSetProperty : metricSetsList) {
                String metricSetName = metricSetProperty.getName();
                if (metricSetName.indexOf(44) > -1) {
                    log.warnCommaInName(metricSetName);
                }
                ModelNode metricSetValueNode = metricSetProperty.getValue();
                TypeSet.TypeSetBuilder<MetricType<DMRNodeLocation>> typeSetBuilder = TypeSet.builder().name(new Name(metricSetName)).enabled(MonitorServiceConfigurationBuilder.getBoolean(metricSetValueNode, context, DMRMetricSetAttributes.ENABLED));
                if (metricSetValueNode.hasDefined("metric-dmr")) {
                    List metricsList = metricSetValueNode.get("metric-dmr").asPropertyList();
                    for (Property metricProperty : metricsList) {
                        String metricName = metricSetName + "~" + metricProperty.getName();
                        ModelNode metricValueNode = metricProperty.getValue();
                        AttributeLocation<DMRNodeLocation> location = new AttributeLocation<DMRNodeLocation>(new DMRNodeLocation(MonitorServiceConfigurationBuilder.getPath(metricValueNode, context, DMRMetricAttributes.PATH)), MonitorServiceConfigurationBuilder.getString(metricValueNode, context, DMRMetricAttributes.ATTRIBUTE));
                        MetricType<DMRNodeLocation> metric = new MetricType<DMRNodeLocation>(ID.NULL_ID, new Name(metricName), location, new Interval(MonitorServiceConfigurationBuilder.getInt(metricValueNode, context, DMRMetricAttributes.INTERVAL), MonitorServiceConfigurationBuilder.getTimeUnit(metricValueNode, context, DMRMetricAttributes.TIME_UNITS)), MonitorServiceConfigurationBuilder.getMeasurementUnit(metricValueNode, context, DMRMetricAttributes.METRIC_UNITS), MonitorServiceConfigurationBuilder.getMetricType(metricValueNode, context, DMRMetricAttributes.METRIC_TYPE));
                        typeSetBuilder.type(metric);
                    }
                }
                TypeSet typeSet = typeSetBuilder.build();
                enabled = enabled || !typeSet.isDisabledOrEmpty();
                typeSetsBuilder.metricTypeSet(typeSet);
            }
        }
        if (!enabled) {
            log.infoNoEnabledMetricsConfigured("DMR");
        }
    }

    private static org.hawkular.metrics.client.common.MetricType getMetricType(ModelNode metricValueNode, OperationContext context, SimpleAttributeDefinition metricType) throws OperationFailedException {
        String metricTypeStr = MonitorServiceConfigurationBuilder.getString(metricValueNode, context, metricType);
        if (metricTypeStr == null) {
            return org.hawkular.metrics.client.common.MetricType.GAUGE;
        }
        return org.hawkular.metrics.client.common.MetricType.valueOf((String)metricTypeStr.toUpperCase(Locale.ENGLISH));
    }

    private static MeasurementUnit getMeasurementUnit(ModelNode metricValueNode, OperationContext context, SimpleAttributeDefinition metricUnits) throws OperationFailedException {
        String metricUnitsStr = MonitorServiceConfigurationBuilder.getString(metricValueNode, context, metricUnits);
        if (metricUnitsStr == null) {
            return MeasurementUnit.NONE;
        }
        return MeasurementUnit.valueOf((String)metricUnitsStr.toUpperCase(Locale.ENGLISH));
    }

    private static TimeUnit getTimeUnit(ModelNode metricValueNode, OperationContext context, SimpleAttributeDefinition timeUnits) throws OperationFailedException {
        String metricTimeUnitsStr = MonitorServiceConfigurationBuilder.getString(metricValueNode, context, timeUnits);
        return TimeUnit.valueOf(metricTimeUnitsStr.toUpperCase());
    }

    private static void determineAvailSetDmr(ModelNode config, OperationContext context, TypeSets.Builder<DMRNodeLocation> typeSetsBuilder) throws OperationFailedException {
        boolean enabled = false;
        if (config.hasDefined("avail-set-dmr")) {
            List availSetsList = config.get("avail-set-dmr").asPropertyList();
            for (Property availSetProperty : availSetsList) {
                String availSetName = availSetProperty.getName();
                if (availSetName.indexOf(44) > -1) {
                    log.warnCommaInName(availSetName);
                }
                ModelNode availSetValueNode = availSetProperty.getValue();
                TypeSet.TypeSetBuilder<AvailType<DMRNodeLocation>> typeSetBuilder = TypeSet.builder().name(new Name(availSetName)).enabled(MonitorServiceConfigurationBuilder.getBoolean(availSetValueNode, context, DMRAvailSetAttributes.ENABLED));
                if (!availSetValueNode.hasDefined("avail-dmr")) continue;
                List availsList = availSetValueNode.get("avail-dmr").asPropertyList();
                for (Property availProperty : availsList) {
                    String availName = availSetName + "~" + availProperty.getName();
                    ModelNode availValueNode = availProperty.getValue();
                    AttributeLocation<DMRNodeLocation> location = new AttributeLocation<DMRNodeLocation>(new DMRNodeLocation(MonitorServiceConfigurationBuilder.getPath(availValueNode, context, DMRAvailAttributes.PATH)), MonitorServiceConfigurationBuilder.getString(availValueNode, context, DMRAvailAttributes.ATTRIBUTE));
                    AvailType<DMRNodeLocation> avail = new AvailType<DMRNodeLocation>(ID.NULL_ID, new Name(availName), location, new Interval(MonitorServiceConfigurationBuilder.getInt(availValueNode, context, DMRAvailAttributes.INTERVAL), MonitorServiceConfigurationBuilder.getTimeUnit(availValueNode, context, DMRAvailAttributes.TIME_UNITS)), Pattern.compile(MonitorServiceConfigurationBuilder.getString(availValueNode, context, DMRAvailAttributes.UP_REGEX)));
                    typeSetBuilder.type(avail);
                }
                TypeSet typeSet = typeSetBuilder.build();
                enabled = enabled || !typeSet.isDisabledOrEmpty();
                typeSetsBuilder.availTypeSet(typeSet);
            }
        }
        if (!enabled) {
            log.infoNoEnabledAvailsConfigured("DMR");
        }
    }

    private static void determineMetricSetJmx(ModelNode config, OperationContext context, TypeSets.Builder<JMXNodeLocation> typeSetsBuilder) throws OperationFailedException {
        boolean enabled = false;
        if (config.hasDefined("metric-set-jmx")) {
            List metricSetsList = config.get("metric-set-jmx").asPropertyList();
            for (Property metricSetProperty : metricSetsList) {
                String metricSetName = metricSetProperty.getName();
                if (metricSetName.indexOf(44) > -1) {
                    log.warnCommaInName(metricSetName);
                }
                ModelNode metricSetValueNode = metricSetProperty.getValue();
                TypeSet.TypeSetBuilder<MetricType<JMXNodeLocation>> typeSetBuilder = TypeSet.builder().name(new Name(metricSetName)).enabled(MonitorServiceConfigurationBuilder.getBoolean(metricSetValueNode, context, JMXMetricSetAttributes.ENABLED));
                if (!metricSetValueNode.hasDefined("metric-jmx")) continue;
                List metricsList = metricSetValueNode.get("metric-jmx").asPropertyList();
                for (Property metricProperty : metricsList) {
                    String metricName = metricSetName + "~" + metricProperty.getName();
                    ModelNode metricValueNode = metricProperty.getValue();
                    String objectName = MonitorServiceConfigurationBuilder.getString(metricValueNode, context, JMXMetricAttributes.OBJECT_NAME);
                    try {
                        AttributeLocation<JMXNodeLocation> location = new AttributeLocation<JMXNodeLocation>(new JMXNodeLocation(objectName), MonitorServiceConfigurationBuilder.getString(metricValueNode, context, JMXMetricAttributes.ATTRIBUTE));
                        MetricType<JMXNodeLocation> metric = new MetricType<JMXNodeLocation>(ID.NULL_ID, new Name(metricName), location, new Interval(MonitorServiceConfigurationBuilder.getInt(metricValueNode, context, JMXMetricAttributes.INTERVAL), MonitorServiceConfigurationBuilder.getTimeUnit(metricValueNode, context, JMXMetricAttributes.TIME_UNITS)), MonitorServiceConfigurationBuilder.getMeasurementUnit(metricValueNode, context, JMXMetricAttributes.METRIC_UNITS), MonitorServiceConfigurationBuilder.getMetricType(metricValueNode, context, JMXMetricAttributes.METRIC_TYPE));
                        typeSetBuilder.type(metric);
                    }
                    catch (MalformedObjectNameException e) {
                        log.warnMalformedJMXObjectName(objectName, e);
                    }
                }
                TypeSet typeSet = typeSetBuilder.build();
                enabled = enabled || !typeSet.isDisabledOrEmpty();
                typeSetsBuilder.metricTypeSet(typeSet);
            }
        }
        if (!enabled) {
            log.infoNoEnabledMetricsConfigured("JMX");
        }
    }

    private static void determineAvailSetJmx(ModelNode config, OperationContext context, TypeSets.Builder<JMXNodeLocation> typeSetsBuilder) throws OperationFailedException {
        boolean enabled = false;
        if (config.hasDefined("avail-set-jmx")) {
            List availSetsList = config.get("avail-set-jmx").asPropertyList();
            for (Property availSetProperty : availSetsList) {
                String availSetName = availSetProperty.getName();
                if (availSetName.indexOf(44) > -1) {
                    log.warnCommaInName(availSetName);
                }
                ModelNode availSetValueNode = availSetProperty.getValue();
                TypeSet.TypeSetBuilder<AvailType<JMXNodeLocation>> typeSetBuilder = TypeSet.builder().name(new Name(availSetName)).enabled(MonitorServiceConfigurationBuilder.getBoolean(availSetValueNode, context, JMXAvailSetAttributes.ENABLED));
                if (!availSetValueNode.hasDefined("avail-jmx")) continue;
                List availsList = availSetValueNode.get("avail-jmx").asPropertyList();
                for (Property availProperty : availsList) {
                    String availName = availSetName + "~" + availProperty.getName();
                    ModelNode availValueNode = availProperty.getValue();
                    String objectName = MonitorServiceConfigurationBuilder.getString(availValueNode, context, JMXAvailAttributes.OBJECT_NAME);
                    try {
                        AttributeLocation<JMXNodeLocation> location = new AttributeLocation<JMXNodeLocation>(new JMXNodeLocation(objectName), MonitorServiceConfigurationBuilder.getString(availValueNode, context, JMXAvailAttributes.ATTRIBUTE));
                        AvailType<JMXNodeLocation> avail = new AvailType<JMXNodeLocation>(ID.NULL_ID, new Name(availName), location, new Interval(MonitorServiceConfigurationBuilder.getInt(availValueNode, context, JMXAvailAttributes.INTERVAL), MonitorServiceConfigurationBuilder.getTimeUnit(availValueNode, context, JMXAvailAttributes.TIME_UNITS)), Pattern.compile(MonitorServiceConfigurationBuilder.getString(availValueNode, context, JMXAvailAttributes.UP_REGEX)));
                        typeSetBuilder.type(avail);
                    }
                    catch (MalformedObjectNameException e) {
                        log.warnMalformedJMXObjectName(objectName, e);
                    }
                }
                TypeSet typeSet = typeSetBuilder.build();
                enabled = enabled || !typeSet.isDisabledOrEmpty();
                typeSetsBuilder.availTypeSet(typeSet);
            }
        }
        if (!enabled) {
            log.infoNoEnabledAvailsConfigured("JMX");
        }
    }

    private static void determineMetricSetPrometheus(ModelNode config, OperationContext context, Map<Name, NameSet> namedMetricSets) throws OperationFailedException {
        boolean enabled = false;
        if (config.hasDefined("metric-set-prometheus")) {
            List metricSetsList = config.get("metric-set-prometheus").asPropertyList();
            for (Property metricSetProperty : metricSetsList) {
                NameSet.NameSetBuilder nameSetBuilder = NameSet.builder();
                String metricSetName = metricSetProperty.getName();
                if (metricSetName.indexOf(44) > -1) {
                    log.warnCommaInName(metricSetName);
                }
                nameSetBuilder.nameOfSet(new Name(metricSetName));
                ModelNode metricSetValueNode = metricSetProperty.getValue();
                enabled = MonitorServiceConfigurationBuilder.getBoolean(metricSetValueNode, context, PrometheusMetricSetAttributes.ENABLED);
                nameSetBuilder.enabled(enabled);
                if (!metricSetValueNode.hasDefined("metric-prometheus")) continue;
                List metricsList = metricSetValueNode.get("metric-prometheus").asPropertyList();
                for (Property metricProperty : metricsList) {
                    String metricName = metricProperty.getName();
                    try {
                        Pattern.compile(metricName);
                        nameSetBuilder.name(new Name(metricName));
                    }
                    catch (Exception e) {
                        throw new OperationFailedException("Metric name is an invalid regex: " + metricName);
                    }
                }
                NameSet nameSet = nameSetBuilder.build();
                namedMetricSets.put(nameSet.getName(), nameSet);
                enabled = enabled || !nameSet.isDisabledOrEmpty();
            }
        }
        if (!enabled) {
            log.infoNoEnabledMetricsConfigured("Prometheus");
        }
    }

    private static TypeSets<PlatformNodeLocation> buildPlatformTypeSets(ModelNode config, OperationContext context) throws OperationFailedException {
        TypeSet typeSet;
        Interval interval;
        boolean enabled;
        if (!config.hasDefined("platform")) {
            log.infoNoPlatformConfig();
            return TypeSets.empty();
        }
        List asPropertyList = config.get("platform").asPropertyList();
        if (asPropertyList.size() == 0) {
            log.infoNoPlatformConfig();
            return TypeSets.empty();
        }
        if (asPropertyList.size() > 1) {
            throw new IllegalArgumentException("Only one platform config allowed: " + config.toJSONString(true));
        }
        ModelNode platformValueNode = ((Property)asPropertyList.get(0)).getValue();
        boolean typeSetsEnabled = MonitorServiceConfigurationBuilder.getBoolean(platformValueNode, context, PlatformAttributes.ENABLED);
        if (!typeSetsEnabled) {
            log.debugf("Platform monitoring is disabled", new Object[0]);
            return TypeSets.empty();
        }
        TypeSets.Builder typeSetsBuilder = TypeSets.builder();
        Name osName = Constants.PlatformResourceType.OPERATING_SYSTEM.getName();
        Object rootTypeBldr = ((ResourceType.Builder)((ResourceType.Builder)ResourceType.builder().name(osName)).location(new PlatformNodeLocation(PlatformPath.builder().any(Constants.PlatformResourceType.OPERATING_SYSTEM).build()))).resourceNameTemplate("%s");
        MonitorServiceConfigurationBuilder.populateMetricAndAvailTypesForResourceType(rootTypeBldr, typeSetsBuilder);
        ResourceType rootType = ((ResourceType.Builder)rootTypeBldr).build();
        TypeSet rootTypeSet = TypeSet.builder().enabled(true).name(osName).type(rootType).build();
        typeSetsBuilder.resourceTypeSet(rootTypeSet);
        if (platformValueNode.hasDefined("file-stores")) {
            asPropertyList = platformValueNode.get("file-stores").asPropertyList();
            if (asPropertyList.size() == 1) {
                ModelNode fileStoresNode = ((Property)asPropertyList.get(0)).getValue();
                enabled = MonitorServiceConfigurationBuilder.getBoolean(fileStoresNode, context, FileStoresAttributes.ENABLED);
                if (enabled) {
                    interval = new Interval(MonitorServiceConfigurationBuilder.getInt(fileStoresNode, context, FileStoresAttributes.INTERVAL), TimeUnit.valueOf(MonitorServiceConfigurationBuilder.getString(fileStoresNode, context, FileStoresAttributes.TIME_UNITS).toUpperCase()));
                    MetricType<PlatformNodeLocation> usableSpace = new MetricType<PlatformNodeLocation>(null, Constants.FILE_STORE_USABLE_SPACE, new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), Constants.FILE_STORE_USABLE_SPACE.getNameString()), interval, MeasurementUnit.BYTES, org.hawkular.metrics.client.common.MetricType.GAUGE);
                    MetricType<PlatformNodeLocation> totalSpace = new MetricType<PlatformNodeLocation>(null, Constants.FILE_STORE_TOTAL_SPACE, new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), Constants.FILE_STORE_TOTAL_SPACE.getNameString()), interval, MeasurementUnit.BYTES, org.hawkular.metrics.client.common.MetricType.GAUGE);
                    TypeSet fileStoreMetrics = TypeSet.builder().name(Constants.PlatformResourceType.FILE_STORE.getName()).type(usableSpace).type(totalSpace).build();
                    typeSetsBuilder.metricTypeSet(fileStoreMetrics);
                    PlatformNodeLocation fileStoreLocation = new PlatformNodeLocation(PlatformPath.builder().any(Constants.PlatformResourceType.FILE_STORE).build());
                    Object fileStoreBldr = ((ResourceType.Builder)((ResourceType.Builder)((ResourceType.Builder)((ResourceType.Builder)ResourceType.builder().name(Constants.PlatformResourceType.FILE_STORE.getName())).location(fileStoreLocation)).resourceNameTemplate(Constants.PlatformResourceType.FILE_STORE.getName().getNameString() + " [%s]")).parent(rootType.getName())).metricSetName(fileStoreMetrics.getName());
                    MonitorServiceConfigurationBuilder.populateMetricAndAvailTypesForResourceType(fileStoreBldr, typeSetsBuilder);
                    ResourceType fileStore = ((ResourceType.Builder)fileStoreBldr).build();
                    typeSet = TypeSet.builder().name(Constants.PlatformResourceType.FILE_STORE.getName()).type(fileStore).build();
                    typeSetsBuilder.resourceTypeSet(typeSet);
                }
            } else if (asPropertyList.size() > 1) {
                throw new IllegalArgumentException("Only one platform.file-stores config allowed: " + platformValueNode.toJSONString(true));
            }
        }
        if (platformValueNode.hasDefined("memory")) {
            asPropertyList = platformValueNode.get("memory").asPropertyList();
            if (asPropertyList.size() == 1) {
                ModelNode memoryNode = ((Property)asPropertyList.get(0)).getValue();
                enabled = MonitorServiceConfigurationBuilder.getBoolean(memoryNode, context, MemoryAttributes.ENABLED);
                if (enabled) {
                    interval = new Interval(MonitorServiceConfigurationBuilder.getInt(memoryNode, context, MemoryAttributes.INTERVAL), TimeUnit.valueOf(MonitorServiceConfigurationBuilder.getString(memoryNode, context, MemoryAttributes.TIME_UNITS).toUpperCase()));
                    MetricType<PlatformNodeLocation> available = new MetricType<PlatformNodeLocation>(null, Constants.MEMORY_AVAILABLE, new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), Constants.MEMORY_AVAILABLE.getNameString()), interval, MeasurementUnit.BYTES, org.hawkular.metrics.client.common.MetricType.GAUGE);
                    MetricType<PlatformNodeLocation> total = new MetricType<PlatformNodeLocation>(null, Constants.MEMORY_TOTAL, new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), Constants.MEMORY_TOTAL.getNameString()), interval, MeasurementUnit.BYTES, org.hawkular.metrics.client.common.MetricType.GAUGE);
                    TypeSet memoryMetrics = TypeSet.builder().name(Constants.PlatformResourceType.MEMORY.getName()).type(available).type(total).build();
                    typeSetsBuilder.metricTypeSet(memoryMetrics);
                    PlatformNodeLocation memoryLocation = new PlatformNodeLocation(PlatformPath.builder().any(Constants.PlatformResourceType.MEMORY).build());
                    Object memoryBldr = ((ResourceType.Builder)((ResourceType.Builder)((NodeLocationProvider.Builder)((ResourceType.Builder)ResourceType.builder().name(Constants.PlatformResourceType.MEMORY.getName())).parent(rootType.getName())).location((PlatformNodeLocation)memoryLocation)).metricSetName(memoryMetrics.getName())).resourceNameTemplate(Constants.PlatformResourceType.MEMORY.getName().getNameString());
                    MonitorServiceConfigurationBuilder.populateMetricAndAvailTypesForResourceType(memoryBldr, typeSetsBuilder);
                    ResourceType memory = ((ResourceType.Builder)memoryBldr).build();
                    typeSet = TypeSet.builder().name(Constants.PlatformResourceType.MEMORY.getName()).type(memory).build();
                    typeSetsBuilder.resourceTypeSet(typeSet);
                }
            } else if (asPropertyList.size() > 1) {
                throw new IllegalArgumentException("Only one platform.memory config allowed: " + platformValueNode.toJSONString(true));
            }
        }
        if (platformValueNode.hasDefined("processors")) {
            asPropertyList = platformValueNode.get("processors").asPropertyList();
            if (asPropertyList.size() == 1) {
                ModelNode processorsNode = ((Property)asPropertyList.get(0)).getValue();
                enabled = MonitorServiceConfigurationBuilder.getBoolean(processorsNode, context, ProcessorsAttributes.ENABLED);
                if (enabled) {
                    interval = new Interval(MonitorServiceConfigurationBuilder.getInt(processorsNode, context, ProcessorsAttributes.INTERVAL), TimeUnit.valueOf(MonitorServiceConfigurationBuilder.getString(processorsNode, context, ProcessorsAttributes.TIME_UNITS).toUpperCase()));
                    MetricType<PlatformNodeLocation> cpuUsage = new MetricType<PlatformNodeLocation>(null, Constants.PROCESSOR_CPU_USAGE, new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), Constants.PROCESSOR_CPU_USAGE.getNameString()), interval, MeasurementUnit.PERCENTAGE, org.hawkular.metrics.client.common.MetricType.GAUGE);
                    TypeSet processorMetrics = TypeSet.builder().name(Constants.PlatformResourceType.PROCESSOR.getName()).type(cpuUsage).build();
                    typeSetsBuilder.metricTypeSet(processorMetrics);
                    PlatformNodeLocation processorsLocation = new PlatformNodeLocation(PlatformPath.builder().any(Constants.PlatformResourceType.PROCESSOR).build());
                    Object processorBldr = ((ResourceType.Builder)((ResourceType.Builder)((NodeLocationProvider.Builder)((ResourceType.Builder)ResourceType.builder().name(Constants.PlatformResourceType.PROCESSOR.getName())).parent(rootType.getName())).location((PlatformNodeLocation)processorsLocation)).metricSetName(processorMetrics.getName())).resourceNameTemplate(Constants.PlatformResourceType.PROCESSOR.getName().getNameString() + " [%s]");
                    MonitorServiceConfigurationBuilder.populateMetricAndAvailTypesForResourceType(processorBldr, typeSetsBuilder);
                    ResourceType processor = ((ResourceType.Builder)processorBldr).build();
                    TypeSet typeSet2 = TypeSet.builder().name(Constants.PlatformResourceType.PROCESSOR.getName()).type(processor).build();
                    typeSetsBuilder.resourceTypeSet(typeSet2);
                }
            } else if (asPropertyList.size() > 1) {
                throw new IllegalArgumentException("Only one platform.processors config allowed: " + platformValueNode.toJSONString(true));
            }
        }
        if (platformValueNode.hasDefined("power-sources")) {
            asPropertyList = platformValueNode.get("power-sources").asPropertyList();
            if (asPropertyList.size() == 1) {
                ModelNode powerSourcesNode = ((Property)asPropertyList.get(0)).getValue();
                enabled = MonitorServiceConfigurationBuilder.getBoolean(powerSourcesNode, context, PowerSourcesAttributes.ENABLED);
                if (enabled) {
                    interval = new Interval(MonitorServiceConfigurationBuilder.getInt(powerSourcesNode, context, PowerSourcesAttributes.INTERVAL), TimeUnit.valueOf(MonitorServiceConfigurationBuilder.getString(powerSourcesNode, context, PowerSourcesAttributes.TIME_UNITS).toUpperCase()));
                    MetricType<PlatformNodeLocation> remainingCap = new MetricType<PlatformNodeLocation>(null, Constants.POWER_SOURCE_REMAINING_CAPACITY, new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), Constants.POWER_SOURCE_REMAINING_CAPACITY.getNameString()), interval, MeasurementUnit.PERCENTAGE, org.hawkular.metrics.client.common.MetricType.GAUGE);
                    MetricType<PlatformNodeLocation> timeRemaining = new MetricType<PlatformNodeLocation>(null, Constants.POWER_SOURCE_TIME_REMAINING, new AttributeLocation<PlatformNodeLocation>(new PlatformNodeLocation(PlatformPath.empty()), Constants.POWER_SOURCE_TIME_REMAINING.getNameString()), interval, MeasurementUnit.SECONDS, org.hawkular.metrics.client.common.MetricType.GAUGE);
                    TypeSet powerSourceMetrics = TypeSet.builder().name(Constants.PlatformResourceType.POWER_SOURCE.getName()).type(remainingCap).type(timeRemaining).build();
                    typeSetsBuilder.metricTypeSet(powerSourceMetrics);
                    PlatformNodeLocation powerSourcesLocation = new PlatformNodeLocation(PlatformPath.builder().any(Constants.PlatformResourceType.POWER_SOURCE).build());
                    Object powerSourceBldr = ((ResourceType.Builder)((ResourceType.Builder)((NodeLocationProvider.Builder)((ResourceType.Builder)ResourceType.builder().name(Constants.PlatformResourceType.POWER_SOURCE.getName())).parent(rootType.getName())).location((PlatformNodeLocation)powerSourcesLocation)).metricSetName(powerSourceMetrics.getName())).resourceNameTemplate(Constants.PlatformResourceType.POWER_SOURCE.getName().getNameString() + " [%s]");
                    MonitorServiceConfigurationBuilder.populateMetricAndAvailTypesForResourceType(powerSourceBldr, typeSetsBuilder);
                    ResourceType powerSource = ((ResourceType.Builder)powerSourceBldr).build();
                    typeSet = TypeSet.builder().name(Constants.PlatformResourceType.POWER_SOURCE.getName()).type(powerSource).build();
                    typeSetsBuilder.resourceTypeSet(typeSet);
                }
            } else if (asPropertyList.size() > 1) {
                throw new IllegalArgumentException("Only one platform.power-sources config allowed: " + platformValueNode.toJSONString(true));
            }
        }
        return typeSetsBuilder.build();
    }

    private static MonitorServiceConfiguration.DiagnosticsConfiguration determineDiagnosticsConfig(ModelNode config, OperationContext context) throws OperationFailedException {
        if (!config.hasDefined("diagnostics")) {
            log.infoNoDiagnosticsConfig();
            return MonitorServiceConfiguration.DiagnosticsConfiguration.EMPTY;
        }
        List asPropertyList = config.get("diagnostics").asPropertyList();
        if (asPropertyList.size() == 0) {
            log.infoNoDiagnosticsConfig();
            return MonitorServiceConfiguration.DiagnosticsConfiguration.EMPTY;
        }
        if (asPropertyList.size() > 1) {
            throw new IllegalArgumentException("Only one diagnostics config allowed: " + config.toJSONString(true));
        }
        ModelNode diagnosticsValueNode = ((Property)asPropertyList.get(0)).getValue();
        String reportToStr = MonitorServiceConfigurationBuilder.getString(diagnosticsValueNode, context, DiagnosticsAttributes.REPORT_TO);
        MonitorServiceConfiguration.DiagnosticsReportTo reportTo = MonitorServiceConfiguration.DiagnosticsReportTo.valueOf(reportToStr.toUpperCase());
        boolean enabled = MonitorServiceConfigurationBuilder.getBoolean(diagnosticsValueNode, context, DiagnosticsAttributes.ENABLED);
        int interval = MonitorServiceConfigurationBuilder.getInt(diagnosticsValueNode, context, DiagnosticsAttributes.INTERVAL);
        String diagnosticsTimeUnitsStr = MonitorServiceConfigurationBuilder.getString(diagnosticsValueNode, context, DiagnosticsAttributes.TIME_UNITS);
        TimeUnit timeUnits = TimeUnit.valueOf(diagnosticsTimeUnitsStr.toUpperCase());
        return new MonitorServiceConfiguration.DiagnosticsConfiguration(enabled, reportTo, interval, timeUnits);
    }

    private static MonitorServiceConfiguration.StorageAdapterConfiguration determineStorageAdapterConfig(ModelNode config, OperationContext context) throws OperationFailedException {
        if (!config.hasDefined("storage-adapter")) {
            throw new IllegalArgumentException("Missing storage adapter configuration: " + config.toJSONString(true));
        }
        List asPropertyList = config.get("storage-adapter").asPropertyList();
        if (asPropertyList.size() == 0) {
            throw new IllegalArgumentException("Missing storage adapter configuration: " + config.toJSONString(true));
        }
        if (asPropertyList.size() > 1) {
            throw new IllegalArgumentException("Only one storage adapter allowed: " + config.toJSONString(true));
        }
        ModelNode storageAdapterConfig = ((Property)asPropertyList.get(0)).getValue();
        String url = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.URL);
        boolean useSSL = false;
        if (url != null) {
            useSSL = url.startsWith("https");
            log.infoUsingSSL(url, useSSL);
        } else {
            useSSL = MonitorServiceConfigurationBuilder.getBoolean(storageAdapterConfig, context, StorageAttributes.USE_SSL);
        }
        String securityRealm = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.SECURITY_REALM);
        String keystorePath = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.KEYSTORE_PATH);
        String keystorePassword = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.KEYSTORE_PASSWORD);
        String serverOutboundSocketBindingRef = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.SERVER_OUTBOUND_SOCKET_BINDING_REF);
        String tenantId = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.TENANT_ID);
        String feedId = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.FEED_ID);
        String accountsContext = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.ACCOUNTS_CONTEXT);
        String inventoryContext = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.INVENTORY_CONTEXT);
        String metricsContext = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.METRICS_CONTEXT);
        String feedcommContext = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.FEEDCOMM_CONTEXT);
        String username = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.USERNAME);
        String password = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.PASSWORD);
        String key = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.SECURITY_KEY);
        String secret = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.SECURITY_SECRET);
        String typeStr = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.TYPE);
        MonitorServiceConfiguration.StorageReportTo type = MonitorServiceConfiguration.StorageReportTo.valueOf(typeStr.toUpperCase());
        if (useSSL && securityRealm == null) {
            if (keystorePath == null) {
                throw new IllegalArgumentException("In order to use SSL, a securityRealm or keystorePath must be specified");
            }
            if (keystorePassword == null) {
                throw new IllegalArgumentException("In order to use SSL, a securityRealm or keystorePassword must be specified");
            }
        }
        if (!(username != null && password != null || key != null && secret != null)) {
            throw new IllegalArgumentException("Must have a username/password or security key/secret");
        }
        return new MonitorServiceConfiguration.StorageAdapterConfiguration(type, username, password, key, secret, tenantId, feedId, url, useSSL, serverOutboundSocketBindingRef, accountsContext, inventoryContext, metricsContext, feedcommContext, keystorePath, keystorePassword, securityRealm);
    }

    private static MonitorServiceConfiguration.GlobalConfiguration determineGlobalConfig(ModelNode config, OperationContext context) throws OperationFailedException {
        boolean subsystemEnabled = MonitorServiceConfigurationBuilder.getBoolean(config, context, SubsystemAttributes.ENABLED);
        String apiJndi = MonitorServiceConfigurationBuilder.getString(config, context, SubsystemAttributes.API_JNDI);
        int autoDiscoveryScanPeriodSecs = MonitorServiceConfigurationBuilder.getInt(config, context, SubsystemAttributes.AUTO_DISCOVERY_SCAN_PERIOD_SECS);
        int numDmrSchedulerThreads = MonitorServiceConfigurationBuilder.getInt(config, context, SubsystemAttributes.NUM_DMR_SCHEDULER_THREADS);
        int metricDispatcherBufferSize = MonitorServiceConfigurationBuilder.getInt(config, context, SubsystemAttributes.METRIC_DISPATCHER_BUFFER_SIZE);
        int metricDispatcherMaxBatchSize = MonitorServiceConfigurationBuilder.getInt(config, context, SubsystemAttributes.METRIC_DISPATCHER_MAX_BATCH_SIZE);
        int availDispatcherBufferSize = MonitorServiceConfigurationBuilder.getInt(config, context, SubsystemAttributes.AVAIL_DISPATCHER_BUFFER_SIZE);
        int availDispatcherMaxBatchSize = MonitorServiceConfigurationBuilder.getInt(config, context, SubsystemAttributes.AVAIL_DISPATCHER_MAX_BATCH_SIZE);
        return new MonitorServiceConfiguration.GlobalConfiguration(subsystemEnabled, apiJndi, autoDiscoveryScanPeriodSecs, numDmrSchedulerThreads, metricDispatcherBufferSize, metricDispatcherMaxBatchSize, availDispatcherBufferSize, availDispatcherMaxBatchSize);
    }

    private static void determineResourceTypeSetDmr(ModelNode config, OperationContext context, TypeSets.Builder<DMRNodeLocation> typeSetsBuilder) throws OperationFailedException {
        boolean enabled = false;
        if (config.hasDefined("resource-type-set-dmr")) {
            List resourceTypeSetsList = config.get("resource-type-set-dmr").asPropertyList();
            for (Property resourceTypeSetProperty : resourceTypeSetsList) {
                String resourceTypeSetName = resourceTypeSetProperty.getName();
                ModelNode resourceTypeSetValueNode = resourceTypeSetProperty.getValue();
                TypeSet.TypeSetBuilder typeSetBuilder = TypeSet.builder().name(new Name(resourceTypeSetName)).enabled(MonitorServiceConfigurationBuilder.getBoolean(resourceTypeSetValueNode, context, DMRResourceTypeSetAttributes.ENABLED));
                if (resourceTypeSetName.indexOf(44) > -1) {
                    log.warnCommaInName(resourceTypeSetName);
                }
                if (resourceTypeSetValueNode.hasDefined("resource-type-dmr")) {
                    List resourceTypesList = resourceTypeSetValueNode.get("resource-type-dmr").asPropertyList();
                    for (Property resourceTypeProperty : resourceTypesList) {
                        ModelNode configModelNode;
                        ModelNode resourceTypeValueNode = resourceTypeProperty.getValue();
                        String resourceTypeName = resourceTypeProperty.getName();
                        Object resourceTypeBuilder = ((ResourceType.Builder)((ResourceType.Builder)((ResourceType.Builder)((ResourceType.Builder)ResourceType.builder().id(ID.NULL_ID)).name(new Name(resourceTypeName))).location(new DMRNodeLocation(MonitorServiceConfigurationBuilder.getPath(resourceTypeValueNode, context, DMRResourceTypeAttributes.PATH)))).resourceNameTemplate(MonitorServiceConfigurationBuilder.getString(resourceTypeValueNode, context, DMRResourceTypeAttributes.RESOURCE_NAME_TEMPLATE))).parents(MonitorServiceConfigurationBuilder.getNameListFromString(resourceTypeValueNode, context, DMRResourceTypeAttributes.PARENTS));
                        List<Name> metricSets = MonitorServiceConfigurationBuilder.getNameListFromString(resourceTypeValueNode, context, DMRResourceTypeAttributes.METRIC_SETS);
                        List<Name> availSets = MonitorServiceConfigurationBuilder.getNameListFromString(resourceTypeValueNode, context, DMRResourceTypeAttributes.AVAIL_SETS);
                        ((ResourceType.Builder)((ResourceType.Builder)resourceTypeBuilder).metricSetNames(metricSets)).availSetNames(availSets);
                        ModelNode opModelNode = resourceTypeValueNode.get("operation-dmr");
                        if (opModelNode != null && opModelNode.isDefined()) {
                            List operationList = opModelNode.asPropertyList();
                            for (Property operationProperty : operationList) {
                                ModelNode operationValueNode = operationProperty.getValue();
                                String operationName = operationProperty.getName();
                                PathAddress pathAddress = MonitorServiceConfigurationBuilder.getPath(operationValueNode, context, DMROperationAttributes.PATH);
                                Operation<DMRNodeLocation> op = new Operation<DMRNodeLocation>(ID.NULL_ID, new Name(operationName), new DMRNodeLocation(pathAddress), MonitorServiceConfigurationBuilder.getString(operationValueNode, context, DMROperationAttributes.OPERATION_NAME));
                                ((ResourceType.Builder)resourceTypeBuilder).operation(op);
                            }
                        }
                        if ((configModelNode = resourceTypeValueNode.get("resource-config-dmr")) != null && configModelNode.isDefined()) {
                            List configList = configModelNode.asPropertyList();
                            for (Property configProperty : configList) {
                                ModelNode configValueNode = configProperty.getValue();
                                String configName = configProperty.getName();
                                ResourceConfigurationPropertyType<DMRNodeLocation> configType = new ResourceConfigurationPropertyType<DMRNodeLocation>(ID.NULL_ID, new Name(configName), new AttributeLocation<DMRNodeLocation>(new DMRNodeLocation(MonitorServiceConfigurationBuilder.getPath(configValueNode, context, DMRResourceConfigAttributes.PATH)), MonitorServiceConfigurationBuilder.getString(configValueNode, context, DMRResourceConfigAttributes.ATTRIBUTE)));
                                ((ResourceType.Builder)resourceTypeBuilder).resourceConfigurationPropertyType(configType);
                            }
                        }
                        MonitorServiceConfigurationBuilder.populateMetricAndAvailTypesForResourceType(resourceTypeBuilder, typeSetsBuilder);
                        ResourceType resourceType = ((ResourceType.Builder)resourceTypeBuilder).build();
                        typeSetBuilder.type(resourceType);
                    }
                }
                TypeSet typeSet = typeSetBuilder.build();
                enabled = enabled || !typeSet.isDisabledOrEmpty();
                typeSetsBuilder.resourceTypeSet(typeSet);
            }
        }
        if (!enabled) {
            log.infoNoEnabledResourceTypesConfigured("DMR");
        }
    }

    private static void determineResourceTypeSetJmx(ModelNode config, OperationContext context, TypeSets.Builder<JMXNodeLocation> typeSetsBuilder) throws OperationFailedException {
        boolean enabled = false;
        if (config.hasDefined("resource-type-set-jmx")) {
            List resourceTypeSetsList = config.get("resource-type-set-jmx").asPropertyList();
            for (Property resourceTypeSetProperty : resourceTypeSetsList) {
                String resourceTypeSetName = resourceTypeSetProperty.getName();
                ModelNode resourceTypeSetValueNode = resourceTypeSetProperty.getValue();
                TypeSet.TypeSetBuilder typeSetBuilder = TypeSet.builder().name(new Name(resourceTypeSetName)).enabled(MonitorServiceConfigurationBuilder.getBoolean(resourceTypeSetValueNode, context, JMXResourceTypeSetAttributes.ENABLED));
                if (resourceTypeSetName.indexOf(44) > -1) {
                    log.warnCommaInName(resourceTypeSetName);
                }
                if (resourceTypeSetValueNode.hasDefined("resource-type-jmx")) {
                    List resourceTypesList = resourceTypeSetValueNode.get("resource-type-jmx").asPropertyList();
                    for (Property resourceTypeProperty : resourceTypesList) {
                        ModelNode resourceTypeValueNode = resourceTypeProperty.getValue();
                        String resourceTypeName = resourceTypeProperty.getName();
                        String objectName = MonitorServiceConfigurationBuilder.getObjectName(resourceTypeValueNode, context, JMXResourceTypeAttributes.OBJECT_NAME);
                        try {
                            ModelNode configModelNode;
                            Object resourceTypeBuilder = ((ResourceType.Builder)((ResourceType.Builder)((ResourceType.Builder)((ResourceType.Builder)ResourceType.builder().id(ID.NULL_ID)).name(new Name(resourceTypeName))).location(new JMXNodeLocation(objectName))).resourceNameTemplate(MonitorServiceConfigurationBuilder.getString(resourceTypeValueNode, context, JMXResourceTypeAttributes.RESOURCE_NAME_TEMPLATE))).parents(MonitorServiceConfigurationBuilder.getNameListFromString(resourceTypeValueNode, context, JMXResourceTypeAttributes.PARENTS));
                            List<Name> metricSets = MonitorServiceConfigurationBuilder.getNameListFromString(resourceTypeValueNode, context, JMXResourceTypeAttributes.METRIC_SETS);
                            List<Name> availSets = MonitorServiceConfigurationBuilder.getNameListFromString(resourceTypeValueNode, context, JMXResourceTypeAttributes.AVAIL_SETS);
                            ((ResourceType.Builder)((ResourceType.Builder)resourceTypeBuilder).metricSetNames(metricSets)).availSetNames(availSets);
                            ModelNode opModelNode = resourceTypeValueNode.get("operation-jmx");
                            if (opModelNode != null && opModelNode.isDefined()) {
                                List operationList = opModelNode.asPropertyList();
                                for (Property operationProperty : operationList) {
                                    ModelNode operationValueNode = operationProperty.getValue();
                                    String operationName = operationProperty.getName();
                                    Operation<JMXNodeLocation> op = new Operation<JMXNodeLocation>(ID.NULL_ID, new Name(operationName), new JMXNodeLocation(MonitorServiceConfigurationBuilder.getObjectName(operationValueNode, context, JMXOperationAttributes.OBJECT_NAME)), MonitorServiceConfigurationBuilder.getString(operationValueNode, context, JMXOperationAttributes.OPERATION_NAME));
                                    ((ResourceType.Builder)resourceTypeBuilder).operation(op);
                                }
                            }
                            if ((configModelNode = resourceTypeValueNode.get("resource-config-jmx")) != null && configModelNode.isDefined()) {
                                List configList = configModelNode.asPropertyList();
                                for (Property configProperty : configList) {
                                    ModelNode configValueNode = configProperty.getValue();
                                    String configName = configProperty.getName();
                                    String on = MonitorServiceConfigurationBuilder.getObjectName(configValueNode, context, JMXResourceConfigAttributes.OBJECT_NAME);
                                    String attr = MonitorServiceConfigurationBuilder.getString(configValueNode, context, JMXResourceConfigAttributes.ATTRIBUTE);
                                    AttributeLocation<JMXNodeLocation> attribLoc = new AttributeLocation<JMXNodeLocation>(new JMXNodeLocation(on), attr);
                                    ResourceConfigurationPropertyType<JMXNodeLocation> configType = new ResourceConfigurationPropertyType<JMXNodeLocation>(ID.NULL_ID, new Name(configName), attribLoc);
                                    ((ResourceType.Builder)resourceTypeBuilder).resourceConfigurationPropertyType(configType);
                                }
                            }
                            MonitorServiceConfigurationBuilder.populateMetricAndAvailTypesForResourceType(resourceTypeBuilder, typeSetsBuilder);
                            ResourceType resourceType = ((ResourceType.Builder)resourceTypeBuilder).build();
                            typeSetBuilder.type(resourceType);
                        }
                        catch (MalformedObjectNameException e) {
                            log.warnMalformedJMXObjectName(objectName, e);
                        }
                    }
                }
                TypeSet typeSet = typeSetBuilder.build();
                enabled = enabled || !typeSet.isDisabledOrEmpty();
                typeSetsBuilder.resourceTypeSet(typeSet);
            }
        }
        if (!enabled) {
            log.infoNoEnabledResourceTypesConfigured("JMX");
        }
    }

    private void determineManagedServers(ModelNode config, OperationContext context) throws OperationFailedException {
        if (config.hasDefined("managed-servers")) {
            MonitorServiceConfiguration.AbstractEndpointConfiguration endpoint;
            ConnectionData connectionData;
            Avail setAvailOnShutdown;
            String setAvailOnShutdownStr;
            String name;
            List asPropertyList = config.get("managed-servers").asPropertyList();
            if (asPropertyList.size() > 1) {
                throw new IllegalArgumentException("Can only have one <managed-resources>: " + config.toJSONString(true));
            }
            ModelNode managedServersValueNode = ((Property)asPropertyList.get(0)).getValue();
            if (managedServersValueNode.hasDefined("remote-dmr")) {
                List remoteDMRsList = managedServersValueNode.get("remote-dmr").asPropertyList();
                for (Property remoteDMRProperty : remoteDMRsList) {
                    name = remoteDMRProperty.getName();
                    ModelNode remoteDMRValueNode = remoteDMRProperty.getValue();
                    boolean enabled = MonitorServiceConfigurationBuilder.getBoolean(remoteDMRValueNode, context, RemoteDMRAttributes.ENABLED);
                    setAvailOnShutdownStr = MonitorServiceConfigurationBuilder.getString(remoteDMRValueNode, context, RemoteDMRAttributes.SET_AVAIL_ON_SHUTDOWN);
                    setAvailOnShutdown = setAvailOnShutdownStr == null ? null : Avail.valueOf(setAvailOnShutdownStr);
                    String host = MonitorServiceConfigurationBuilder.getString(remoteDMRValueNode, context, RemoteDMRAttributes.HOST);
                    int port = MonitorServiceConfigurationBuilder.getInt(remoteDMRValueNode, context, RemoteDMRAttributes.PORT);
                    String username = MonitorServiceConfigurationBuilder.getString(remoteDMRValueNode, context, RemoteDMRAttributes.USERNAME);
                    String password = MonitorServiceConfigurationBuilder.getString(remoteDMRValueNode, context, RemoteDMRAttributes.PASSWORD);
                    boolean useSsl = MonitorServiceConfigurationBuilder.getBoolean(remoteDMRValueNode, context, RemoteDMRAttributes.USE_SSL);
                    String securityRealm = MonitorServiceConfigurationBuilder.getString(remoteDMRValueNode, context, RemoteDMRAttributes.SECURITY_REALM);
                    List<Name> resourceTypeSets = MonitorServiceConfigurationBuilder.getNameListFromString(remoteDMRValueNode, context, RemoteDMRAttributes.RESOURCE_TYPE_SETS);
                    String tenantId = MonitorServiceConfigurationBuilder.getString(remoteDMRValueNode, context, RemoteDMRAttributes.TENANT_ID);
                    if (useSsl && securityRealm == null) {
                        log.debugf("Using SSL with no security realm - will rely on the JVM truststore: " + name, new Object[0]);
                    }
                    String protocol = useSsl ? "https-remoting" : "http-remoting";
                    connectionData = new ConnectionData(protocol, host, port, username, password);
                    endpoint = new MonitorServiceConfiguration.EndpointConfiguration(name, enabled, resourceTypeSets, connectionData, securityRealm, setAvailOnShutdown, tenantId);
                    this.dmrConfigBuilder.endpoint((MonitorServiceConfiguration.EndpointConfiguration)endpoint);
                }
            }
            if (managedServersValueNode.hasDefined("local-dmr")) {
                List localDMRsList = managedServersValueNode.get("local-dmr").asPropertyList();
                if (localDMRsList.size() > 1) {
                    throw new IllegalArgumentException("Can only have one <local-dmr>: " + config.toJSONString(true));
                }
                Property localDMRProperty = (Property)localDMRsList.get(0);
                String name2 = localDMRProperty.getName();
                ModelNode localDMRValueNode = localDMRProperty.getValue();
                boolean enabled = MonitorServiceConfigurationBuilder.getBoolean(localDMRValueNode, context, LocalDMRAttributes.ENABLED);
                String setAvailOnShutdownStr2 = MonitorServiceConfigurationBuilder.getString(localDMRValueNode, context, LocalDMRAttributes.SET_AVAIL_ON_SHUTDOWN);
                Avail setAvailOnShutdown2 = setAvailOnShutdownStr2 == null ? null : Avail.valueOf(setAvailOnShutdownStr2);
                List<Name> resourceTypeSets = MonitorServiceConfigurationBuilder.getNameListFromString(localDMRValueNode, context, LocalDMRAttributes.RESOURCE_TYPE_SETS);
                String tenantId = MonitorServiceConfigurationBuilder.getString(localDMRValueNode, context, LocalDMRAttributes.TENANT_ID);
                MonitorServiceConfiguration.EndpointConfiguration endpoint2 = new MonitorServiceConfiguration.EndpointConfiguration(name2, enabled, resourceTypeSets, null, null, setAvailOnShutdown2, tenantId);
                this.dmrConfigBuilder.endpoint(endpoint2);
            }
            if (managedServersValueNode.hasDefined("remote-jmx")) {
                List remoteJMXsList = managedServersValueNode.get("remote-jmx").asPropertyList();
                for (Property remoteJMXProperty : remoteJMXsList) {
                    URI url;
                    name = remoteJMXProperty.getName();
                    ModelNode remoteJMXValueNode = remoteJMXProperty.getValue();
                    boolean enabled = MonitorServiceConfigurationBuilder.getBoolean(remoteJMXValueNode, context, RemoteJMXAttributes.ENABLED);
                    setAvailOnShutdownStr = MonitorServiceConfigurationBuilder.getString(remoteJMXValueNode, context, RemoteJMXAttributes.SET_AVAIL_ON_SHUTDOWN);
                    setAvailOnShutdown = setAvailOnShutdownStr == null ? null : Avail.valueOf(setAvailOnShutdownStr);
                    String urlStr = MonitorServiceConfigurationBuilder.getString(remoteJMXValueNode, context, RemoteJMXAttributes.URL);
                    String username = MonitorServiceConfigurationBuilder.getString(remoteJMXValueNode, context, RemoteJMXAttributes.USERNAME);
                    String password = MonitorServiceConfigurationBuilder.getString(remoteJMXValueNode, context, RemoteJMXAttributes.PASSWORD);
                    String securityRealm = MonitorServiceConfigurationBuilder.getString(remoteJMXValueNode, context, RemoteJMXAttributes.SECURITY_REALM);
                    List<Name> resourceTypeSets = MonitorServiceConfigurationBuilder.getNameListFromString(remoteJMXValueNode, context, RemoteJMXAttributes.RESOURCE_TYPE_SETS);
                    String tenantId = MonitorServiceConfigurationBuilder.getString(remoteJMXValueNode, context, RemoteJMXAttributes.TENANT_ID);
                    try {
                        url = new URI(urlStr);
                    }
                    catch (Exception e) {
                        throw new OperationFailedException("Invalid remote JMX URL: " + urlStr, (Throwable)e);
                    }
                    if (url.getScheme().equalsIgnoreCase("https") && securityRealm == null) {
                        log.debugf("Using SSL with no security realm - will rely on the JVM truststore: " + name, new Object[0]);
                    }
                    ConnectionData connectionData2 = new ConnectionData(url, username, password);
                    MonitorServiceConfiguration.EndpointConfiguration endpoint3 = new MonitorServiceConfiguration.EndpointConfiguration(name, enabled, resourceTypeSets, connectionData2, securityRealm, setAvailOnShutdown, tenantId);
                    this.jmxConfigBuilder.endpoint(endpoint3);
                }
            }
            if (managedServersValueNode.hasDefined("remote-prometheus")) {
                List remotePromsList = managedServersValueNode.get("remote-prometheus").asPropertyList();
                for (Property remotePromProperty : remotePromsList) {
                    URI url;
                    name = remotePromProperty.getName();
                    ModelNode remotePromValueNode = remotePromProperty.getValue();
                    boolean enabled = MonitorServiceConfigurationBuilder.getBoolean(remotePromValueNode, context, RemotePrometheusAttributes.ENABLED);
                    String urlStr = MonitorServiceConfigurationBuilder.getString(remotePromValueNode, context, RemotePrometheusAttributes.URL);
                    String username = MonitorServiceConfigurationBuilder.getString(remotePromValueNode, context, RemotePrometheusAttributes.USERNAME);
                    String password = MonitorServiceConfigurationBuilder.getString(remotePromValueNode, context, RemotePrometheusAttributes.PASSWORD);
                    String securityRealm = MonitorServiceConfigurationBuilder.getString(remotePromValueNode, context, RemotePrometheusAttributes.SECURITY_REALM);
                    Map<String, String> labels = MonitorServiceConfigurationBuilder.getMapFromString(remotePromValueNode, context, RemotePrometheusAttributes.LABELS);
                    List<Name> metricSets = MonitorServiceConfigurationBuilder.getNameListFromString(remotePromValueNode, context, RemotePrometheusAttributes.METRIC_SETS);
                    int interval = MonitorServiceConfigurationBuilder.getInt(remotePromValueNode, context, RemotePrometheusAttributes.INTERVAL);
                    String timeUnitsStr = MonitorServiceConfigurationBuilder.getString(remotePromValueNode, context, RemotePrometheusAttributes.TIME_UNITS);
                    TimeUnit timeUnits = TimeUnit.valueOf(timeUnitsStr.toUpperCase());
                    String tenandId = MonitorServiceConfigurationBuilder.getString(remotePromValueNode, context, RemotePrometheusAttributes.TENANT_ID);
                    try {
                        url = new URI(urlStr);
                    }
                    catch (Exception e) {
                        throw new OperationFailedException("Invalid remote Prometheus URL: " + urlStr, (Throwable)e);
                    }
                    if (url.getScheme().equalsIgnoreCase("https") && securityRealm == null) {
                        log.debugf("Using SSL with no security realm - will rely on the JVM truststore: " + name, new Object[0]);
                    }
                    connectionData = new ConnectionData(url, username, password);
                    endpoint = new MonitorServiceConfiguration.DynamicEndpointConfiguration(name, enabled, labels, metricSets, connectionData, securityRealm, interval, timeUnits, tenandId);
                    this.prometheusConfigBuilder.endpoint((MonitorServiceConfiguration.DynamicEndpointConfiguration)endpoint);
                }
            }
        }
    }

    private static boolean getBoolean(ModelNode modelNode, OperationContext context, SimpleAttributeDefinition attrib) throws OperationFailedException {
        ModelNode value = attrib.resolveModelAttribute(context, modelNode);
        return value.isDefined() ? value.asBoolean() : false;
    }

    private static String getString(ModelNode modelNode, OperationContext context, SimpleAttributeDefinition attrib) throws OperationFailedException {
        ModelNode value = attrib.resolveModelAttribute(context, modelNode);
        return value.isDefined() ? value.asString() : null;
    }

    private static PathAddress getPath(ModelNode modelNode, OperationContext context, SimpleAttributeDefinition attrib) throws OperationFailedException {
        String path = MonitorServiceConfigurationBuilder.getString(modelNode, context, attrib);
        if (path == null) {
            return null;
        }
        if ("/".equals(path)) {
            return PathAddress.EMPTY_ADDRESS;
        }
        return PathAddress.parseCLIStyleAddress((String)path);
    }

    private static int getInt(ModelNode modelNode, OperationContext context, SimpleAttributeDefinition attrib) throws OperationFailedException {
        ModelNode value = attrib.resolveModelAttribute(context, modelNode);
        return value.isDefined() ? value.asInt() : 0;
    }

    private static String getObjectName(ModelNode modelNode, OperationContext context, SimpleAttributeDefinition attrib) throws OperationFailedException {
        String value = MonitorServiceConfigurationBuilder.getString(modelNode, context, attrib);
        if (value != null && !value.isEmpty()) {
            try {
                new ObjectName(value);
            }
            catch (MalformedObjectNameException e) {
                throw new OperationFailedException(String.format("Attribute [%s] is an invalid object name [%s]", attrib.getName(), value), (Throwable)e);
            }
        }
        return value;
    }

    private static List<Name> getNameListFromString(ModelNode modelNode, OperationContext context, SimpleAttributeDefinition attrib) throws OperationFailedException {
        ModelNode value = attrib.resolveModelAttribute(context, modelNode);
        if (value.isDefined()) {
            String commaSeparatedList = value.asString();
            String[] stringArray = commaSeparatedList.split(",");
            ArrayList<Name> names = new ArrayList<Name>(stringArray.length);
            for (String str : stringArray) {
                names.add(new Name(str));
            }
            return names;
        }
        return Collections.emptyList();
    }

    private static Map<String, String> getMapFromString(ModelNode modelNode, OperationContext context, SimpleAttributeDefinition attrib) throws OperationFailedException {
        ModelNode value = attrib.resolveModelAttribute(context, modelNode);
        if (value.isDefined()) {
            HashMap<String, String> map = new HashMap<String, String>();
            String commaSeparatedList = value.asString();
            StringTokenizer strtok = new StringTokenizer(commaSeparatedList, ",");
            while (strtok.hasMoreTokens()) {
                String nameValueToken = strtok.nextToken().trim();
                String[] nameValueArr = nameValueToken.split("=");
                if (nameValueArr.length != 2) {
                    throw new OperationFailedException("missing '=' in name-value pair: " + commaSeparatedList);
                }
                map.put(nameValueArr[0].trim(), nameValueArr[1].trim());
            }
            return map;
        }
        return Collections.emptyMap();
    }

    private static <L> void populateMetricAndAvailTypesForResourceType(ResourceType.Builder<?, L> resourceTypeBuilder, TypeSets.Builder<L> typeSetsBuilder) {
        Map<Name, TypeSet<MetricType<L>>> metricTypeSets = typeSetsBuilder.getMetricTypeSets();
        List<Name> metricSetNames = resourceTypeBuilder.getMetricSetNames();
        for (Name metricSetName : metricSetNames) {
            TypeSet<MetricType<L>> metricSet = metricTypeSets.get(metricSetName);
            if (metricSet == null || !metricSet.isEnabled()) continue;
            resourceTypeBuilder.metricTypes(metricSet.getTypeMap().values());
        }
        Map<Name, TypeSet<AvailType<L>>> availTypeSets = typeSetsBuilder.getAvailTypeSets();
        List<Name> availSetNames = resourceTypeBuilder.getAvailSetNames();
        for (Name availSetName : availSetNames) {
            TypeSet<AvailType<L>> availSet = availTypeSets.get(availSetName);
            if (availSet == null || !availSet.isEnabled()) continue;
            resourceTypeBuilder.availTypes(availSet.getTypeMap().values());
        }
    }
}

