/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.extension;

import org.hawkular.agent.monitor.extension.MonitorServiceAddStepHandler;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.extension.RemoteJMXAttributes;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.ProtocolService;
import org.hawkular.agent.monitor.protocol.ProtocolServices;
import org.hawkular.agent.monitor.protocol.jmx.JMXNodeLocation;
import org.hawkular.agent.monitor.protocol.jmx.JMXSession;
import org.hawkular.agent.monitor.service.MonitorService;
import org.hawkular.agent.monitor.util.Util;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;

public class RemoteJMXAdd
extends MonitorServiceAddStepHandler {
    private static final MsgLogger log = AgentLoggers.getLogger(RemoteJMXAdd.class);
    public static final RemoteJMXAdd INSTANCE = new RemoteJMXAdd();

    private RemoteJMXAdd() {
        super(RemoteJMXAttributes.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.isBooting()) {
            return;
        }
        MonitorService monitorService = this.getMonitorService(context);
        if (monitorService == null) {
            return;
        }
        MonitorServiceConfiguration config = Util.getMonitorServiceConfiguration(context);
        ProtocolServices newServices = monitorService.createProtocolServicesBuilder().jmxProtocolService(config.getJmxConfiguration()).build();
        EndpointService<JMXNodeLocation, JMXSession> endpointService = newServices.getJmxProtocolService().getEndpointServices().get(context.getCurrentAddressValue());
        ProtocolService<JMXNodeLocation, JMXSession> jmxService = monitorService.getProtocolServices().getJmxProtocolService();
        jmxService.add(endpointService);
    }
}

