/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hawkular.agent.monitor.api.InventoryListener;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.Session;
import org.hawkular.agent.monitor.scheduler.SchedulerService;

public class ProtocolService<L, S extends Session<L>> {
    private static final MsgLogger log = AgentLoggers.getLogger(ProtocolService.class);
    private final Map<String, EndpointService<L, S>> endpointServices;

    public static <L, S extends Session<L>> Builder<L, S> builder() {
        return new Builder();
    }

    public ProtocolService(Map<String, EndpointService<L, S>> endpointServices) {
        this.endpointServices = endpointServices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, EndpointService<L, S>> getEndpointServices() {
        Map<String, EndpointService<L, S>> map = this.endpointServices;
        synchronized (map) {
            return new HashMap<String, EndpointService<L, S>>(this.endpointServices);
        }
    }

    public void discoverAll() {
        for (EndpointService<L, S> service : this.getEndpointServices().values()) {
            service.discoverAll();
        }
    }

    public void start() {
        for (EndpointService<L, S> service : this.getEndpointServices().values()) {
            service.start();
        }
    }

    public void stop() {
        for (EndpointService<L, S> service : this.getEndpointServices().values()) {
            service.stop();
        }
    }

    public void addInventoryListener(InventoryListener listener) {
        for (EndpointService<L, S> service : this.getEndpointServices().values()) {
            service.addInventoryListener(listener);
        }
    }

    public void removeInventoryListener(InventoryListener listener) {
        for (EndpointService<L, S> service : this.getEndpointServices().values()) {
            service.removeInventoryListener(listener);
        }
    }

    public void add(EndpointService<L, S> newEndpointService) {
        if (newEndpointService == null) {
            throw new IllegalArgumentException("New endpoint service must not be null");
        }
        this.endpointServices.put(newEndpointService.getMonitoredEndpoint().getName(), newEndpointService);
        newEndpointService.start();
        log.infoAddedEndpointService(newEndpointService.toString());
        newEndpointService.discoverAll();
    }

    public void remove(String name, SchedulerService scheduler) {
        EndpointService<L, S> service = this.endpointServices.remove(name);
        if (service != null) {
            service.stop();
            List<Resource<L>> allResources = service.getResourceManager().getResourcesBreadthFirst();
            scheduler.unschedule(service, allResources);
            log.infoRemovedEndpointService(service.toString());
        }
    }

    public static class Builder<L, S extends Session<L>> {
        private Map<String, EndpointService<L, S>> endpointServices = new HashMap<String, EndpointService<L, S>>();

        public ProtocolService<L, S> build() {
            return new ProtocolService<L, S>(Collections.synchronizedMap(this.endpointServices));
        }

        public Builder<L, S> endpointService(EndpointService<L, S> endpointService) {
            this.endpointServices.put(endpointService.getMonitoredEndpoint().getName(), endpointService);
            return this;
        }
    }
}

