/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.service;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import org.hawkular.agent.monitor.api.Avail;
import org.hawkular.agent.monitor.api.HawkularWildFlyAgentContext;
import org.hawkular.agent.monitor.api.HawkularWildFlyAgentContextImpl;
import org.hawkular.agent.monitor.cmd.FeedCommProcessor;
import org.hawkular.agent.monitor.diagnostics.Diagnostics;
import org.hawkular.agent.monitor.diagnostics.DiagnosticsImpl;
import org.hawkular.agent.monitor.diagnostics.JBossLoggingReporter;
import org.hawkular.agent.monitor.diagnostics.StorageReporter;
import org.hawkular.agent.monitor.dynamicprotocol.DynamicProtocolServices;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.inventory.MeasurementInstance;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.inventory.ResourceManager;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.ProtocolService;
import org.hawkular.agent.monitor.protocol.ProtocolServices;
import org.hawkular.agent.monitor.protocol.dmr.DMREndpointService;
import org.hawkular.agent.monitor.protocol.dmr.ModelControllerClientFactory;
import org.hawkular.agent.monitor.scheduler.SchedulerConfiguration;
import org.hawkular.agent.monitor.scheduler.SchedulerService;
import org.hawkular.agent.monitor.storage.AvailDataPoint;
import org.hawkular.agent.monitor.storage.AvailStorageProxy;
import org.hawkular.agent.monitor.storage.HawkularStorageAdapter;
import org.hawkular.agent.monitor.storage.HttpClientBuilder;
import org.hawkular.agent.monitor.storage.InventoryStorageProxy;
import org.hawkular.agent.monitor.storage.MetricStorageProxy;
import org.hawkular.agent.monitor.storage.StorageAdapter;
import org.hawkular.agent.monitor.util.Util;
import org.hawkular.inventory.api.model.Feed;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.security.SSLContextService;
import org.jboss.as.host.controller.DomainModelControllerService;
import org.jboss.as.naming.ImmediateManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.server.Services;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class MonitorService
implements Service<MonitorService> {
    private static final MsgLogger log = AgentLoggers.getLogger(MonitorService.class);
    private final InjectedValue<ModelController> modelControllerValue = new InjectedValue();
    private final InjectedValue<ServerEnvironment> serverEnvironmentValue = new InjectedValue();
    private final InjectedValue<ControlledProcessStateService> processStateValue = new InjectedValue();
    private final InjectedValue<SocketBinding> httpSocketBindingValue = new InjectedValue();
    private final InjectedValue<SocketBinding> httpsSocketBindingValue = new InjectedValue();
    private final InjectedValue<OutboundSocketBinding> serverOutboundSocketBindingValue = new InjectedValue();
    private final Map<String, InjectedValue<SSLContext>> trustOnlySSLContextValues = new HashMap<String, InjectedValue<SSLContext>>();
    private boolean started = false;
    private PropertyChangeListener serverStateListener;
    private final MonitorServiceConfiguration bootConfiguration;
    private final ProcessType processType;
    private MonitorServiceConfiguration configuration;
    private String feedId;
    private Diagnostics diagnostics;
    private ScheduledReporter diagnosticsReporter;
    private StorageAdapter storageAdapter;
    private HttpClientBuilder httpClientBuilder;
    private FeedCommProcessor feedComm;
    private SchedulerService schedulerService;
    private final MetricStorageProxy metricStorageProxy = new MetricStorageProxy();
    private final AvailStorageProxy availStorageProxy = new AvailStorageProxy();
    private final InventoryStorageProxy inventoryStorageProxy = new InventoryStorageProxy();
    private ProtocolServices protocolServices;
    private DynamicProtocolServices dynamicProtocolServices;
    private ModelControllerClientFactory localModelControllerClientFactory;

    private static MonitorServiceConfiguration buildRuntimeConfiguration(MonitorServiceConfiguration bootConfiguration, InjectedValue<SocketBinding> httpSocketBindingValue, InjectedValue<SocketBinding> httpsSocketBindingValue, InjectedValue<OutboundSocketBinding> serverOutboundSocketBindingValue, Map<String, InjectedValue<SSLContext>> trustOnlySSLContextValues) {
        MonitorServiceConfiguration.StorageAdapterConfiguration bootStorageAdapter = bootConfiguration.getStorageAdapter();
        log.infoStorageAdapterMode(bootStorageAdapter.getType());
        if (bootStorageAdapter.getTenantId() != null && bootStorageAdapter.getUrl() != null) {
            return bootConfiguration;
        }
        String useUrl = bootStorageAdapter.getUrl();
        if (useUrl == null) {
            try {
                int port;
                String address;
                if (bootStorageAdapter.getServerOutboundSocketBindingRef() == null) {
                    SocketBinding socketBinding = bootStorageAdapter.isUseSSL() ? (SocketBinding)httpsSocketBindingValue.getValue() : (SocketBinding)httpSocketBindingValue.getValue();
                    address = socketBinding.getAddress().getHostName();
                    if (address.equals("0.0.0.0") || address.equals("::/128")) {
                        address = InetAddress.getLocalHost().getCanonicalHostName();
                    }
                    port = socketBinding.getAbsolutePort();
                } else {
                    OutboundSocketBinding serverBinding = (OutboundSocketBinding)serverOutboundSocketBindingValue.getValue();
                    address = serverBinding.getResolvedDestinationAddress().getHostName();
                    port = serverBinding.getDestinationPort();
                }
                String protocol = bootStorageAdapter.isUseSSL() ? "https" : "http";
                useUrl = String.format("%s://%s:%d", protocol, address, port);
            }
            catch (UnknownHostException uhe) {
                throw new IllegalArgumentException("Cannot determine Hawkular server host", uhe);
            }
        }
        log.infoUsingServerSideUrl(useUrl);
        String useTenantId = bootStorageAdapter.getTenantId();
        if (bootStorageAdapter.getType() == MonitorServiceConfiguration.StorageReportTo.HAWKULAR) {
            long retryWait = 60000L;
            int retriesRemaining = 60;
            while (retriesRemaining-- > 0) {
                try {
                    StringBuilder url = Util.getContextUrlString(useUrl, bootStorageAdapter.getAccountsContext());
                    url.append("personas/current");
                    SSLContext sslContext = MonitorService.getSslContext(bootConfiguration, trustOnlySSLContextValues);
                    HttpClientBuilder httpClientBuilder = new HttpClientBuilder(bootConfiguration.getStorageAdapter(), sslContext);
                    OkHttpClient httpclient = httpClientBuilder.getHttpClient();
                    Request request = httpClientBuilder.buildJsonGetRequest(url.toString(), null);
                    Response httpResponse = httpclient.newCall(request).execute();
                    if (!httpResponse.isSuccessful()) {
                        throw new Exception("status-code=[" + httpResponse.code() + "], reason=[" + httpResponse.message() + "], url=[" + url + "]");
                    }
                    String fromServer = httpResponse.body().string();
                    Matcher matcher = Pattern.compile("\"id\":\"(.*?)\"").matcher(fromServer);
                    if (matcher.find()) {
                        String tenantIdFromAccounts = matcher.group(1);
                        if (useTenantId != null && !tenantIdFromAccounts.equals(useTenantId)) {
                            log.errorWrongTenantId(useTenantId, tenantIdFromAccounts);
                            throw new Exception("Aborting agent startup because the desired tenant ID [" + useTenantId + "] does not match the actual tenant ID [" + tenantIdFromAccounts + "]");
                        }
                        useTenantId = tenantIdFromAccounts;
                    }
                    if (useTenantId == null) {
                        throw new Exception("Got a null tenantId which is invalid");
                    }
                    log.debugf("Tenant ID [%s]", useTenantId);
                    retriesRemaining = 0;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(ie);
                }
                catch (Throwable t) {
                    log.errorRetryTenantId(t.toString());
                    try {
                        Thread.sleep(retryWait);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(ie);
                    }
                }
            }
        }
        MonitorServiceConfiguration.StorageAdapterConfiguration runtimeStorageAdapter = new MonitorServiceConfiguration.StorageAdapterConfiguration(bootStorageAdapter.getType(), bootStorageAdapter.getUsername(), bootStorageAdapter.getPassword(), bootStorageAdapter.getSecurityKey(), bootStorageAdapter.getSecuritySecret(), useTenantId, bootStorageAdapter.getFeedId(), useUrl, bootStorageAdapter.isUseSSL(), bootStorageAdapter.getServerOutboundSocketBindingRef(), bootStorageAdapter.getAccountsContext(), bootStorageAdapter.getInventoryContext(), bootStorageAdapter.getMetricsContext(), bootStorageAdapter.getFeedcommContext(), bootStorageAdapter.getKeystorePath(), bootStorageAdapter.getKeystorePassword(), bootStorageAdapter.getSecurityRealm());
        return bootConfiguration.cloneWith(runtimeStorageAdapter);
    }

    private static SSLContext getSslContext(MonitorServiceConfiguration configuration, Map<String, InjectedValue<SSLContext>> trustOnlySSLContextValues) {
        SSLContext result = null;
        String bootSecurityRealm = configuration.getStorageAdapter().getSecurityRealm();
        if (bootSecurityRealm != null) {
            result = (SSLContext)trustOnlySSLContextValues.get(bootSecurityRealm).getOptionalValue();
        }
        return result;
    }

    public MonitorService(MonitorServiceConfiguration bootConfiguration, ProcessType processType) {
        this.bootConfiguration = bootConfiguration;
        this.processType = processType;
    }

    public MonitorService getValue() {
        return this;
    }

    public HawkularWildFlyAgentContext getHawkularMonitorContext() {
        return new HawkularWildFlyAgentContextImpl(this.metricStorageProxy, this.availStorageProxy, this.inventoryStorageProxy);
    }

    public void addDependencies(ServiceTarget target, ServiceBuilder<MonitorService> bldr) {
        boolean bindJndi;
        String securityRealm;
        if (this.processType.isManagedDomain()) {
            bldr.addDependency(DomainModelControllerService.SERVICE_NAME, ModelController.class, this.modelControllerValue);
        } else {
            bldr.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, this.serverEnvironmentValue);
            bldr.addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, this.modelControllerValue);
        }
        bldr.addDependency(ControlledProcessStateService.SERVICE_NAME, ControlledProcessStateService.class, this.processStateValue);
        MonitorServiceConfiguration.StorageAdapterConfiguration storageAdapterConfig = this.bootConfiguration.getStorageAdapter();
        if (storageAdapterConfig.getUrl() == null || storageAdapterConfig.getUrl().isEmpty()) {
            if (storageAdapterConfig.getServerOutboundSocketBindingRef() == null || storageAdapterConfig.getServerOutboundSocketBindingRef().isEmpty()) {
                if (this.processType.isManagedDomain()) {
                    throw new IllegalStateException("Do not know where the external Hawkular server is. Aborting.");
                }
                bldr.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{"http"}), SocketBinding.class, this.httpSocketBindingValue);
                bldr.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{"https"}), SocketBinding.class, this.httpsSocketBindingValue);
            } else {
                if (this.processType.isManagedDomain()) {
                    throw new IllegalStateException("When deployed in host controller, you must use the URL attribute and not the outbound socket binding. See bug https://issues.jboss.org/browse/WFCORE-1505 for more.");
                }
                bldr.addDependency(OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{storageAdapterConfig.getServerOutboundSocketBindingRef()}), OutboundSocketBinding.class, this.serverOutboundSocketBindingValue);
            }
        }
        if (storageAdapterConfig.getSecurityRealm() != null) {
            InjectedValue iv = new InjectedValue();
            this.trustOnlySSLContextValues.put(storageAdapterConfig.getSecurityRealm(), (InjectedValue<SSLContext>)iv);
            boolean trustStoreOnly = true;
            SSLContextService.ServiceUtil.addDependency(bldr, (Injector)iv, (ServiceName)SecurityRealm.ServiceUtil.createServiceName((String)storageAdapterConfig.getSecurityRealm()), (boolean)trustStoreOnly);
        }
        for (MonitorServiceConfiguration.EndpointConfiguration endpoint : this.bootConfiguration.getDmrConfiguration().getEndpoints().values()) {
            securityRealm = endpoint.getSecurityRealm();
            if (securityRealm == null) continue;
            this.addSslContext(securityRealm, bldr);
        }
        for (MonitorServiceConfiguration.EndpointConfiguration endpoint : this.bootConfiguration.getJmxConfiguration().getEndpoints().values()) {
            securityRealm = endpoint.getSecurityRealm();
            if (securityRealm == null) continue;
            this.addSslContext(securityRealm, bldr);
        }
        for (MonitorServiceConfiguration.DynamicEndpointConfiguration endpoint : this.bootConfiguration.getPrometheusConfiguration().getEndpoints().values()) {
            securityRealm = endpoint.getSecurityRealm();
            if (securityRealm == null) continue;
            this.addSslContext(securityRealm, bldr);
        }
        String jndiName = this.bootConfiguration.getApiJndi();
        boolean bl = bindJndi = jndiName != null && !jndiName.isEmpty() && !this.processType.isManagedDomain();
        if (bindJndi) {
            HawkularWildFlyAgentContext jndiObject = this.getHawkularMonitorContext();
            ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
            BinderService binderService = new BinderService(bindInfo.getBindName());
            ImmediateManagedReferenceFactory valueMRF = new ImmediateManagedReferenceFactory((Object)jndiObject);
            String jndiObjectClassName = HawkularWildFlyAgentContext.class.getName();
            ServiceName binderServiceName = bindInfo.getBinderServiceName();
            class JndiBindListener
            extends AbstractServiceListener<Object> {
                private final String jndiName;
                private final String jndiObjectClassName;

                public JndiBindListener(String jndiName, String jndiObjectClassName) {
                    this.jndiName = jndiName;
                    this.jndiObjectClassName = jndiObjectClassName;
                }

                public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
                    switch (transition) {
                        case STARTING_to_UP: {
                            log.infoBindJndiResource(this.jndiName, this.jndiObjectClassName);
                            break;
                        }
                        case START_REQUESTED_to_DOWN: {
                            log.infoUnbindJndiResource(this.jndiName);
                            break;
                        }
                        case REMOVING_to_REMOVED: {
                            log.infoUnbindJndiResource(this.jndiName);
                            break;
                        }
                    }
                }
            }
            ServiceBuilder binderBuilder = target.addService(binderServiceName, (Service)binderService).addInjection((Injector)binderService.getManagedObjectInjector(), (Object)valueMRF).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector()).addListener((ServiceListener)new JndiBindListener(jndiName, jndiObjectClassName));
            bldr.addDependency(binderServiceName);
            binderBuilder.install();
        }
    }

    private void addSslContext(String securityRealm, ServiceBuilder<MonitorService> bldr) {
        if (securityRealm != null && !this.trustOnlySSLContextValues.containsKey(securityRealm)) {
            InjectedValue iv = new InjectedValue();
            this.trustOnlySSLContextValues.put(securityRealm, (InjectedValue<SSLContext>)iv);
            boolean trustStoreOnly = true;
            SSLContextService.ServiceUtil.addDependency(bldr, (Injector)iv, (ServiceName)SecurityRealm.ServiceUtil.createServiceName((String)securityRealm), (boolean)trustStoreOnly);
        }
    }

    public boolean isMonitorServiceStarted() {
        return this.started;
    }

    public void start(StartContext startContext) throws StartException {
        final AtomicReference startThread = new AtomicReference();
        ControlledProcessStateService stateService = (ControlledProcessStateService)this.processStateValue.getValue();
        this.serverStateListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Thread oldThread;
                if (ControlledProcessState.State.RUNNING.equals(evt.getNewValue())) {
                    Thread newThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                MonitorService.this.startMonitorService();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }, "Hawkular WildFly Agent Startup Thread");
                    newThread.setDaemon(true);
                    Thread oldThread2 = startThread.getAndSet(newThread);
                    if (oldThread2 != null) {
                        oldThread2.interrupt();
                    }
                    newThread.start();
                } else if (ControlledProcessState.State.STOPPING.equals(evt.getNewValue()) && (oldThread = (Thread)startThread.get()) != null) {
                    oldThread.interrupt();
                }
            }
        };
        stateService.addPropertyChangeListener(this.serverStateListener);
    }

    public void stop(StopContext stopContext) {
        this.stopMonitorService();
    }

    public void startMonitorService() {
        if (this.isMonitorServiceStarted()) {
            return;
        }
        try {
            DynamicProtocolServices dps;
            log.infoStarting();
            this.configuration = MonitorService.buildRuntimeConfiguration(this.bootConfiguration, this.httpSocketBindingValue, this.httpsSocketBindingValue, this.serverOutboundSocketBindingValue, this.trustOnlySSLContextValues);
            SSLContext ssl = MonitorService.getSslContext(this.configuration, this.trustOnlySSLContextValues);
            this.httpClientBuilder = new HttpClientBuilder(this.configuration.getStorageAdapter(), ssl);
            this.localModelControllerClientFactory = ModelControllerClientFactory.createLocal((ModelController)this.modelControllerValue.getValue());
            if (this.configuration.getStorageAdapter().getFeedId() != null) {
                this.feedId = this.configuration.getStorageAdapter().getFeedId();
            } else {
                try (ModelControllerClient c = this.localModelControllerClientFactory.createClient();){
                    this.feedId = DMREndpointService.lookupServerIdentifier(c);
                }
                catch (Exception e) {
                    throw new Exception("Could not obtain local feed ID", e);
                }
            }
            MetricRegistry metricRegistry = new MetricRegistry();
            this.diagnostics = new DiagnosticsImpl(this.configuration.getDiagnostics(), metricRegistry, this.feedId);
            switch (this.configuration.getStorageAdapter().getType()) {
                case HAWKULAR: {
                    if (this.configuration.getStorageAdapter().getTenantId() == null) {
                        log.errorNoTenantIdFromAccounts();
                        throw new Exception("Failed to get tenant ID");
                    }
                    try {
                        this.registerFeed();
                    }
                    catch (Exception e) {
                        log.errorCannotDoAnythingWithoutFeed(e);
                        throw new Exception("Agent needs a feed to run");
                    }
                    try {
                        this.connectToCommandGatewayCommChannel();
                    }
                    catch (Exception e) {
                        if (e instanceof InterruptedException) {
                            Thread.currentThread().interrupt();
                        }
                        log.errorCannotEstablishFeedComm(e);
                    }
                    break;
                }
                case METRICS: {
                    if (this.configuration.getStorageAdapter().getTenantId() != null) break;
                    log.errorMustHaveTenantIdConfigured();
                    throw new Exception("Agent needs a tenant ID to run");
                }
                default: {
                    throw new IllegalStateException("Unknown storage adapter type: " + (Object)((Object)this.configuration.getStorageAdapter().getType()));
                }
            }
            try {
                this.startStorageAdapter();
            }
            catch (Exception e) {
                log.errorCannotStartStorageAdapter(e);
                throw new Exception("Agent cannot start storage adapter");
            }
            try {
                this.startScheduler();
            }
            catch (Exception e) {
                log.errorCannotInitializeScheduler(e);
                throw new Exception("Agent cannot initialize scheduler");
            }
            ProtocolServices ps = this.createProtocolServicesBuilder().dmrProtocolService(this.localModelControllerClientFactory, this.configuration.getDmrConfiguration()).jmxProtocolService(this.configuration.getJmxConfiguration()).platformProtocolService(this.configuration.getPlatformConfiguration()).autoDiscoveryScanPeriodSecs(this.configuration.getAutoDiscoveryScanPeriodSecs()).build();
            ps.addInventoryListener(this.inventoryStorageProxy);
            ps.addInventoryListener(this.schedulerService);
            this.protocolServices = ps;
            this.protocolServices.start();
            this.dynamicProtocolServices = dps = this.createDynamicProtocolServicesBuilder().prometheusDynamicProtocolService(this.configuration.getPrometheusConfiguration(), this.getHawkularMonitorContext()).build();
            this.dynamicProtocolServices.start();
            this.started = true;
        }
        catch (Throwable t) {
            if (t instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            log.errorFailedToStartAgent(t);
            this.started = true;
            this.stopMonitorService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitorService() {
        if (!this.isMonitorServiceStarted()) {
            log.infoStoppedAlready();
            return;
        }
        log.infoStopping();
        AtomicReference<Object> error = new AtomicReference<Object>(null);
        try {
            try {
                if (this.feedComm != null) {
                    this.feedComm.destroy();
                    this.feedComm = null;
                }
            }
            catch (Throwable t) {
                error.compareAndSet(null, t);
                log.debug("Cannot shutdown feed comm but will continue shutdown", t);
            }
            try {
                if (this.dynamicProtocolServices != null) {
                    this.dynamicProtocolServices.stop();
                    this.dynamicProtocolServices = null;
                }
            }
            catch (Throwable t) {
                error.compareAndSet(null, t);
                log.debug("Cannot shutdown dynamic protocol services but will continue shutdown", t);
            }
            Map<EndpointService<?, ?>, List<MeasurementInstance<?, AvailType<?>>>> availsToChange = null;
            try {
                if (this.protocolServices != null) {
                    availsToChange = this.getAvailsToChange();
                    this.protocolServices.stop();
                    this.protocolServices.removeInventoryListener(this.inventoryStorageProxy);
                    this.protocolServices.removeInventoryListener(this.schedulerService);
                    this.protocolServices = null;
                }
            }
            catch (Throwable t) {
                error.compareAndSet(null, t);
                log.debug("Cannot shutdown protocol services but will continue shutdown", t);
            }
            try {
                if (this.schedulerService != null) {
                    this.schedulerService.stop();
                    this.schedulerService = null;
                }
            }
            catch (Throwable t) {
                error.compareAndSet(null, t);
                log.debug("Cannot shutdown scheduler but will continue shutdown", t);
            }
            try {
                if (this.storageAdapter != null) {
                    this.changeAvails(availsToChange);
                    this.storageAdapter.shutdown();
                    this.storageAdapter = null;
                }
            }
            catch (Throwable t) {
                error.compareAndSet(null, t);
                log.debug("Cannot shutdown storage adapter but will continue shutdown", t);
            }
            if (this.diagnosticsReporter != null) {
                this.diagnosticsReporter.stop();
                if (this.configuration.getDiagnostics().isEnabled()) {
                    this.diagnosticsReporter.report();
                }
                this.diagnosticsReporter = null;
            }
            if (this.serverStateListener != null) {
                ((ControlledProcessStateService)this.processStateValue.getValue()).removePropertyChangeListener(this.serverStateListener);
                this.serverStateListener = null;
            }
            if (error.get() != null) {
                throw (Throwable)error.get();
            }
        }
        catch (Throwable t) {
            log.warnFailedToStopAgent(t);
        }
        finally {
            this.started = false;
        }
    }

    private void changeAvails(Map<EndpointService<?, ?>, List<MeasurementInstance<?, AvailType<?>>>> availsToChange) {
        if (availsToChange != null && !availsToChange.isEmpty() && this.storageAdapter != null) {
            long now = System.currentTimeMillis();
            HashSet<AvailDataPoint> datapoints = new HashSet<AvailDataPoint>();
            for (EndpointService<AvailType<?>, AvailType<?>> endpointService : availsToChange.keySet()) {
                MonitorServiceConfiguration.EndpointConfiguration config = endpointService.getMonitoredEndpoint().getEndpointConfiguration();
                Avail setAvailOnShutdown = config.getSetAvailOnShutdown();
                if (setAvailOnShutdown == null) continue;
                List<MeasurementInstance<?, AvailType<?>>> avails = availsToChange.get(endpointService);
                for (MeasurementInstance<?, AvailType<?>> avail : avails) {
                    AvailDataPoint availDataPoint = new AvailDataPoint(endpointService.generateMeasurementKey(avail), now, setAvailOnShutdown, config.getTenantId());
                    datapoints.add(availDataPoint);
                }
            }
            this.storageAdapter.storeAvails(datapoints, 60000L);
        }
    }

    private Map<EndpointService<?, ?>, List<MeasurementInstance<?, AvailType<?>>>> getAvailsToChange() {
        HashMap avails = new HashMap();
        for (ProtocolService<?, ?> protocolService : this.protocolServices.getServices()) {
            for (EndpointService<?, ?> endpointService : protocolService.getEndpointServices().values()) {
                ResourceManager<?> rm;
                MonitorServiceConfiguration.EndpointConfiguration config = endpointService.getMonitoredEndpoint().getEndpointConfiguration();
                Avail setAvailOnShutdown = config.getSetAvailOnShutdown();
                if (setAvailOnShutdown == null || (rm = endpointService.getResourceManager()).getRootResources().isEmpty()) continue;
                ArrayList esAvails = new ArrayList();
                avails.put(endpointService, esAvails);
                List<Resource<?>> resources = rm.getResourcesBreadthFirst();
                for (Resource<?> resource : resources) {
                    Collection<MeasurementInstance<?, AvailType<?>>> resourceAvails = resource.getAvails();
                    esAvails.addAll(resourceAvails);
                }
            }
        }
        return avails;
    }

    private File getDataDirectory() {
        File dataDir = this.processType.isManagedDomain() ? new File(System.getProperty("jboss.domain.data.dir")) : ((ServerEnvironment)this.serverEnvironmentValue.getValue()).getServerDataDir();
        File agentDataDir = new File(dataDir, "hawkular-agent");
        agentDataDir.mkdirs();
        return agentDataDir;
    }

    private void startStorageAdapter() throws Exception {
        this.storageAdapter = new HawkularStorageAdapter();
        this.storageAdapter.initialize(this.feedId, this.configuration.getStorageAdapter(), this.diagnostics, this.httpClientBuilder);
        this.metricStorageProxy.setStorageAdapter(this.storageAdapter);
        this.availStorageProxy.setStorageAdapter(this.storageAdapter);
        this.inventoryStorageProxy.setStorageAdapter(this.storageAdapter);
        switch (this.configuration.getDiagnostics().getReportTo()) {
            case LOG: {
                this.diagnosticsReporter = JBossLoggingReporter.forRegistry(this.diagnostics.getMetricRegistry()).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).outputTo(Logger.getLogger(this.getClass())).withLoggingLevel(JBossLoggingReporter.LoggingLevel.DEBUG).build();
                break;
            }
            case STORAGE: {
                this.diagnosticsReporter = StorageReporter.forRegistry(this.diagnostics.getMetricRegistry(), this.configuration.getDiagnostics(), this.storageAdapter).feedId(this.feedId).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
                break;
            }
            default: {
                throw new Exception("Invalid diagnostics type: " + (Object)((Object)this.configuration.getDiagnostics().getReportTo()));
            }
        }
        if (this.configuration.getDiagnostics().isEnabled()) {
            this.diagnosticsReporter.start((long)this.configuration.getDiagnostics().getInterval(), this.configuration.getDiagnostics().getTimeUnits());
        }
    }

    private void startScheduler() throws Exception {
        if (this.schedulerService == null) {
            SchedulerConfiguration schedulerConfig = new SchedulerConfiguration();
            schedulerConfig.setDiagnosticsConfig(this.configuration.getDiagnostics());
            schedulerConfig.setStorageAdapterConfig(this.configuration.getStorageAdapter());
            schedulerConfig.setMetricDispatcherBufferSize(this.configuration.getMetricDispatcherBufferSize());
            schedulerConfig.setMetricDispatcherMaxBatchSize(this.configuration.getMetricDispatcherMaxBatchSize());
            schedulerConfig.setAvailDispatcherBufferSize(this.configuration.getAvailDispatcherBufferSize());
            schedulerConfig.setAvailDispatcherMaxBatchSize(this.configuration.getAvailDispatcherMaxBatchSize());
            this.schedulerService = new SchedulerService(schedulerConfig, this.diagnostics, this.storageAdapter);
        }
        this.schedulerService.start();
    }

    private void registerFeed() throws Exception {
        String desiredFeedId = this.feedId;
        try {
            File feedFile = new File(this.getDataDirectory(), "feedId.txt");
            try {
                String feedIdFromDataFile = Util.read(feedFile);
                feedIdFromDataFile = feedIdFromDataFile.trim();
                if (!desiredFeedId.equals(feedIdFromDataFile)) {
                    log.warnf("Will use feed ID [%s] found in [%s]; note that it is different than our desired feed ID [%s].", feedIdFromDataFile, feedFile, desiredFeedId);
                    this.feedId = feedIdFromDataFile;
                }
                return;
            }
            catch (FileNotFoundException feedIdFromDataFile) {
                Feed.Blueprint feedPojo = new Feed.Blueprint(desiredFeedId, null);
                String jsonPayload = Util.toJson(feedPojo);
                StringBuilder url = Util.getContextUrlString(this.configuration.getStorageAdapter().getUrl(), this.configuration.getStorageAdapter().getInventoryContext());
                url.append("feeds");
                OkHttpClient httpclient = this.httpClientBuilder.getHttpClient();
                Request request = this.httpClientBuilder.buildJsonPostRequest(url.toString(), null, jsonPayload);
                Response httpResponse = httpclient.newCall(request).execute();
                if (httpResponse.code() == 201) {
                    String feedObjectFromServer = httpResponse.body().string();
                    Feed feed = Util.fromJson(feedObjectFromServer, Feed.class);
                    if (desiredFeedId.equals(feed.getId())) {
                        log.infoUsingFeedId(feed.getId());
                    } else {
                        log.errorUnwantedFeedId(feed.getId(), desiredFeedId);
                        log.debugf("Using feed ID [%s]; make sure the agent doesn't lose its data file", feed.getId());
                    }
                    this.feedId = feed.getId();
                } else if (httpResponse.code() == 409) {
                    log.infoFeedIdAlreadyRegistered(this.feedId);
                } else {
                    throw new Exception("status-code=[" + httpResponse.code() + "], reason=[" + httpResponse.message() + "], url=[" + request.urlString() + "]");
                }
                Util.write(this.feedId, feedFile);
            }
        }
        catch (Throwable t) {
            throw new Exception(String.format("Cannot create feed [%s]", desiredFeedId), t);
        }
    }

    private void connectToCommandGatewayCommChannel() throws Exception {
        this.feedComm = new FeedCommProcessor(this.httpClientBuilder, this.configuration, this.feedId, this);
        this.feedComm.connect();
    }

    public SchedulerService getSchedulerService() {
        return this.schedulerService;
    }

    public ModelControllerClientFactory getLocalModelControllerClientFactory() {
        return this.localModelControllerClientFactory;
    }

    public ProtocolServices.Builder createProtocolServicesBuilder() {
        return ProtocolServices.builder(this.feedId, this.diagnostics, this.trustOnlySSLContextValues);
    }

    public DynamicProtocolServices.Builder createDynamicProtocolServicesBuilder() {
        return DynamicProtocolServices.builder(this.feedId, this.trustOnlySSLContextValues);
    }

    public ProtocolServices getProtocolServices() {
        return this.protocolServices;
    }

    public DynamicProtocolServices getDynamicProtocolServices() {
        return this.dynamicProtocolServices;
    }
}

