/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.storage;

import com.squareup.okhttp.Callback;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hawkular.agent.monitor.api.Avail;
import org.hawkular.agent.monitor.api.AvailDataPayloadBuilder;
import org.hawkular.agent.monitor.api.InventoryEvent;
import org.hawkular.agent.monitor.api.MetricDataPayloadBuilder;
import org.hawkular.agent.monitor.diagnostics.Diagnostics;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.storage.AsyncInventoryStorage;
import org.hawkular.agent.monitor.storage.AvailDataPayloadBuilderImpl;
import org.hawkular.agent.monitor.storage.AvailDataPoint;
import org.hawkular.agent.monitor.storage.DataPoint;
import org.hawkular.agent.monitor.storage.HttpClientBuilder;
import org.hawkular.agent.monitor.storage.MetricDataPayloadBuilderImpl;
import org.hawkular.agent.monitor.storage.MetricDataPoint;
import org.hawkular.agent.monitor.storage.StorageAdapter;
import org.hawkular.agent.monitor.util.Util;

public class HawkularStorageAdapter
implements StorageAdapter {
    private static final MsgLogger log = AgentLoggers.getLogger(HawkularStorageAdapter.class);
    private String feedId;
    private MonitorServiceConfiguration.StorageAdapterConfiguration config;
    private Diagnostics diagnostics;
    private HttpClientBuilder httpClientBuilder;
    private AsyncInventoryStorage inventoryStorage;
    private Map<String, String> agentTenantIdHeader;

    @Override
    public void initialize(String feedId, MonitorServiceConfiguration.StorageAdapterConfiguration config, Diagnostics diag, HttpClientBuilder httpClientBuilder) {
        this.feedId = feedId;
        this.config = config;
        this.diagnostics = diag;
        this.httpClientBuilder = httpClientBuilder;
        switch (config.getType()) {
            case HAWKULAR: {
                this.inventoryStorage = new AsyncInventoryStorage(feedId, config, httpClientBuilder, this.diagnostics);
                this.agentTenantIdHeader = null;
                break;
            }
            case METRICS: {
                this.inventoryStorage = null;
                this.agentTenantIdHeader = this.getTenantHeader(config.getTenantId());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type. Please report this bug: " + (Object)((Object)config.getType()));
            }
        }
    }

    @Override
    public MonitorServiceConfiguration.StorageAdapterConfiguration getStorageAdapterConfiguration() {
        return this.config;
    }

    @Override
    public MetricDataPayloadBuilder createMetricDataPayloadBuilder() {
        return new MetricDataPayloadBuilderImpl();
    }

    @Override
    public AvailDataPayloadBuilder createAvailDataPayloadBuilder() {
        return new AvailDataPayloadBuilderImpl();
    }

    @Override
    public void storeMetrics(Set<MetricDataPoint> datapoints, long waitMillis) {
        if (datapoints == null || datapoints.isEmpty()) {
            return;
        }
        Map<String, Set<MetricDataPoint>> byTenantId = this.separateByTenantId(datapoints);
        for (Map.Entry<String, Set<MetricDataPoint>> entry : byTenantId.entrySet()) {
            String tenantId = entry.getKey();
            Set<MetricDataPoint> tenantDataPoints = entry.getValue();
            MetricDataPayloadBuilder payloadBuilder = this.createMetricDataPayloadBuilder();
            payloadBuilder.setTenantId(tenantId);
            for (MetricDataPoint datapoint : tenantDataPoints) {
                long timestamp = datapoint.getTimestamp();
                double value = datapoint.getValue();
                payloadBuilder.addDataPoint(datapoint.getKey(), timestamp, value, datapoint.getMetricType());
            }
            this.store(payloadBuilder, waitMillis);
        }
    }

    @Override
    public void store(final MetricDataPayloadBuilder payloadBuilder, long waitMillis) {
        String jsonPayload = "?";
        try {
            String metricTenantId = payloadBuilder.getTenantId();
            Map<String, String> tenantIdHeader = metricTenantId == null ? this.agentTenantIdHeader : this.getTenantHeader(metricTenantId);
            jsonPayload = payloadBuilder.toPayload().toString();
            StringBuilder url = Util.getContextUrlString(this.config.getUrl(), this.config.getMetricsContext());
            url.append("metrics/data");
            final Request request = this.httpClientBuilder.buildJsonPostRequest(url.toString(), tenantIdHeader, jsonPayload);
            final CountDownLatch latch = waitMillis <= 0L ? null : new CountDownLatch(1);
            final String jsonPayloadFinal = jsonPayload;
            this.httpClientBuilder.getHttpClient().newCall(request).enqueue(new Callback(){

                public void onFailure(Request request2, IOException e) {
                    try {
                        log.errorFailedToStoreMetricData(e, jsonPayloadFinal);
                        HawkularStorageAdapter.this.diagnostics.getStorageErrorRate().mark(1L);
                    }
                    finally {
                        if (latch != null) {
                            latch.countDown();
                        }
                    }
                }

                public void onResponse(Response response) throws IOException {
                    try {
                        if (response.code() != 200) {
                            IOException e = new IOException("status-code=[" + response.code() + "], reason=[" + response.message() + "], url=[" + request.urlString() + "]");
                            log.errorFailedToStoreMetricData(e, jsonPayloadFinal);
                            HawkularStorageAdapter.this.diagnostics.getStorageErrorRate().mark(1L);
                        } else {
                            HawkularStorageAdapter.this.diagnostics.getMetricRate().mark((long)payloadBuilder.getNumberDataPoints());
                        }
                    }
                    finally {
                        if (latch != null) {
                            latch.countDown();
                        }
                    }
                }
            });
            if (latch != null) {
                latch.await(waitMillis, TimeUnit.MILLISECONDS);
            }
        }
        catch (Throwable t) {
            log.errorFailedToStoreMetricData(t, jsonPayload);
            this.diagnostics.getStorageErrorRate().mark(1L);
        }
    }

    @Override
    public void storeAvails(Set<AvailDataPoint> datapoints, long waitMillis) {
        if (datapoints == null || datapoints.isEmpty()) {
            return;
        }
        Map<String, Set<AvailDataPoint>> byTenantId = this.separateByTenantId(datapoints);
        for (Map.Entry<String, Set<AvailDataPoint>> entry : byTenantId.entrySet()) {
            String tenantId = entry.getKey();
            Set<AvailDataPoint> tenantDataPoints = entry.getValue();
            AvailDataPayloadBuilder payloadBuilder = this.createAvailDataPayloadBuilder();
            payloadBuilder.setTenantId(tenantId);
            for (AvailDataPoint datapoint : tenantDataPoints) {
                long timestamp = datapoint.getTimestamp();
                Avail value = datapoint.getValue();
                payloadBuilder.addDataPoint(datapoint.getKey(), timestamp, value);
            }
            this.store(payloadBuilder, waitMillis);
        }
    }

    @Override
    public void store(final AvailDataPayloadBuilder payloadBuilder, long waitMillis) {
        String jsonPayload = "?";
        try {
            String metricTenantId = payloadBuilder.getTenantId();
            Map<String, String> tenantIdHeader = metricTenantId == null ? this.agentTenantIdHeader : this.getTenantHeader(metricTenantId);
            jsonPayload = payloadBuilder.toPayload().toString();
            StringBuilder url = Util.getContextUrlString(this.config.getUrl(), this.config.getMetricsContext());
            url.append("availability/data");
            final Request request = this.httpClientBuilder.buildJsonPostRequest(url.toString(), tenantIdHeader, jsonPayload);
            final CountDownLatch latch = waitMillis <= 0L ? null : new CountDownLatch(1);
            final String jsonPayloadFinal = jsonPayload;
            this.httpClientBuilder.getHttpClient().newCall(request).enqueue(new Callback(){

                public void onFailure(Request request2, IOException e) {
                    try {
                        log.errorFailedToStoreAvailData(e, jsonPayloadFinal);
                        HawkularStorageAdapter.this.diagnostics.getStorageErrorRate().mark(1L);
                    }
                    finally {
                        if (latch != null) {
                            latch.countDown();
                        }
                    }
                }

                public void onResponse(Response response) throws IOException {
                    try {
                        if (response.code() != 200) {
                            IOException e = new IOException("status-code=[" + response.code() + "], reason=[" + response.message() + "], url=[" + request.urlString() + "]");
                            log.errorFailedToStoreAvailData(e, jsonPayloadFinal);
                            HawkularStorageAdapter.this.diagnostics.getStorageErrorRate().mark(1L);
                        } else {
                            HawkularStorageAdapter.this.diagnostics.getAvailRate().mark((long)payloadBuilder.getNumberDataPoints());
                        }
                    }
                    finally {
                        if (latch != null) {
                            latch.countDown();
                        }
                    }
                }
            });
            if (latch != null) {
                latch.await(waitMillis, TimeUnit.MILLISECONDS);
            }
        }
        catch (Throwable t) {
            log.errorFailedToStoreAvailData(t, jsonPayload);
            this.diagnostics.getStorageErrorRate().mark(1L);
        }
    }

    @Override
    public <L> void resourcesAdded(InventoryEvent<L> event) {
        if (this.inventoryStorage != null) {
            this.inventoryStorage.resourcesAdded(event);
        }
    }

    @Override
    public <L> void resourcesRemoved(InventoryEvent<L> event) {
        if (this.inventoryStorage != null) {
            this.inventoryStorage.resourcesRemoved(event);
        }
    }

    @Override
    public void shutdown() {
        if (this.inventoryStorage != null) {
            this.inventoryStorage.shutdown();
        }
    }

    private Map<String, String> getTenantHeader(String tenantId) {
        return Collections.singletonMap("Hawkular-Tenant", tenantId);
    }

    private <T extends DataPoint> Map<String, Set<T>> separateByTenantId(Set<T> dataPoints) {
        HashMap<String, Set<T>> byTenant = new HashMap<String, Set<T>>();
        for (DataPoint dp : dataPoints) {
            HashSet<DataPoint> tenantDataPoints = (HashSet<DataPoint>)byTenant.get(dp.getTenantId());
            if (tenantDataPoints == null) {
                tenantDataPoints = new HashSet<DataPoint>();
                byTenant.put(dp.getTenantId(), tenantDataPoints);
            }
            tenantDataPoints.add(dp);
        }
        return byTenant;
    }
}

