/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.storage;

import java.util.HashSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.hawkular.agent.monitor.diagnostics.Diagnostics;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.scheduler.SchedulerConfiguration;
import org.hawkular.agent.monitor.storage.AvailDataPoint;
import org.hawkular.agent.monitor.storage.StorageAdapter;
import org.hawkular.agent.monitor.util.Consumer;

public class AvailBufferedStorageDispatcher
implements Consumer<AvailDataPoint> {
    private static final MsgLogger log = AgentLoggers.getLogger(AvailBufferedStorageDispatcher.class);
    private final int maxBatchSize;
    private final int bufferSize;
    private final StorageAdapter storageAdapter;
    private final Diagnostics diagnostics;
    private final BlockingQueue<AvailDataPoint> queue;
    private final Worker worker;

    public AvailBufferedStorageDispatcher(SchedulerConfiguration config, StorageAdapter storageAdapter, Diagnostics diagnostics) {
        this.maxBatchSize = config.getAvailDispatcherMaxBatchSize();
        this.bufferSize = config.getAvailDispatcherBufferSize();
        this.storageAdapter = storageAdapter;
        this.diagnostics = diagnostics;
        this.queue = new ArrayBlockingQueue<AvailDataPoint>(this.bufferSize);
        this.worker = new Worker(this.queue);
    }

    public void start() {
        this.worker.start();
    }

    public void shutdown() {
        this.worker.setKeepRunning(false);
        this.worker.interrupt();
        try {
            this.worker.join(60000L);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void accept(AvailDataPoint sample) {
        if (this.queue.remainingCapacity() <= 0) {
            throw new RuntimeException("Avail dispatcher buffer capacity has been exceeded [" + this.bufferSize + "]");
        }
        log.debugf("Availability checked: [%s]->[%s]", sample.getKey(), (Object)sample.getValue());
        this.diagnostics.getAvailStorageBufferSize().inc();
        this.queue.add(sample);
    }

    @Override
    public void report(Throwable e) {
        log.errorAvailCheckFailed(e);
    }

    public class Worker
    extends Thread {
        private final BlockingQueue<AvailDataPoint> queue;
        private boolean keepRunning;

        public Worker(BlockingQueue<AvailDataPoint> queue) {
            super("Hawkular-WildFly-Agent-Storage-Dispatcher-Avail");
            this.keepRunning = true;
            this.queue = queue;
        }

        @Override
        public void run() {
            try {
                while (this.keepRunning) {
                    AvailDataPoint sample = this.queue.take();
                    HashSet<AvailDataPoint> samples = new HashSet<AvailDataPoint>();
                    this.queue.drainTo(samples, AvailBufferedStorageDispatcher.this.maxBatchSize);
                    samples.add(sample);
                    AvailBufferedStorageDispatcher.this.diagnostics.getAvailStorageBufferSize().dec((long)samples.size());
                    AvailBufferedStorageDispatcher.this.storageAdapter.storeAvails(samples, 0L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void setKeepRunning(boolean keepRunning) {
            this.keepRunning = keepRunning;
        }
    }
}

