/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol.platform;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hawkular.agent.monitor.inventory.Name;
import org.hawkular.agent.monitor.protocol.platform.Constants;
import org.hawkular.agent.monitor.protocol.platform.PlatformPath;
import org.hawkular.agent.monitor.protocol.platform.PlatformResourceNode;
import org.hawkular.agent.monitor.util.Util;
import oshi.SystemInfo;
import oshi.hardware.Memory;
import oshi.hardware.PowerSource;
import oshi.hardware.Processor;
import oshi.software.os.OSFileStore;
import oshi.software.os.OperatingSystem;

public class OshiPlatformCache {
    private SystemInfo sysInfo;
    private final Map<Constants.PlatformResourceType, Map<String, ? extends Object>> sysInfoCache;
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock rLock = this.rwLock.readLock();
    private final ReentrantReadWriteLock.WriteLock wLock = this.rwLock.writeLock();
    private final String feedId;
    private final String machineId;

    public OshiPlatformCache(String feedId, String machineId) {
        this.sysInfo = new SystemInfo();
        this.sysInfoCache = new HashMap<Constants.PlatformResourceType, Map<String, ? extends Object>>(5);
        this.feedId = feedId;
        this.machineId = machineId != null ? machineId : Util.getSystemId();
    }

    public void refresh() {
        this.wLock.lock();
        try {
            this.sysInfo = new SystemInfo();
            this.sysInfoCache.clear();
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperatingSystem getOperatingSystem() {
        OperatingSystem ret;
        this.wLock.lock();
        try {
            if (!this.sysInfoCache.containsKey((Object)Constants.PlatformResourceType.OPERATING_SYSTEM)) {
                HashMap<String, OperatingSystem> cache = new HashMap<String, OperatingSystem>(1);
                OperatingSystem os = this.sysInfo.getOperatingSystem();
                cache.put(Constants.PlatformResourceType.OPERATING_SYSTEM.getName().getNameString(), os);
                this.sysInfoCache.put(Constants.PlatformResourceType.OPERATING_SYSTEM, cache);
            }
        }
        finally {
            this.rLock.lock();
            try {
                this.wLock.unlock();
                ret = (OperatingSystem)this.sysInfoCache.get((Object)Constants.PlatformResourceType.OPERATING_SYSTEM).get(Constants.PlatformResourceType.OPERATING_SYSTEM.getName().getNameString());
            }
            finally {
                this.rLock.unlock();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, OSFileStore> getFileStores() {
        Map<String, ? extends Object> ret;
        this.wLock.lock();
        try {
            if (!this.sysInfoCache.containsKey((Object)Constants.PlatformResourceType.FILE_STORE)) {
                HashMap<String, OSFileStore> cache = new HashMap<String, OSFileStore>();
                OSFileStore[] arr = this.sysInfo.getHardware().getFileStores();
                if (arr != null) {
                    for (OSFileStore item : arr) {
                        cache.put(item.getName(), item);
                    }
                }
                this.sysInfoCache.put(Constants.PlatformResourceType.FILE_STORE, cache);
            }
        }
        finally {
            this.rLock.lock();
            try {
                this.wLock.unlock();
                ret = this.sysInfoCache.get((Object)Constants.PlatformResourceType.FILE_STORE);
            }
            finally {
                this.rLock.unlock();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Memory getMemory() {
        Memory ret;
        this.wLock.lock();
        try {
            if (!this.sysInfoCache.containsKey((Object)Constants.PlatformResourceType.MEMORY)) {
                HashMap<String, Memory> cache = new HashMap<String, Memory>(1);
                Memory mem = this.sysInfo.getHardware().getMemory();
                cache.put(Constants.PlatformResourceType.MEMORY.getName().getNameString(), mem);
                this.sysInfoCache.put(Constants.PlatformResourceType.MEMORY, cache);
            }
        }
        finally {
            this.rLock.lock();
            try {
                this.wLock.unlock();
                ret = (Memory)this.sysInfoCache.get((Object)Constants.PlatformResourceType.MEMORY).get(Constants.PlatformResourceType.MEMORY.getName().getNameString());
            }
            finally {
                this.rLock.unlock();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Processor> getProcessors() {
        Map<String, ? extends Object> ret;
        this.wLock.lock();
        try {
            if (!this.sysInfoCache.containsKey((Object)Constants.PlatformResourceType.PROCESSOR)) {
                HashMap<String, Processor> cache = new HashMap<String, Processor>();
                Processor[] arr = this.sysInfo.getHardware().getProcessors();
                if (arr != null) {
                    for (Processor item : arr) {
                        cache.put(String.valueOf(item.getProcessorNumber()), item);
                    }
                }
                this.sysInfoCache.put(Constants.PlatformResourceType.PROCESSOR, cache);
            }
        }
        finally {
            this.rLock.lock();
            try {
                this.wLock.unlock();
                ret = this.sysInfoCache.get((Object)Constants.PlatformResourceType.PROCESSOR);
            }
            finally {
                this.rLock.unlock();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, PowerSource> getPowerSources() {
        Map<String, ? extends Object> ret;
        this.wLock.lock();
        try {
            if (!this.sysInfoCache.containsKey((Object)Constants.PlatformResourceType.POWER_SOURCE)) {
                HashMap<String, PowerSource> cache = new HashMap<String, PowerSource>();
                PowerSource[] arr = this.sysInfo.getHardware().getPowerSources();
                if (arr != null) {
                    for (PowerSource item : arr) {
                        cache.put(item.getName(), item);
                    }
                }
                this.sysInfoCache.put(Constants.PlatformResourceType.POWER_SOURCE, cache);
            }
        }
        finally {
            this.rLock.lock();
            try {
                this.wLock.unlock();
                ret = this.sysInfoCache.get((Object)Constants.PlatformResourceType.POWER_SOURCE);
            }
            finally {
                this.rLock.unlock();
            }
        }
        return ret;
    }

    public Double getPowerSourceMetric(String powerSourceName, Name metricToCollect) {
        Map<String, PowerSource> cache = this.getPowerSources();
        PowerSource powerSource = cache.get(powerSourceName);
        if (powerSource == null) {
            return null;
        }
        if (Constants.POWER_SOURCE_REMAINING_CAPACITY.equals(metricToCollect)) {
            return powerSource.getRemainingCapacity();
        }
        if (Constants.POWER_SOURCE_TIME_REMAINING.equals(metricToCollect)) {
            return powerSource.getTimeRemaining();
        }
        throw new UnsupportedOperationException("Invalid power source metric to collect: " + metricToCollect);
    }

    public Double getProcessorMetric(String processorNumber, Name metricToCollect) {
        Map<String, Processor> cache = this.getProcessors();
        Processor processor = cache.get(processorNumber);
        if (processor == null) {
            return null;
        }
        if (Constants.PROCESSOR_CPU_USAGE.equals(metricToCollect)) {
            return processor.getProcessorCpuLoadBetweenTicks();
        }
        throw new UnsupportedOperationException("Invalid processor metric to collect: " + metricToCollect);
    }

    public Double getFileStoreMetric(String fileStoreNameName, Name metricToCollect) {
        Map<String, OSFileStore> cache = this.getFileStores();
        OSFileStore fileStore = cache.get(fileStoreNameName);
        if (fileStore == null) {
            return null;
        }
        if (Constants.FILE_STORE_TOTAL_SPACE.equals(metricToCollect)) {
            return fileStore.getTotalSpace();
        }
        if (Constants.FILE_STORE_USABLE_SPACE.equals(metricToCollect)) {
            return fileStore.getUsableSpace();
        }
        throw new UnsupportedOperationException("Invalid file store metric to collect: " + metricToCollect);
    }

    public Double getMemoryMetric(Name metricToCollect) {
        Memory mem = this.getMemory();
        if (Constants.MEMORY_AVAILABLE.equals(metricToCollect)) {
            return mem.getAvailable();
        }
        if (Constants.MEMORY_TOTAL.equals(metricToCollect)) {
            return mem.getTotal();
        }
        throw new UnsupportedOperationException("Invalid memory metric to collect: " + metricToCollect);
    }

    public Double getMetric(PlatformResourceNode node, Name metricToCollect) {
        switch (node.getType()) {
            case OPERATING_SYSTEM: {
                return this.getOperatingSystemMetric(metricToCollect);
            }
            case MEMORY: {
                return this.getMemoryMetric(metricToCollect);
            }
            case FILE_STORE: {
                return this.getFileStoreMetric(node.getId(), metricToCollect);
            }
            case PROCESSOR: {
                return this.getProcessorMetric(node.getId(), metricToCollect);
            }
            case POWER_SOURCE: {
                return this.getPowerSourceMetric(node.getId(), metricToCollect);
            }
        }
        throw new IllegalArgumentException("Platform resource node [" + node + "] does not have metrics");
    }

    private Double getOperatingSystemMetric(Name metricToCollect) {
        throw new UnsupportedOperationException("Invalid memory metric to collect: " + metricToCollect);
    }

    public Map<PlatformPath, PlatformResourceNode> discoverResources(PlatformPath platformPath) {
        HashMap<PlatformPath, PlatformResourceNode> results = new HashMap<PlatformPath, PlatformResourceNode>();
        OperatingSystem os = this.getOperatingSystem();
        String osId = this.feedId + "_OperatingSystem";
        PlatformPath osPath = PlatformPath.builder().segment(Constants.PlatformResourceType.OPERATING_SYSTEM, osId).build();
        Constants.PlatformResourceType searchType = platformPath.getLastSegment().getType();
        String searchName = platformPath.getLastSegment().getName();
        if (searchType == Constants.PlatformResourceType.OPERATING_SYSTEM) {
            if ("*".equals(searchName) || searchName.equals(osId)) {
                PlatformResourceNode resNode = new PlatformResourceNode(Constants.PlatformResourceType.OPERATING_SYSTEM, osId);
                results.put(osPath, resNode);
            }
        } else if (searchType == Constants.PlatformResourceType.FILE_STORE) {
            Map<String, OSFileStore> fileStores = this.getFileStores();
            for (OSFileStore fileStore : fileStores.values()) {
                String id = fileStore.getName();
                if (!"*".equals(searchName) && !searchName.equals(id)) continue;
                PlatformPath resourcePath = PlatformPath.builder().segments(osPath).segment(Constants.PlatformResourceType.FILE_STORE, id).build();
                PlatformResourceNode resNode = new PlatformResourceNode(Constants.PlatformResourceType.FILE_STORE, id);
                results.put(resourcePath, resNode);
            }
        } else if (searchType == Constants.PlatformResourceType.MEMORY) {
            String id = Constants.PlatformResourceType.MEMORY.getName().getNameString();
            if ("*".equals(searchName) || searchName.equals(id)) {
                PlatformPath resourcePath = PlatformPath.builder().segments(osPath).segment(Constants.PlatformResourceType.MEMORY, id).build();
                PlatformResourceNode resNode = new PlatformResourceNode(Constants.PlatformResourceType.MEMORY, id);
                results.put(resourcePath, resNode);
            }
        } else if (searchType == Constants.PlatformResourceType.PROCESSOR) {
            Map<String, Processor> processors = this.getProcessors();
            for (Processor processor : processors.values()) {
                String id = String.valueOf(processor.getProcessorNumber());
                if (!"*".equals(searchName) && !searchName.equals(id)) continue;
                PlatformPath resourcePath = PlatformPath.builder().segments(osPath).segment(Constants.PlatformResourceType.PROCESSOR, id).build();
                PlatformResourceNode resNode = new PlatformResourceNode(Constants.PlatformResourceType.PROCESSOR, id);
                results.put(resourcePath, resNode);
            }
        } else if (searchType == Constants.PlatformResourceType.POWER_SOURCE) {
            Map<String, PowerSource> powerSources = this.getPowerSources();
            for (PowerSource powerSource : powerSources.values()) {
                String id = powerSource.getName();
                if (!"*".equals(searchName) && !searchName.equals(id)) continue;
                PlatformPath resourcePath = PlatformPath.builder().segments(osPath).segment(Constants.PlatformResourceType.POWER_SOURCE, id).build();
                PlatformResourceNode resNode = new PlatformResourceNode(Constants.PlatformResourceType.POWER_SOURCE, id);
                results.put(resourcePath, resNode);
            }
        } else {
            throw new IllegalArgumentException("Invalid type - please report this: " + (Object)((Object)searchType));
        }
        return results;
    }

    public String getMachineId() {
        return this.machineId;
    }
}

