/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.dynamicprotocol;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.hawkular.agent.monitor.dynamicprotocol.DynamicEndpointService;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.util.ThreadFactoryGenerator;

public class DynamicProtocolService {
    private static final MsgLogger log = AgentLoggers.getLogger(DynamicProtocolService.class);
    private final String name;
    private final Map<String, DynamicEndpointService> endpointServices;
    private ScheduledExecutorService threadPool;
    private final Map<String, ScheduledFuture<?>> jobs;

    public static Builder builder(String name) {
        return new Builder().name(name);
    }

    public DynamicProtocolService(String name, Map<String, DynamicEndpointService> endpointServices) {
        this.name = name;
        this.endpointServices = endpointServices;
        this.jobs = new HashMap();
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, DynamicEndpointService> getDynamicEndpointServices() {
        Map<String, DynamicEndpointService> map = this.endpointServices;
        synchronized (map) {
            return new HashMap<String, DynamicEndpointService>(this.endpointServices);
        }
    }

    public void start() {
        ThreadFactory threadFactory = ThreadFactoryGenerator.generateFactory(true, "Hawkular WildFly Agent Dynamic Protocol Service Thread Pool");
        this.threadPool = Executors.newScheduledThreadPool(1, threadFactory);
        for (DynamicEndpointService service : this.getDynamicEndpointServices().values()) {
            this.startServiceAndItsJob(service);
        }
    }

    public void stop() {
        try {
            this.threadPool.shutdown();
            this.threadPool.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.jobs.clear();
        }
        for (DynamicEndpointService service : this.getDynamicEndpointServices().values()) {
            service.stop();
        }
    }

    private void startServiceAndItsJob(DynamicEndpointService service) {
        service.start();
        int interval = service.getMonitoredEndpoint().getEndpointConfiguration().getInterval();
        TimeUnit timeUnits = service.getMonitoredEndpoint().getEndpointConfiguration().getTimeUnits();
        long startDelay = new Random().nextInt(60);
        long intervalSecs = TimeUnit.SECONDS.convert(interval, timeUnits);
        ScheduledFuture<?> job = this.threadPool.scheduleWithFixedDelay(service, startDelay, intervalSecs, TimeUnit.SECONDS);
        this.jobs.put(service.getMonitoredEndpoint().getName(), job);
    }

    public void add(DynamicEndpointService newEndpointService) {
        if (newEndpointService == null) {
            throw new IllegalArgumentException("New endpoint service must not be null");
        }
        this.endpointServices.put(newEndpointService.getMonitoredEndpoint().getName(), newEndpointService);
        this.startServiceAndItsJob(newEndpointService);
        log.infoAddedDynamicEndpointService(newEndpointService.toString());
    }

    public void remove(String name) {
        ScheduledFuture<?> doomedJob;
        DynamicEndpointService des = this.endpointServices.remove(name);
        if (des != null) {
            log.infoRemovedDynamicEndpointService(des.toString());
        }
        if ((doomedJob = this.jobs.get(name)) != null) {
            doomedJob.cancel(true);
        }
    }

    public static class Builder {
        private String name;
        private Map<String, DynamicEndpointService> endpointServices = new HashMap<String, DynamicEndpointService>();

        private Builder() {
        }

        public DynamicProtocolService build() {
            return new DynamicProtocolService(this.name, Collections.synchronizedMap(this.endpointServices));
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder endpointService(DynamicEndpointService endpointService) {
            this.endpointServices.put(endpointService.getMonitoredEndpoint().getName(), endpointService);
            return this;
        }
    }
}

