/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.extension;

import org.hawkular.agent.monitor.extension.LocalDMRAttributes;
import org.hawkular.agent.monitor.extension.MonitorServiceAddStepHandler;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.ProtocolService;
import org.hawkular.agent.monitor.protocol.ProtocolServices;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.hawkular.agent.monitor.protocol.dmr.DMRSession;
import org.hawkular.agent.monitor.service.MonitorService;
import org.hawkular.agent.monitor.util.Util;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;

public class LocalDMRAdd
extends MonitorServiceAddStepHandler {
    private static final MsgLogger log = AgentLoggers.getLogger(LocalDMRAdd.class);
    public static final LocalDMRAdd INSTANCE = new LocalDMRAdd();

    private LocalDMRAdd() {
        super(LocalDMRAttributes.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.isBooting()) {
            return;
        }
        MonitorService monitorService = this.getMonitorService(context);
        if (monitorService == null) {
            return;
        }
        MonitorServiceConfiguration config = Util.getMonitorServiceConfiguration(context);
        ProtocolServices newServices = monitorService.createProtocolServicesBuilder().dmrProtocolService(monitorService.getLocalModelControllerClientFactory(), config.getDmrConfiguration()).build();
        EndpointService<DMRNodeLocation, DMRSession> endpointService = newServices.getDmrProtocolService().getEndpointServices().get(context.getCurrentAddressValue());
        ProtocolService<DMRNodeLocation, DMRSession> dmrService = monitorService.getProtocolServices().getDmrProtocolService();
        dmrService.add(endpointService);
    }
}

