/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.extension;

import java.util.Arrays;
import java.util.Collection;
import org.hawkular.agent.monitor.extension.LocalDMRAdd;
import org.hawkular.agent.monitor.extension.LocalDMRAttributes;
import org.hawkular.agent.monitor.extension.LocalDMRRemove;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.extension.MonitorServiceWriteAttributeHandler;
import org.hawkular.agent.monitor.extension.SubsystemExtension;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.ProtocolService;
import org.hawkular.agent.monitor.protocol.ProtocolServices;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.hawkular.agent.monitor.protocol.dmr.DMRSession;
import org.hawkular.agent.monitor.scheduler.SchedulerService;
import org.hawkular.agent.monitor.service.MonitorService;
import org.hawkular.agent.monitor.util.Util;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;

public class LocalDMRDefinition
extends PersistentResourceDefinition {
    public static final LocalDMRDefinition INSTANCE = new LocalDMRDefinition();
    static final String LOCAL_DMR = "local-dmr";

    private LocalDMRDefinition() {
        super(PathElement.pathElement((String)LOCAL_DMR), (ResourceDescriptionResolver)SubsystemExtension.getResourceDescriptionResolver("managed-servers", LOCAL_DMR), (OperationStepHandler)LocalDMRAdd.INSTANCE, (OperationStepHandler)LocalDMRRemove.INSTANCE, OperationEntry.Flag.RESTART_NONE, OperationEntry.Flag.RESTART_NONE);
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(LocalDMRAttributes.ATTRIBUTES);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        Util.registerOnlyRestartAttributes(resourceRegistration, this.getAttributes());
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)LocalDMRAttributes.ENABLED, null, (OperationStepHandler)new MonitorServiceWriteAttributeHandler<Void>(new AttributeDefinition[0]){

            protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
                boolean newBool;
                if (context.isBooting()) {
                    return false;
                }
                boolean currBool = LocalDMRAttributes.ENABLED.resolveValue(context, currentValue).asBoolean();
                if (currBool == (newBool = LocalDMRAttributes.ENABLED.resolveValue(context, newValue).asBoolean())) {
                    return false;
                }
                MonitorService monitorService = this.getMonitorService(context);
                if (monitorService == null || !monitorService.isMonitorServiceStarted()) {
                    return true;
                }
                ProtocolService<DMRNodeLocation, DMRSession> dmrService = monitorService.getProtocolServices().getDmrProtocolService();
                String thisEndpointName = context.getCurrentAddressValue();
                if (newBool) {
                    MonitorServiceConfiguration config = Util.getMonitorServiceConfiguration(context);
                    ProtocolServices newServices = monitorService.createProtocolServicesBuilder().dmrProtocolService(monitorService.getLocalModelControllerClientFactory(), config.getDmrConfiguration()).build();
                    EndpointService<DMRNodeLocation, DMRSession> endpointService = newServices.getDmrProtocolService().getEndpointServices().get(thisEndpointName);
                    dmrService.add(endpointService);
                } else {
                    SchedulerService schedulerService = monitorService.getSchedulerService();
                    dmrService.remove(thisEndpointName, schedulerService);
                }
                return false;
            }

            protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode originalValue, ModelNode newBadValue, Void handback) throws OperationFailedException {
            }
        });
    }
}

