/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol.jmx;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.hawkular.agent.monitor.inventory.NodeLocation;

public class JMXNodeLocation
implements NodeLocation {
    private final Set<String> canonicalKeys;
    private final ObjectName objectName;

    public JMXNodeLocation(ObjectName objectName) {
        this.objectName = objectName;
        this.canonicalKeys = this.objectName == null ? Collections.emptySet() : Collections.unmodifiableSet(new TreeSet<String>(objectName.getKeyPropertyList().keySet()));
    }

    public JMXNodeLocation(String objectName) throws MalformedObjectNameException {
        this(objectName != null ? new ObjectName(objectName) : null);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JMXNodeLocation other = (JMXNodeLocation)obj;
        return !(this.objectName == null ? other.objectName != null : !this.objectName.equals(other.objectName));
    }

    public Set<String> getCanonicalKeys() {
        return this.canonicalKeys;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public int hashCode() {
        return this.objectName != null ? this.objectName.hashCode() : 0;
    }

    public String toString() {
        return this.objectName != null ? this.objectName.getCanonicalName() : "";
    }
}

