/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.naming.ImmediateManagedReferenceFactory;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceController;

public class WildflyCompatibilityUtils {
    public static InetAddress outboundSocketBindingGetResolvedDestinationAddress(OutboundSocketBinding serverBinding) throws UnknownHostException {
        try {
            return serverBinding.getResolvedDestinationAddress();
        }
        catch (NoSuchMethodError _nsme) {
            return serverBinding.getDestinationAddress();
        }
    }

    public static void subsystemSetHostCapable(SubsystemRegistration subsystem) {
        try {
            subsystem.setHostCapable();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public static ManagedReferenceFactory getImmediateManagedReferenceFactory(Object jndiObject) {
        try {
            return new ImmediateManagedReferenceFactory(jndiObject);
        }
        catch (NoClassDefFoundError _ncdfe) {
            return new EAP6ImmediateManagedReferenceFactory(jndiObject);
        }
    }

    public static Injector<ManagedReferenceFactory> getManagedObjectInjectorFromBinderService(BinderService binderService) {
        try {
            return binderService.getManagedObjectInjector();
        }
        catch (NoSuchMethodError _nsme) {
            try {
                Method getManagedObjectInjectorMethod = BinderService.class.getMethod("getManagedObjectInjector", new Class[0]);
                return (Injector)getManagedObjectInjectorMethod.invoke((Object)binderService, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Injector<ServiceBasedNamingStore> getNamingStoreInjectorFromBinderService(BinderService binderService) {
        try {
            return binderService.getNamingStoreInjector();
        }
        catch (NoSuchMethodError _nsme) {
            try {
                Method getManagedObjectInjectorMethod = BinderService.class.getMethod("getNamingStoreInjector", new Class[0]);
                return (Injector)getManagedObjectInjectorMethod.invoke((Object)binderService, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static PathAddress parseCLIStyleAddress(String address) throws IllegalArgumentException {
        try {
            return PathAddress.parseCLIStyleAddress((String)address);
        }
        catch (NoSuchMethodError _nsme) {
            return WildflyCompatibilityUtils._parseCLIStyleAddress(address);
        }
    }

    private static PathAddress _parseCLIStyleAddress(String address) throws IllegalArgumentException {
        PathAddress parsedAddress = PathAddress.EMPTY_ADDRESS;
        if (address == null || address.trim().isEmpty()) {
            return parsedAddress;
        }
        String trimmedAddress = address.trim();
        if (trimmedAddress.charAt(0) != '/' || !Character.isAlphabetic(trimmedAddress.charAt(1))) {
            throw new IllegalArgumentException("Illegal path address '" + address + "' , it is not in a correct CLI format");
        }
        char[] characters = address.toCharArray();
        boolean escaped = false;
        StringBuilder keyBuffer = new StringBuilder();
        StringBuilder valueBuffer = new StringBuilder();
        StringBuilder currentBuffer = keyBuffer;
        block5: for (int i = 1; i < characters.length; ++i) {
            switch (characters[i]) {
                case '/': {
                    if (escaped) {
                        escaped = false;
                        currentBuffer.append(characters[i]);
                        continue block5;
                    }
                    parsedAddress = WildflyCompatibilityUtils.addpathAddressElement(parsedAddress, address, keyBuffer, valueBuffer);
                    keyBuffer = new StringBuilder();
                    valueBuffer = new StringBuilder();
                    currentBuffer = keyBuffer;
                    continue block5;
                }
                case '\\': {
                    if (escaped) {
                        escaped = false;
                        currentBuffer.append(characters[i]);
                        continue block5;
                    }
                    escaped = true;
                    continue block5;
                }
                case '=': {
                    if (escaped) {
                        escaped = false;
                        currentBuffer.append(characters[i]);
                        continue block5;
                    }
                    currentBuffer = valueBuffer;
                    continue block5;
                }
                default: {
                    currentBuffer.append(characters[i]);
                }
            }
        }
        parsedAddress = WildflyCompatibilityUtils.addpathAddressElement(parsedAddress, address, keyBuffer, valueBuffer);
        return parsedAddress;
    }

    private static PathAddress addpathAddressElement(PathAddress parsedAddress, String address, StringBuilder keyBuffer, StringBuilder valueBuffer) {
        if (keyBuffer.length() > 0) {
            if (valueBuffer.length() > 0) {
                return parsedAddress.append(new PathElement[]{PathElement.pathElement((String)keyBuffer.toString(), (String)valueBuffer.toString())});
            }
            throw new IllegalArgumentException("Illegal path address '" + address + "' , it is not in a correct CLI format");
        }
        return parsedAddress;
    }

    public static String getCurrentAddressValue(OperationContext context, ModelNode operation) {
        try {
            return context.getCurrentAddressValue();
        }
        catch (NoSuchMethodError _nsme) {
            return PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        }
    }

    public static class AbstractAddStepHandler
    extends org.jboss.as.controller.AbstractAddStepHandler {
        public AbstractAddStepHandler(AttributeDefinition ... attributes) {
            super(attributes);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
            this.performRuntime(context, operation, model);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        }
    }

    private static class EAP6ImmediateManagedReference
    implements ManagedReference {
        private final Object instance;

        public EAP6ImmediateManagedReference(Object instance) {
            this.instance = instance;
        }

        public void release() {
        }

        public Object getInstance() {
            return this.instance;
        }
    }

    private static class EAP6ImmediateManagedReferenceFactory
    implements ManagedReferenceFactory {
        private final ManagedReference reference;

        public EAP6ImmediateManagedReferenceFactory(Object instance) {
            this.reference = new EAP6ImmediateManagedReference(instance);
        }

        public ManagedReference getReference() {
            return this.reference;
        }
    }
}

